/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.overlay.CircleOverlay;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.util.message.Message;

public class Circle3PointOverlay
extends CircleOverlay {
    private static final double EPSILON = 1.0E-5;
    private static final int POINT2_HANDLE_INDEX = 102;
    private static final int POINT3_HANDLE_INDEX = 103;
    private double pt1x;
    private double pt1y;
    private double pt2x;
    private double pt2y;
    private double pt3x;
    private double pt3y;
    private boolean isValid = true;

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder, boolean bl) {
        if (this.isValid) {
            super.paintShape(bufferedImageHolder, bl);
            if (!this.isSelected()) {
                this.handles[this.translationHandleIndex].paintHandle(bufferedImageHolder.graphics, true);
            }
        }
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 102: {
                double[] dArray2 = this.toScreen(dArray);
                this.pt2x = dArray2[0];
                this.pt2y = dArray2[1];
                this.m = this.toImage(new double[]{(this.pt1x + this.pt2x) / 2.0, (this.pt1y + this.pt2y) / 2.0});
                this.setPointOnCircumference(dArray);
                this.isValid = Circle3PointOverlay.isNotZero(this.pt2x - this.pt1x) && Circle3PointOverlay.isNotZero(this.pt2y - this.pt1y);
                this.toScreen();
                break;
            }
            case 103: {
                double[] dArray3 = this.toScreen(dArray);
                this.pt3x = dArray3[0];
                this.pt3y = dArray3[1];
                double d = Math.sqrt((this.pt2x - this.pt3x) * (this.pt2x - this.pt3x) + (this.pt2y - this.pt3y) * (this.pt2y - this.pt3y));
                double d2 = Math.sqrt((this.pt1x - this.pt3x) * (this.pt1x - this.pt3x) + (this.pt1y - this.pt3y) * (this.pt1y - this.pt3y));
                double d3 = Math.sqrt((this.pt2x - this.pt1x) * (this.pt2x - this.pt1x) + (this.pt2y - this.pt1y) * (this.pt2y - this.pt1y));
                double d4 = Math.acos((d2 * d2 + d3 * d3 - d * d) / (2.0 * d2 * d3));
                double d5 = Math.acos((d * d + d3 * d3 - d2 * d2) / (2.0 * d * d3));
                double d6 = Math.acos((d * d + d2 * d2 - d3 * d3) / (2.0 * d * d2));
                double d7 = Math.sin(2.0 * d4) / 2.0;
                double d8 = Math.sin(2.0 * d5) / 2.0;
                double d9 = Math.sin(2.0 * d6) / 2.0;
                double d10 = d7 + d8 + d9;
                this.isValid = Circle3PointOverlay.isNotZero(d4) && Circle3PointOverlay.isNotZero(d5) && Circle3PointOverlay.isNotZero(d6) && Circle3PointOverlay.isNotZero(d10);
                double d11 = (d7 * this.pt1x + d8 * this.pt2x + d9 * this.pt3x) / d10;
                double d12 = (d7 * this.pt1y + d8 * this.pt2y + d9 * this.pt3y) / d10;
                this.m = this.toImage(new double[]{d11, d12});
                this.setPointOnCircumference(dArray);
                this.toScreen();
                break;
            }
            case 3: {
                if (!this.isCompleted()) {
                    this.handleDragged(103, dArray);
                    break;
                }
            }
            default: {
                super.handleInteraction(n, dArray);
            }
        }
        this.setSaved(false);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        Object object;
        int n2 = n;
        switch (n) {
            case 1: {
                object = this.toScreen(dArray);
                this.pt1x = object[0];
                this.pt1y = object[1];
                this.m = (double[])dArray.clone();
                this.activeHandleIndex = 102;
                ++n2;
                break;
            }
            case 2: {
                this.activeHandleIndex = 102;
                ++n2;
                break;
            }
            case 3: {
                this.handleDragged(102, dArray);
                if (this.isValid) {
                    this.activeHandleIndex = 103;
                    ++n2;
                    break;
                }
                Message.warning(Messages.getString("ACTION_MAIN_ROIS_DRAW_CIRCLE_3POINT_WARNING_POINT2"));
                this.activeHandleIndex = 102;
                break;
            }
            case 4: {
                this.handleDragged(103, dArray);
                if (this.isValid) {
                    n2 = -1;
                    break;
                }
                Message.warning(Messages.getString("ACTION_MAIN_ROIS_DRAW_CIRCLE_3POINT_WARNING_POINT3"));
                this.activeHandleIndex = 103;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n2 == -1 && (object = (Object)this.createAnnotation()) != null) {
            ((Overlay)object).setVisible(Circle3PointOverlay.getTextAnnotationLevel().isTextAnnotationVisible());
        }
        return n2;
    }

    @Override
    protected boolean splitDragged() {
        return this.initStep < 3;
    }

    private static boolean isNotZero(double d) {
        return d > 1.0E-5 || d < -1.0E-5;
    }
}

