/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.data.shared.overlay.BitmapOverlayShrink;
import com.agfa.pacs.listtext.dicomobject.presentation.OverlayContainer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.CachedOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.StringOverlayData;

public class BitmapOverlay {
    private String providerUID = null;
    private int rows;
    private int columns;
    private String description;
    private String overlayType;
    private String overlayLabel;
    private String subType;
    private int originX;
    private int originY;
    private IOverlayData data;
    private CachedOverlayData cachedData;

    public BitmapOverlay(OverlayFrame overlayFrame) {
        this.rows = overlayFrame.getHeight();
        this.columns = overlayFrame.getWidth();
        this.originX = overlayFrame.getOrigX();
        this.originY = overlayFrame.getOrigY();
        this.description = overlayFrame.getOverlay().getDescription();
        this.overlayType = overlayFrame.getOverlay().getType();
        this.overlayLabel = overlayFrame.getOverlay().getLabel();
        this.subType = overlayFrame.getOverlay().getSubtype();
        this.setOverlayData(overlayFrame.getOverlayData(), false);
        this.providerUID = overlayFrame.getOverlay().getProviderUID();
    }

    public BitmapOverlay(int n, int n2, String string, int n3, int n4, String string2, String string3, IOverlayData iOverlayData, String string4) {
        this.rows = n;
        this.columns = n2;
        this.description = string;
        this.originX = n3;
        this.originY = n4;
        this.overlayType = string2;
        this.overlayLabel = string4;
        this.subType = string3;
        this.setOverlayData(iOverlayData, false);
    }

    public BitmapOverlay(int n, int n2, String string, int n3, int n4, String string2, String string3, IOverlayData iOverlayData, String string4, boolean bl) {
        this.rows = n;
        this.columns = n2;
        this.description = string;
        this.originX = n3;
        this.originY = n4;
        this.overlayType = string2;
        this.overlayLabel = string4;
        this.subType = string3;
        this.setOverlayData(iOverlayData, !bl);
    }

    public OverlayFrame toOverlayFrame(OverlayContainer overlayContainer) {
        OverlayFrame overlayFrame = new OverlayFrame(overlayContainer, -1);
        overlayFrame.setOverlayData(this.originY, this.originX, this.columns, this.rows, this.data);
        return overlayFrame;
    }

    public void creationDone(boolean bl) {
        if (bl) {
            this.tryToShrink();
        }
    }

    public String getOverlayType() {
        return this.overlayType;
    }

    public String getOverlaySubType() {
        return this.subType;
    }

    public String getProviderUID() {
        return this.providerUID;
    }

    public void setOverlayData(IOverlayData iOverlayData, boolean bl) {
        if (iOverlayData == null) {
            return;
        }
        this.data = iOverlayData;
        this.cachedData = new CachedOverlayData(this.data);
        if (bl) {
            this.tryToShrink();
        }
    }

    protected void tryToShrink() {
        int[] nArray = new int[4];
        IOverlayData iOverlayData = this.crop(this.data, nArray);
        if (iOverlayData != null) {
            this.originX = nArray[0];
            this.originY = nArray[1];
            this.columns = nArray[2];
            this.rows = nArray[3];
            this.data = iOverlayData;
            this.cachedData = new CachedOverlayData(this.data);
        }
    }

    private IOverlayData crop(IOverlayData iOverlayData, int[] nArray) {
        StringOverlayData stringOverlayData = null;
        byte[] byArray = iOverlayData.toPackedBits();
        BitmapOverlayShrink bitmapOverlayShrink = new BitmapOverlayShrink(this.rows, this.columns, new int[]{this.originY, this.originX});
        byte[] byArray2 = bitmapOverlayShrink.tryToShrink(byArray);
        int[] nArray2 = bitmapOverlayShrink.getOriginCopy();
        nArray[0] = nArray2[0];
        nArray[1] = nArray2[1];
        nArray[2] = bitmapOverlayShrink.getColumns();
        nArray[3] = bitmapOverlayShrink.getRows();
        stringOverlayData = new StringOverlayData(byArray2, bitmapOverlayShrink.getColumns(), bitmapOverlayShrink.getRows());
        return stringOverlayData;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public IOverlayData getData() {
        return this.cachedData;
    }

    public int getBitsAllocated() {
        return 1;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.overlayLabel;
    }

    public void setLabel(String string) {
        this.overlayLabel = string;
    }
}

