/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.overlay.AbstractDoubleLineOverlay;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.OverlayAngleInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import java.util.Collections;
import java.util.List;

public class AngleOverlay
extends AbstractDoubleLineOverlay {
    public AngleOverlay() {
        super(TianiSubType.Angle, AbstractRegionSpacingOverlay.ImageRegionSpacingMode.DISABLED);
    }

    public AngleOverlay(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, AnnotationUnits annotationUnits) {
        super(TianiSubType.Angle, AbstractRegionSpacingOverlay.ImageRegionSpacingMode.DISABLED, d, d2, d3, d4, d5, d6, d7, d8, annotationUnits);
    }

    @Override
    double calculateMeasurementResult() {
        IImageInformation iImageInformation = this.getImageInformation();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        if (ImageDef.hasPixelAspectRatioOtherThan1to1(iImageInformation)) {
            dArray2[0] = this.qxi - this.pxi;
            dArray2[1] = this.qyi - this.pyi;
            dArray[0] = this.sxi - this.rxi;
            dArray[1] = this.syi - this.ryi;
        } else {
            double d = this.getDataPixelSizeX();
            double d2 = this.getDataPixelSizeY();
            dArray2[0] = (this.q[0] - this.p[0]) * d;
            dArray2[1] = (this.q[1] - this.p[1]) * d2;
            dArray[0] = (this.s[0] - this.r[0]) * d;
            dArray[1] = (this.s[1] - this.r[1]) * d2;
        }
        return Math.acos((dArray2[0] * dArray[0] + dArray2[1] * dArray[1]) / (Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]) * Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1]))) / Math.PI * 180.0;
    }

    @Override
    List<IOverlayInformation> updateAnnotation() {
        double d = this.getMeasurementResult();
        OverlayAngleInformation overlayAngleInformation = new OverlayAngleInformation(OverlayInformationID.MANDATORY, d, 180.0 - d);
        return Collections.singletonList(overlayAngleInformation);
    }

    @Override
    void onTranslation(double d, double d2) {
    }
}

