/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractDoubleLineOverlay
extends AbstractRegionSpacingOverlay
implements IGraphicObjectContainer {
    private static final int HIGHLIGHTED_LINE_WIDTH = GUI.getScaledDiagnosticInt((int)1);
    protected double[] p;
    protected double[] q = new double[2];
    protected double[] r;
    protected double[] s;
    protected int pxi;
    protected int pyi;
    protected int qxi;
    protected int qyi;
    protected int rxi;
    protected int ryi;
    protected int sxi;
    protected int syi;
    private final TianiSubType type;
    protected boolean isSecondLineHighlighted;

    AbstractDoubleLineOverlay(TianiSubType tianiSubType, AbstractRegionSpacingOverlay.ImageRegionSpacingMode imageRegionSpacingMode) {
        super(tianiSubType.name(), imageRegionSpacingMode);
        this.p = new double[2];
        this.r = new double[2];
        this.s = new double[2];
        this.type = tianiSubType;
    }

    AbstractDoubleLineOverlay(TianiSubType tianiSubType, AbstractRegionSpacingOverlay.ImageRegionSpacingMode imageRegionSpacingMode, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, AnnotationUnits annotationUnits) {
        this(tianiSubType, imageRegionSpacingMode);
        this.p[0] = d;
        this.p[1] = d2;
        this.q[0] = d3;
        this.q[1] = d4;
        this.r[0] = d5;
        this.r[1] = d6;
        this.s[0] = d7;
        this.s[1] = d8;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    @Override
    public double[] getXCoordinates() {
        double[] dArray = new double[]{this.p[0], this.q[0], this.r[0], this.s[0]};
        return dArray;
    }

    @Override
    public double[] getYCoordinates() {
        double[] dArray = new double[]{this.p[1], this.q[1], this.r[1], this.s[1]};
        return dArray;
    }

    @Override
    public int getPointCount() {
        return 4;
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.q = new double[2];
        this.p = new double[2];
        this.r = new double[2];
        this.s = new double[2];
        this.makeHandles();
    }

    @Override
    public boolean isROI() {
        return true;
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[5];
        this.handles[0] = new PresentationHandle(this.pxi, this.pyi);
        this.handles[1] = new PresentationHandle(this.qxi, this.qyi);
        this.handles[2] = new PresentationHandle(this.rxi, this.ryi);
        this.handles[3] = new PresentationHandle(this.sxi, this.syi);
        this.handles[4] = new TranslationHandle((this.pxi + this.qxi + this.rxi + this.sxi) / 4, (this.pyi + this.qyi + this.ryi + this.syi) / 4);
        this.translationHandleIndex = 4;
    }

    @Override
    void toScreenImpl() {
        double[] dArray = this.toScreen(this.p);
        this.pxi = (int)dArray[0];
        this.pyi = (int)dArray[1];
        dArray = this.toScreen(this.q);
        this.qxi = (int)dArray[0];
        this.qyi = (int)dArray[1];
        dArray = this.toScreen(this.r);
        this.rxi = (int)dArray[0];
        this.ryi = (int)dArray[1];
        dArray = this.toScreen(this.s);
        this.sxi = (int)dArray[0];
        this.syi = (int)dArray[1];
        this.handles[0].setPosition(this.pxi, this.pyi);
        this.handles[1].setPosition(this.qxi, this.qyi);
        this.handles[2].setPosition(this.rxi, this.ryi);
        this.handles[3].setPosition(this.sxi, this.syi);
        double[] dArray2 = new double[]{(this.p[0] + this.q[0] + this.r[0] + this.s[0]) / 4.0, (this.p[1] + this.q[1] + this.r[1] + this.s[1]) / 4.0};
        dArray2 = this.toScreen(dArray2);
        this.handles[4].setPosition((int)dArray2[0], (int)dArray2[1]);
        this.bounds.x = Math.min(Math.min(this.rxi, this.sxi), Math.min(this.pxi, this.qxi)) - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = Math.min(Math.min(this.ryi, this.syi), Math.min(this.pyi, this.qyi)) - PresentationHandle.HANDLE_SIZE;
        int n = Math.max(Math.max(this.pxi, this.qxi), Math.max(this.rxi, this.sxi));
        int n2 = Math.max(Math.max(this.pyi, this.qyi), Math.max(this.ryi, this.syi));
        this.bounds.width = n - this.bounds.x + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = n2 - this.bounds.y + 2 * PresentationHandle.HANDLE_SIZE;
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            if (this.pxi - this.qxi != 0 && Math.abs(this.pyi - this.qyi) / Math.abs(this.pxi - this.qxi) < 1) {
                bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi - 1, this.qxi, this.qyi - 1);
                bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi + 1, this.qxi, this.qyi + 1);
            } else {
                bufferedImageHolder.graphics.drawLine(this.pxi - 1, this.pyi, this.qxi - 1, this.qyi);
                bufferedImageHolder.graphics.drawLine(this.pxi + 1, this.pyi, this.qxi + 1, this.qyi);
            }
            this.drawSecondLine(bufferedImageHolder, this.isSecondLineHighlighted ? HIGHLIGHTED_LINE_WIDTH + 1 : 1);
            if (this.isSecondLineHighlighted) {
                bufferedImageHolder.graphics.drawLine(this.rxi, this.ryi, this.sxi, this.syi);
            }
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi, this.qxi, this.qyi);
        if (this.isSecondLineHighlighted) {
            int n = 1;
            while (n <= HIGHLIGHTED_LINE_WIDTH) {
                this.drawSecondLine(bufferedImageHolder, n);
                ++n;
            }
        } else {
            bufferedImageHolder.graphics.drawLine(this.rxi, this.ryi, this.sxi, this.syi);
        }
    }

    private void drawSecondLine(BufferedImageHolder bufferedImageHolder, int n) {
        if (this.rxi - this.sxi != 0 && Math.abs(this.ryi - this.syi) / Math.abs(this.rxi - this.sxi) < 1) {
            bufferedImageHolder.graphics.drawLine(this.rxi, this.ryi - n, this.sxi, this.syi - n);
            bufferedImageHolder.graphics.drawLine(this.rxi, this.ryi + n, this.sxi, this.syi + n);
        } else {
            bufferedImageHolder.graphics.drawLine(this.rxi - n, this.ryi, this.sxi - n, this.syi);
            bufferedImageHolder.graphics.drawLine(this.rxi + n, this.ryi, this.sxi + n, this.syi);
        }
    }

    @Override
    void paintAdditionalConnections(BufferedImageHolder bufferedImageHolder) {
        Stroke stroke = bufferedImageHolder.graphics.getStroke();
        int n = (this.pxi + this.qxi) / 2;
        int n2 = (this.pyi + this.qyi) / 2;
        int n3 = (this.rxi + this.sxi) / 2;
        int n4 = (this.ryi + this.syi) / 2;
        Color color = bufferedImageHolder.graphics.getColor();
        bufferedImageHolder.graphics.setColor(Color.black);
        bufferedImageHolder.graphics.setStroke(CONNECTION_OUTLINE_STROKE);
        bufferedImageHolder.graphics.drawLine(n, n2, n3, n4);
        bufferedImageHolder.graphics.setColor(color);
        bufferedImageHolder.graphics.setStroke(CONNECTION_STROKE);
        bufferedImageHolder.graphics.drawLine(n, n2, n3, n4);
        bufferedImageHolder.graphics.setStroke(stroke);
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 0: {
                this.p = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 1: {
                this.q = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 2: {
                this.r = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 3: {
                this.s = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 4: {
                if (!this.isCompleted()) {
                    this.handleDragged(3, dArray);
                    return;
                }
                double d = dArray[0] - (this.q[0] + this.p[0] + this.r[0] + this.s[0]) / 4.0;
                double d2 = dArray[1] - (this.q[1] + this.p[1] + this.r[1] + this.s[1]) / 4.0;
                this.p[0] = this.p[0] + d;
                this.p[1] = this.p[1] + d2;
                this.q[0] = this.q[0] + d;
                this.q[1] = this.q[1] + d2;
                this.r[0] = this.r[0] + d;
                this.r[1] = this.r[1] + d2;
                this.s[0] = this.s[0] + d;
                this.s[1] = this.s[1] + d2;
                this.onTranslation(d, d2);
                this.toScreenOnTranslation();
            }
        }
        this.setSaved(false);
    }

    abstract void onTranslation(double var1, double var3);

    @Override
    protected boolean splitDragged() {
        return this.initStep != 2;
    }

    @Override
    public void setSize(int n, int n2, ImageState imageState) {
        super.setSize(n, n2, imageState);
        if (!this.isCompleted() && this.ownedCompanions != null) {
            this.ownedCompanions[0].setSize(n, n2, imageState);
        }
    }

    @Override
    protected void pressedWhileInit(int n, int n2) {
        double[] dArray = this.toImage(n, n2);
        switch (this.initStep) {
            case 1: {
                this.handleDragged(0, dArray);
                this.handleDragged(1, dArray);
                this.activeHandleIndex = 1;
                break;
            }
            case 2: {
                this.handleDragged(1, dArray);
                this.activeHandleIndex = 1;
                break;
            }
            case 3: {
                this.handleDragged(2, dArray);
                this.handleDragged(3, dArray);
                this.createAnnotation();
                this.ownedCompanions[0].setSize(this.width, this.height, this.getImageState());
                this.activeHandleIndex = 3;
                break;
            }
            case 4: {
                this.handleDragged(3, dArray);
                this.activeHandleIndex = 3;
            }
        }
    }

    @Override
    protected void releasedWhileInit(int n, int n2) {
        switch (this.initStep) {
            case 1: {
                ++this.initStep;
                this.activeHandleIndex = 1;
                break;
            }
            case 2: {
                ++this.initStep;
                break;
            }
            case 3: {
                this.activeHandleIndex = 3;
                ++this.initStep;
                break;
            }
            default: {
                this.initStep = -1;
            }
        }
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        double[] dArray2 = this.toScreen(dArray);
        int n2 = (int)(dArray2[0] + 0.5);
        int n3 = (int)(dArray2[1] + 0.5);
        this.pressedWhileInit(n2, n3);
        return n;
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(30, " ");
    }

    @Override
    protected void translationAction(int n, int n2, PresentationObject presentationObject) {
        if (this.fireing) {
            return;
        }
        this.fireTranslation(n, n2);
        if (presentationObject instanceof TextOverlay) {
            PresentationHandle presentationHandle = this.handles[0];
            this.handleDragged(0, this.toImage(presentationHandle.getX() + n, presentationHandle.getY() + n2));
        } else {
            this.p[0] = this.p[0] + ((double)n * this.unitx[0] + (double)n2 * this.unity[0]);
            this.p[1] = this.p[1] + ((double)n * this.unitx[1] + (double)n2 * this.unity[1]);
            this.q[0] = this.q[0] + ((double)n * this.unitx[0] + (double)n2 * this.unity[0]);
            this.q[1] = this.q[1] + ((double)n * this.unitx[1] + (double)n2 * this.unity[1]);
            this.toScreen();
        }
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(this.type);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicData(new float[]{(float)this.p[0], (float)this.p[1], (float)this.q[0], (float)this.q[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(this.type);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicData(new float[]{(float)this.r[0], (float)this.r[1], (float)this.s[0], (float)this.s[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            AbstractDoubleLineOverlay abstractDoubleLineOverlay = (AbstractDoubleLineOverlay)presentationObject;
            abstractDoubleLineOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.p), ReferencedObjectsCloning.clone(this.q), ReferencedObjectsCloning.clone(this.r), ReferencedObjectsCloning.clone(this.s));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    public void setClonedParameters(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.p = dArray;
        this.q = dArray2;
        this.r = dArray3;
        this.s = dArray4;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        AbstractDoubleLineOverlay abstractDoubleLineOverlay = (AbstractDoubleLineOverlay)iTransformableOverlay;
        this.p = iOverlayPointModifier.convert(abstractDoubleLineOverlay.p);
        this.q = iOverlayPointModifier.convert(abstractDoubleLineOverlay.q);
        this.r = iOverlayPointModifier.convert(abstractDoubleLineOverlay.r);
        this.s = iOverlayPointModifier.convert(abstractDoubleLineOverlay.s);
    }

    protected void createBoundingShape() {
        this.toScreen();
        this.outBounds = new ArrayList(2);
        this.outBounds.add(this.createBoundingLine(this.pxi, this.pyi, this.qxi, this.qyi));
        this.outBounds.add(this.createBoundingLine(this.rxi, this.ryi, this.sxi, this.syi));
    }

    @Override
    public boolean inBounds(int n, int n2) {
        boolean bl = false;
        if (this.isSelected()) {
            bl = this.isHandleClicked(n, n2);
        }
        if (!bl) {
            this.createBoundingShape();
            return super.inBounds(n, n2);
        }
        return bl;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return n == 1;
    }

    @Override
    public boolean supportsProfile() {
        return false;
    }
}

