/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.ISaveItemFactory;
import com.agfa.pacs.impaxee.save.ISaveManager;
import com.agfa.pacs.impaxee.splitsort.FrameObjectDataComparator;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.RawDataContainerTokenCreator;
import com.tiani.base.data.RawDataContainerTokenData;
import com.tiani.base.data.TokenData;
import com.tiani.base.data.TokenListener;
import com.tiani.jvision.patinfo.TToken;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class SecondaryCaptureUnsavedItem
implements ISaveItemFactory,
TokenListener {
    private static final Icon ICON = IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_notsaved.svg");
    private List<TToken> tokens;
    private ISaveManager saveManager;
    private List<IDataObject> data = new ArrayList<IDataObject>(1);
    private List<IFrameObjectData> objects = new ArrayList<IFrameObjectData>();
    private IEventEngine eEngine;
    private int exportNotification;
    private JList<TToken> tokenList;
    private boolean needsUserInteractionForSave;

    public SecondaryCaptureUnsavedItem(ISeriesData iSeriesData, boolean bl) {
        assert (iSeriesData != null);
        this.needsUserInteractionForSave = bl;
        this.data.add(iSeriesData);
        this.eEngine = EventEngineFactory.getInstance();
        this.exportNotification = this.eEngine.getEventID("EXPORT_NOTIFICATION");
        for (IImageObjectData iImageObjectData : iSeriesData.getObjects()) {
            this.objects.addAll(Arrays.asList(iImageObjectData.frames()));
        }
        SortField sortField = new SortField();
        sortField.setTag(2097171);
        Collections.sort(this.objects, new FrameObjectDataComparator(new SortField[]{sortField}));
        this.tokens = new ArrayList<TToken>(this.objects.size());
        for (IFrameObjectData iFrameObjectData : this.objects) {
            TokenData tokenData = iFrameObjectData.getTokenData();
            if (!tokenData.isFinalToken()) {
                iFrameObjectData.setRawDataContainerToken();
                tokenData = iFrameObjectData.getTokenData();
                if (tokenData instanceof RawDataContainerTokenData) {
                    RawDataContainerTokenCreator.getInstance().addTokenData((RawDataContainerTokenData)tokenData);
                }
            }
            this.tokens.add(new TToken(tokenData, this));
        }
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getVisibleName() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm/dd.MM.yyyy");
        Date date = this.objects.get(0).getDicomObject().getDate(524330);
        if (date != null) {
            String string = simpleDateFormat.format(date);
            return "Sec. Capture (" + string + ")";
        }
        return "Sec. Capture";
    }

    @Override
    public ISaveItem newSaveItem(IPatientRepresentation iPatientRepresentation) {
        SecondaryCaptureSavePanel secondaryCaptureSavePanel = new SecondaryCaptureSavePanel(this.tokens, this.needsUserInteractionForSave);
        IEventListenerProvider iEventListenerProvider = this.eEngine.createListenerProvider((IEventListener)secondaryCaptureSavePanel);
        this.eEngine.register(iEventListenerProvider, "lta.app");
        return secondaryCaptureSavePanel;
    }

    @Override
    public void tokenChanged(TokenData tokenData) {
        if (this.tokenList != null) {
            this.tokenList.repaint();
        }
    }

    private class SaveSCButtonAction
    extends AbstractAction {
        public SaveSCButtonAction() {
            super(Messages.getString("SecondaryCaptureUnsavedItem.SaveButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IPerform iPerform = DataManager.getInstance().getDataPerform("EXPORT_SC_DIRECT");
            iPerform.perform(new IPerform.DefaultPerformContext(SecondaryCaptureUnsavedItem.this.saveManager.getComponent(), null), SecondaryCaptureUnsavedItem.this.data);
        }
    }

    private class SecondaryCaptureSavePanel
    extends JPanel
    implements ISaveItem,
    IEventListener {
        private boolean exportSuccessful;
        private IStoreHandler storeHandler;

        public SecondaryCaptureSavePanel(List<TToken> list, boolean bl) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("SecondaryCaptureUnsavedItem.FrameText")));
            SecondaryCaptureUnsavedItem.this.tokenList = new JList<TToken>(list.toArray(new TToken[list.size()])){

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return true;
                }

                @Override
                public boolean getScrollableTracksViewportHeight() {
                    return false;
                }
            };
            SecondaryCaptureUnsavedItem.this.tokenList.setCellRenderer(new TokenRenderer());
            SecondaryCaptureUnsavedItem.this.tokenList.setVisibleRowCount(0);
            SecondaryCaptureUnsavedItem.this.tokenList.setLayoutOrientation(2);
            JScrollPane jScrollPane = new JScrollPane(SecondaryCaptureUnsavedItem.this.tokenList);
            Dimension dimension = this.getPreferredSize();
            int n = list.get((int)0).getSize().width;
            dimension.width = 5 * n + n / 2;
            jScrollPane.setPreferredSize(dimension);
            if (bl) {
                JButton jButton = new JButton(new SaveSCButtonAction());
                JPanel jPanel2 = new JPanel();
                jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                jPanel2.setLayout(new BoxLayout(jPanel2, 0));
                jPanel2.setAlignmentX(0.5f);
                jPanel2.add(jButton);
                jPanel.add((Component)jButton, "South");
            }
            jPanel.add((Component)jScrollPane, "Center");
            this.add((Component)jPanel, "Center");
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public int getProgressAmount() {
            return 0;
        }

        @Override
        public List<IStoreHandler> getStoreHandlers() {
            if (this.storeHandler == null) {
                return null;
            }
            return Collections.singletonList(this.storeHandler);
        }

        @Override
        public boolean isSaveable() {
            if (SecondaryCaptureUnsavedItem.this.needsUserInteractionForSave) {
                return this.exportSuccessful;
            }
            return true;
        }

        @Override
        public boolean save(boolean bl) {
            if (SecondaryCaptureUnsavedItem.this.needsUserInteractionForSave) {
                return false;
            }
            IPerform iPerform = DataManager.getInstance().getDataPerform("EXPORT_SC_DIRECT");
            Component component = null;
            if (SecondaryCaptureUnsavedItem.this.saveManager != null) {
                component = SecondaryCaptureUnsavedItem.this.saveManager.getComponent();
            }
            IPerform.IPerformResult iPerformResult = iPerform.perform(new IPerform.DefaultPerformContext(component, null), SecondaryCaptureUnsavedItem.this.data);
            this.storeHandler = iPerformResult.getStoreHandler();
            return iPerformResult.getReturnCode() > 0;
        }

        @Override
        public void setSaveManager(ISaveManager iSaveManager) {
            SecondaryCaptureUnsavedItem.this.saveManager = iSaveManager;
        }

        public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            if (iEvent.getEventID() == SecondaryCaptureUnsavedItem.this.exportNotification) {
                String string = (String)iEvent.getPayload();
                if (string == null || string.length() == 0 || string.contains("/")) {
                    return false;
                }
                for (IFrameObjectData iFrameObjectData : SecondaryCaptureUnsavedItem.this.objects) {
                    if (!iFrameObjectData.getDicomObject().getString(524312).equals(string)) continue;
                    this.exportSuccessful = true;
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            return false;
        }

        public IListenerSynchronization getSync() {
            return null;
        }
    }

    private static class TokenRenderer
    implements ListCellRenderer<TToken> {
        private TokenRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TToken> jList, TToken tToken, int n, boolean bl, boolean bl2) {
            return tToken;
        }
    }
}

