/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.dicom.YesNo;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.equipment.ConversionType;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlane;
import com.agfa.pacs.listtext.pixeldata.frame.PixelDataUtilities;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.image.LayeredView;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.SecondaryCaptureListener;
import com.tiani.jvision.overlay.BitmapOverlay;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.workers.ProgressListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class SecondaryCapture
implements Runnable {
    private static final ALogger log = ALogger.getLogger(SecondaryCapture.class);
    private SecondaryCaptureListener scInteractor;
    private Map<IImageObjectData, List<VisData>> images;
    private List<IImageObjectData> orderedImages;
    private Map<IFrameObjectData, VisData> data;
    private Map<IStudyData, ISeriesData> scSeries = new HashMap<IStudyData, ISeriesData>();
    private View.OverlayMode ovlMode;
    private boolean multiFrame;
    private List<IObjectData> objectDatas = new ArrayList<IObjectData>();
    private String seriesPrefix = "";
    private final boolean fullScreenCapture;
    private ProgressListener progressListener = null;

    public SecondaryCapture() {
        this.fullScreenCapture = true;
    }

    public SecondaryCapture(List<VisData> list, View.OverlayMode overlayMode, boolean bl) {
        this.ovlMode = overlayMode;
        this.data = new Hashtable<IFrameObjectData, VisData>();
        this.images = new HashMap<IImageObjectData, List<VisData>>();
        this.orderedImages = new ArrayList<IImageObjectData>();
        this.multiFrame = bl;
        this.fullScreenCapture = false;
        for (VisData visData : list) {
            IFrameObjectData iFrameObjectData = visData.getFrameData();
            this.data.put(iFrameObjectData, visData);
            IImageObjectData iImageObjectData = iFrameObjectData.getMainFrame();
            if (!this.images.containsKey(iImageObjectData)) {
                this.images.put(iImageObjectData, new ArrayList());
                this.orderedImages.add(iImageObjectData);
            }
            this.images.get(iImageObjectData).add(visData);
        }
    }

    public SecondaryCapture(List<VisData> list, View.OverlayMode overlayMode, boolean bl, ProgressListener progressListener) {
        this(list, overlayMode, bl);
        this.progressListener = progressListener;
    }

    private ISeriesData getSCSeries(IStudyData iStudyData, String string) {
        if (!this.scSeries.containsKey(iStudyData)) {
            ISeriesData iSeriesData = iStudyData.createSeriesData("OT");
            iSeriesData.setSecondaryCapture();
            iSeriesData.getDicomObject().setString(528446, VR.LO, "SC:" + (string == null ? "" : string));
            this.scSeries.put(iStudyData, iSeriesData);
        }
        return this.scSeries.get(iStudyData);
    }

    public void putSCSeries(IStudyData iStudyData, ISeriesData iSeriesData) {
        this.scSeries.put(iStudyData, iSeriesData);
    }

    public void setInteractor(SecondaryCaptureListener secondaryCaptureListener) {
        this.scInteractor = secondaryCaptureListener;
    }

    public Collection<ISeriesData> getSeriesData() {
        return this.scSeries.values();
    }

    void start(boolean bl) {
        if (bl) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public void runFullScreenCapture() {
        List<BufferedImage> list = this.createCombinedImages();
        ArrayList arrayList = new ArrayList();
        for (BufferedImage object2 : list) {
            ImagePixel imagePixel = ImagePixel.create((BufferedImage)object2);
            arrayList.add(PixelDataUtilities.createPixelDataFrame((ImagePixel)imagePixel, (BufferedImage)object2));
        }
        IStudyData iStudyData = DataSelectionManager.getInstance().getActiveHanging().getStudyContainer().getBaseStudy();
        this.objectDatas.add(this.createInstance(arrayList, iStudyData, null, "Screen Capture"));
        if (this.progressListener != null) {
            this.progressListener.progressNotification("Creating Secondary Captures", 1.0);
        }
    }

    private List<BufferedImage> createCombinedImages() {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        List<VisScreen2> list = JVision2.getMainFrame().getScreens();
        for (VisScreen2 visScreen2 : list) {
            List<VisDisplay2> list2 = visScreen2.getDisplays();
            Dimension dimension = new Dimension(visScreen2.getWidth(), visScreen2.getHeight());
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            arrayList.add(bufferedImage);
            Rectangle rectangle = new Rectangle(list2.get(0).getLocationOnScreen(), dimension);
            for (VisDisplay2 visDisplay2 : list2) {
                List<Vis2> list3 = visDisplay2.getVisViews();
                for (Vis2 vis2 : list3) {
                    Point point = vis2.getLocationOnScreen();
                    this.paintToImage(vis2, graphics2D, point.x - rectangle.x, point.y - rectangle.y);
                }
            }
        }
        return arrayList;
    }

    private void paintToImage(final Vis2 vis2, final Graphics graphics, final int n, final int n2) {
        if (vis2.getData() == null || vis2.getView() == null) {
            return;
        }
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                BufferedImage bufferedImage = vis2.getData().captureImage();
                graphics.drawImage(bufferedImage, n, n2, null);
            }
        });
    }

    private IImageObjectData createInstance(List<IPixelDataFrame<?>> list, IStudyData iStudyData, VisData visData, String string) {
        Object object;
        IPixelAccessor iPixelAccessor;
        Object object2;
        ImagePixel imagePixel = new ImagePixel(list.get(0).getImagePixel());
        ISeriesData iSeriesData = this.getSCSeries(iStudyData, string);
        BufferedImage bufferedImage = null;
        if (imagePixel.getPhotometricInterpretation() == PhotometricInterpretation.RGBColor) {
            object2 = new RGBBufferedImageHolder(imagePixel.getColumns(), imagePixel.getRows());
            iPixelAccessor = list.get(0).getPixelAccessor();
            try {
                object = (int[])iPixelAccessor.getData();
                System.arraycopy(object, 0, ((RGBBufferedImageHolder)object2).data, 0, imagePixel.getColumns() * imagePixel.getRows());
            }
            finally {
                iPixelAccessor.release();
            }
            bufferedImage = new BufferedImage(64, 64, 2);
            object = bufferedImage.createGraphics();
            ((Graphics)object).drawImage(((RGBBufferedImageHolder)object2).image, 0, 0, 64, 64, null);
            ((Graphics)object).dispose();
        } else if (visData != null) {
            bufferedImage = visData.renderVisData(64, 64, this.ovlMode);
        }
        object2 = iSeriesData.createObjectData(IImageObjectData.class, SecondaryCapture.getSCClassUID(imagePixel), "1.2.840.10008.1.2.1", bufferedImage, list.size());
        iPixelAccessor = object2.getImageInformation().getDataset();
        iPixelAccessor.addAll(object2.getParent().getParent().getParent().getDicomObject());
        iPixelAccessor.addAll(object2.getParent().getParent().getDicomObject());
        iPixelAccessor.addAll(object2.getParent().getDicomObject());
        iPixelAccessor.setString(2622209, VR.CS, YesNo.No.dicom());
        iPixelAccessor.setString(524388, VR.CS, ConversionType.Workstation.dicom());
        iPixelAccessor.setString(1576982, VR.LO, Product.getProductVendor());
        iPixelAccessor.setString(0x181018, VR.LO, Product.getProductName());
        iPixelAccessor.setString(1576985, VR.LO, Product.getVersionString());
        iPixelAccessor.setString(528446, VR.LO, String.valueOf(this.seriesPrefix) + string);
        iPixelAccessor.setString(524400, VR.LO, Product.getProductVendor());
        iPixelAccessor.setInt(0x280008, VR.IS, new int[]{list.size()});
        iPixelAccessor.addAll(imagePixel.toDataset());
        iPixelAccessor.setString(2621444, VR.CS, PhotometricInterpretation.RGBColor.dicom());
        object = new Date();
        iPixelAccessor.setDate(524330, VR.DT, new Date[]{object});
        iPixelAccessor.remove(524296);
        iPixelAccessor.remove(542113808);
        iPixelAccessor.remove(0x20500020);
        object2.initFromDicomObject((Attributes)iPixelAccessor);
        int n = 0;
        while (n < list.size()) {
            object2.setFrame(list.get(n), n);
            ++n;
        }
        return object2;
    }

    public void runImageCapture() {
        int n = 0;
        int n2 = 0;
        for (IImageObjectData iImageObjectData : this.orderedImages) {
            n2 += this.images.get(iImageObjectData).size();
        }
        for (IImageObjectData iImageObjectData : this.orderedImages) {
            List<MultiframeOverlayInformation> list;
            Object object;
            ImagePixel imagePixel;
            Object object2;
            List<VisData> list2 = this.images.get(iImageObjectData);
            if (this.multiFrame) {
                try {
                    Object object32;
                    for (VisData visData : list2) {
                        if (visData.isLoaded()) continue;
                        visData.loadFinal();
                    }
                    ArrayList arrayList = new ArrayList();
                    List<BitmapOverlay> list3 = new ArrayList(4);
                    object2 = new ArrayList(4);
                    imagePixel = new HashMap();
                    object = new HashMap();
                    int n3 = 1;
                    for (VisData visData : list2) {
                        IPixelDataFrame iPixelDataFrame;
                        if (!(visData.getView() instanceof LayeredView)) {
                            iPixelDataFrame = this.captureVisData(visData);
                        } else {
                            object32 = this.captureView(visData.getView());
                            if (list2.size() > 1) {
                                ((ViewSnapshot)object32).setShrinkOverlayData(false);
                            } else {
                                ((ViewSnapshot)object32).setShrinkOverlayData(true);
                            }
                            iPixelDataFrame = ((ViewSnapshot)object32).toPixelDataFrame();
                            list3 = ((ViewSnapshot)object32).getOverlayData();
                            for (BitmapOverlay bitmapOverlay : list3) {
                                String string = bitmapOverlay.getLabel();
                                list = (List)imagePixel.get(string);
                                if (list != null) {
                                    list.add(new MultiframeOverlayInformation(bitmapOverlay, n3));
                                    continue;
                                }
                                list = new LinkedList<MultiframeOverlayInformation>();
                                list.add(new MultiframeOverlayInformation(bitmapOverlay, n3));
                                imagePixel.put(string, list);
                                if (n3 == 1) continue;
                                object.put(string, n3);
                            }
                        }
                        ++n3;
                        arrayList.add(iPixelDataFrame);
                        ++n;
                        if (this.progressListener == null) continue;
                        this.progressListener.progressNotification("Creating Secondary Captures", (double)n / (double)n2);
                    }
                    String string = list2.get(0).getImageInformation().getDataset().getString(528446, "");
                    IImageObjectData iImageObjectData2 = this.createInstance(arrayList, iImageObjectData.getParent().getParent(), list2.get(0), string);
                    int n4 = 0;
                    for (Object object32 : imagePixel.keySet()) {
                        MultiframeOverlayInformation multiframeOverlayInformation;
                        List list4 = (List)imagePixel.get(object32);
                        int n5 = ((MultiframeOverlayInformation)list4.get(0)).framePosition;
                        int n6 = ((MultiframeOverlayInformation)list4.get(list4.size() - 1)).framePosition;
                        int n7 = ((MultiframeOverlayInformation)list4.get(0)).bitmapOverlay.getData().toPackedBits().length;
                        byte[] byArray = new byte[(n6 - n5 + 1) * n7];
                        int n8 = 0;
                        int n9 = -1;
                        OverlayPlane overlayPlane = list4.iterator();
                        while (overlayPlane.hasNext()) {
                            multiframeOverlayInformation = (MultiframeOverlayInformation)overlayPlane.next();
                            if (n9 != -1 && n9 != multiframeOverlayInformation.framePosition - 1) {
                                n8 += (multiframeOverlayInformation.framePosition - n9) * n7;
                            } else if (n9 != -1) {
                                n8 += n7;
                            }
                            System.arraycopy(multiframeOverlayInformation.bitmapOverlay.getData().toPackedBits(), 0, byArray, n8, n7);
                            n9 = multiframeOverlayInformation.framePosition;
                        }
                        multiframeOverlayInformation = OverlayUtils.getOverlayCacheID((String)iImageObjectData2.getParent().getParent().getStudyInstanceUID(), (String)iImageObjectData2.getSOPInstanceUID(), (int)(n4 << 16));
                        DataCacheProviderFactory.getCache().addPersistentBytes(byArray, (CacheID)multiframeOverlayInformation);
                        byArray = null;
                        overlayPlane = new OverlayPlane((CacheID)multiframeOverlayInformation);
                        Integer n10 = (Integer)object.get(object32);
                        if (n10 != null) {
                            overlayPlane.setImageFrameOrigin(n10);
                        }
                        overlayPlane.setOverlayBitPosition(Integer.valueOf(0));
                        overlayPlane.setOverlayBitsAllocated(Integer.valueOf(((MultiframeOverlayInformation)list4.get(0)).bitmapOverlay.getBitsAllocated()));
                        overlayPlane.setOverlayLabel((String)object32);
                        overlayPlane.setOverlayOrigin(new int[]{((MultiframeOverlayInformation)list4.get(0)).bitmapOverlay.getOriginX(), ((MultiframeOverlayInformation)list4.get(0)).bitmapOverlay.getOriginY()});
                        overlayPlane.setOverlayColumns(Integer.valueOf(((MultiframeOverlayInformation)list4.get(0)).bitmapOverlay.getColumns()));
                        overlayPlane.setOverlayRows(((MultiframeOverlayInformation)list4.get(0)).bitmapOverlay.getRows());
                        overlayPlane.setNumberOfFramesInOverlay(Integer.valueOf(n6 - n5 + 1));
                        overlayPlane.setOverlayDescription("screen mappings");
                        overlayPlane.setOverlaySubtype(((MultiframeOverlayInformation)list4.get(0)).bitmapOverlay.getOverlaySubType());
                        overlayPlane.setOverlayType("G");
                        object2.add(overlayPlane.writeToGroup(n4 << 16));
                        n4 += 2;
                    }
                    list = null;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object32 = (Attributes)iterator.next();
                        iImageObjectData2.getDicomObject().addAll((Attributes)object32);
                    }
                    this.objectDatas.add(iImageObjectData2);
                }
                catch (Exception exception) {
                    log.error("Secondary capture", (Throwable)exception);
                }
                continue;
            }
            for (VisData visData : list2) {
                try {
                    list = this.captureView(visData.getView());
                    object2 = ((ViewSnapshot)((Object)list)).toPixelDataFrame();
                    imagePixel = new ImagePixel(object2.getImagePixel());
                    object = this.getSCSeries(iImageObjectData.getParent().getParent(), iImageObjectData.getParent().getSeriesDescription());
                    IImageObjectData iImageObjectData3 = object.createObjectData(IImageObjectData.class, "1.2.840.10008.5.1.4.1.1.7", "1.2.840.10008.1.2.1");
                    iImageObjectData3.getImageInformation().getDataset().addAll(imagePixel.toDataset());
                    iImageObjectData3.initFromDicomObject(iImageObjectData3.getImageInformation().getDataset());
                    iImageObjectData3.setFrame((IPixelDataFrame)object2, 0);
                    this.objectDatas.add(iImageObjectData3);
                }
                catch (Exception exception) {
                    log.error("Secondary capture", (Throwable)exception);
                }
            }
            ++n;
            if (this.progressListener == null) continue;
            this.progressListener.progressNotification("Creating Secondary Captures", (double)n / (double)n2);
        }
    }

    @Override
    public void run() {
        if (this.fullScreenCapture) {
            this.runFullScreenCapture();
        } else {
            this.runImageCapture();
        }
        if (this.scInteractor != null) {
            this.scInteractor.hasFinshed();
        }
    }

    private static String getSCClassUID(ImagePixel imagePixel) {
        String string = null;
        if (imagePixel.getBitsAllocated() == 8 && imagePixel.getSamplesPerPixel() == 1) {
            string = "1.2.840.10008.5.1.4.1.1.7.2";
        }
        if (imagePixel.getBitsAllocated() == 16 && imagePixel.getSamplesPerPixel() == 1) {
            string = "1.2.840.10008.5.1.4.1.1.7.3";
        }
        if (imagePixel.getBitsAllocated() == 8 && imagePixel.getSamplesPerPixel() == 3) {
            string = "1.2.840.10008.5.1.4.1.1.7.4";
        }
        return string;
    }

    private IPixelDataFrame<?> captureVisData(VisData visData) {
        View view = visData.getView();
        BufferedImage bufferedImage = visData.renderVisData(view.getcwidth(), view.getcheight(), this.ovlMode);
        return PixelDataUtilities.createPixelDataFrame((ImagePixel)ImagePixel.create((BufferedImage)bufferedImage), (BufferedImage)bufferedImage);
    }

    private ViewSnapshot captureView(View view) {
        ViewSnapshot viewSnapshot = view.renderToSnapshot(view.getcwidth(), view.getcheight(), view.getcwidth(), view.getcheight(), 0.0, 0.0, this.ovlMode, true);
        return viewSnapshot;
    }

    public void setSeriesPrefix(String string) {
        this.seriesPrefix = string;
    }

    private static class MultiframeOverlayInformation {
        private BitmapOverlay bitmapOverlay;
        private Integer framePosition;

        private MultiframeOverlayInformation(BitmapOverlay bitmapOverlay, Integer n) {
            this.bitmapOverlay = bitmapOverlay;
            this.framePosition = n;
        }
    }
}

