/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.IVisDataChooser;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.event.VisNavigationEvent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ImageNavigationActions
implements PActionProvider {
    public static final String FIRST_IMAGE_ID = "FIRST_IMAGE";
    public static final String LAST_IMAGE_ID = "LAST_IMAGE";
    public static final String PREVIOUS_IMAGE_PAGE_ID = "PREVIOUS_IMAGE_PAGE";
    public static final String PREVIOUS_IMAGE_ID = "PREVIOUS_IMAGE";
    public static final String NEXT_IMAGE_ID = "NEXT_IMAGE";
    public static final String NEXT_IMAGE_PAGE_ID = "NEXT_IMAGE_PAGE";
    public static final String PREVIOUS_KEY_IMAGE_ID = "PREVIOUS_KEY_IMAGE";
    public static final String NEXT_KEY_IMAGE_ID = "NEXT_KEY_IMAGE";
    public static final String FIRST_KEY_IMAGE_ID = "FIRST_KEY_IMAGE";
    public static final String LAST_KEY_IMAGE_ID = "LAST_KEY_IMAGE";

    private static void fireNavigEvent(VisNavigationEvent visNavigationEvent) {
        ImageNavigationActions.fireNavigEvent(visNavigationEvent, JVision2.getMainFrame().getLastModifiedDisplay());
    }

    public static void fireNavigEvent(VisNavigationEvent visNavigationEvent, VisDisplay2 visDisplay2) {
        visNavigationEvent.bRepaint = true;
        if (ImageNavigationActions.isSynchronizedNavigationEnabled(visDisplay2)) {
            ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
            for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
                arrayList.addAll(visScreen2.getSynchronizedDisplays());
            }
            if (visNavigationEvent.id == 1) {
                VisDisplay2.synchronizeDisplays(arrayList, visDisplay2, IVisDataChooser.ByOne, visNavigationEvent);
            } else if (visNavigationEvent.id == 2) {
                VisDisplay2.synchronizeDisplays(arrayList, visDisplay2, IVisDataChooser.ByPage, visNavigationEvent);
            } else if (visNavigationEvent.id == 0) {
                visDisplay2.handleNavigationEvent(visNavigationEvent);
                arrayList.remove(visDisplay2);
                int n = Math.min(visDisplay2.getVisCount() - visDisplay2.getVisViewCount(), Math.max(0, visNavigationEvent.value));
                VisData visData = visDisplay2.getVis(n);
                IDisplaySet iDisplaySet = visDisplay2.getData().getDisplaySet();
                Double d = null;
                if (visDisplay2.getData().useLocationInformation()) {
                    d = iDisplaySet.getRelativeSliceLocation(n) - iDisplaySet.getRelativeSliceLocation(visDisplay2.getData().getIndexOfSyncPointData());
                }
                VisDisplayData.setDistanceToSyncPos(d, n - visDisplay2.getData().getIndexOfSyncPointData());
                visDisplay2.getData().setCurrentSynchronizedData(visData);
                for (VisDisplay2 visDisplay22 : arrayList) {
                    visDisplay22.getData().synchronizeWithCurrentSyncPosition();
                }
            }
        } else {
            visDisplay2.handleNavigationEvent(visNavigationEvent);
        }
    }

    public static boolean isSynchronizedNavigationEnabled(VisDisplay2 visDisplay2) {
        VisDisplayData visDisplayData = visDisplay2.getData();
        return visDisplayData != null && visDisplayData.isSynchronized() && !visDisplay2.getVisNavigationEventHandler().isSynchronizedNavigationHandled();
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new NextImageAction());
        arrayList.add(new PreviousImageAction());
        arrayList.add(new NextImagePageAction());
        arrayList.add(new PreviousImagePageAction());
        arrayList.add(new FirstImageAction());
        arrayList.add(new LastImageAction());
        arrayList.add(new PreviousKeyImageAction());
        arrayList.add(new NextKeyImageAction());
        arrayList.add(new FirstKeyImageAction());
        arrayList.add(new LastKeyImageAction());
        return arrayList;
    }

    private static abstract class AbstractKeyImageNavigationAction
    extends ImageAction {
        AbstractKeyImageNavigationAction() {
        }

        AbstractKeyImageNavigationAction(String string) {
            super(string);
        }

        @Override
        public final boolean perform(Component component) {
            VisDisplay2 visDisplay2 = JVision2.getMainFrame().getLastModifiedDisplay();
            Integer n = this.getNavigPos(visDisplay2);
            if (n != null) {
                VisNavigationEvent visNavigationEvent = new VisNavigationEvent();
                visNavigationEvent.id = 0;
                visNavigationEvent.value = n;
                ImageNavigationActions.fireNavigEvent(visNavigationEvent);
                return true;
            }
            return false;
        }

        abstract Integer getNavigPos(VisDisplay2 var1);
    }

    private static class FirstImageAction
    extends ImageAction {
        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_BEGIN");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(36);
        }

        @Override
        public String getID() {
            return ImageNavigationActions.FIRST_IMAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_BEGIN_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            int n = -1;
            if (VisDisplay2.loopAction != null && VisDisplay2.loopAction.isSelected()) {
                n = 0;
            }
            VisNavigationEvent visNavigationEvent = new VisNavigationEvent();
            visNavigationEvent.id = 0;
            visNavigationEvent.value = n;
            ImageNavigationActions.fireNavigEvent(visNavigationEvent);
            return true;
        }
    }

    private static class FirstKeyImageAction
    extends AbstractKeyImageNavigationAction {
        FirstKeyImageAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_KEYIMAGE_BEGIN");
        }

        @Override
        public String getID() {
            return ImageNavigationActions.FIRST_KEY_IMAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_KEYIMAGE_BEGIN_DESCRIPTION");
        }

        @Override
        Integer getNavigPos(VisDisplay2 visDisplay2) {
            if (visDisplay2 == null || !visDisplay2.hasData()) {
                return null;
            }
            return KeyImageManager.getInstance().getFirstMarked(visDisplay2.getData().getDisplaySet().getObjects());
        }
    }

    private static abstract class ImageAction
    extends AbstractPAction {
        public ImageAction(String string) {
            super(string);
        }

        public ImageAction() {
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }
    }

    private static class LastImageAction
    extends ImageAction {
        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_END");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(35);
        }

        @Override
        public String getID() {
            return ImageNavigationActions.LAST_IMAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_END_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisNavigationEvent visNavigationEvent = new VisNavigationEvent();
            visNavigationEvent.id = 0;
            visNavigationEvent.value = 999999;
            ImageNavigationActions.fireNavigEvent(visNavigationEvent);
            return true;
        }
    }

    private static class LastKeyImageAction
    extends AbstractKeyImageNavigationAction {
        LastKeyImageAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_KEYIMAGE_END");
        }

        @Override
        public String getID() {
            return ImageNavigationActions.LAST_KEY_IMAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_KEYIMAGE_END_DESCRIPTION");
        }

        @Override
        Integer getNavigPos(VisDisplay2 visDisplay2) {
            if (visDisplay2 == null || !visDisplay2.hasData()) {
                return null;
            }
            return KeyImageManager.getInstance().getLastMarked(visDisplay2.getData().getDisplaySet().getObjects());
        }
    }

    private static class NextImageAction
    extends ImageAction {
        public NextImageAction() {
            super("next_item.svg");
        }

        @Override
        public String getID() {
            return ImageNavigationActions.NEXT_IMAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_FORWARD_DESCRIPTION");
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_FORWARD");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(39);
        }

        @Override
        public boolean perform(Component component) {
            VisNavigationEvent visNavigationEvent = new VisNavigationEvent();
            visNavigationEvent.id = 1;
            visNavigationEvent.value = 1;
            ImageNavigationActions.fireNavigEvent(visNavigationEvent);
            return true;
        }
    }

    private static class NextImagePageAction
    extends ImageAction {
        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_FAST_FORWARD");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return null;
        }

        @Override
        public String getID() {
            return ImageNavigationActions.NEXT_IMAGE_PAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_FAST_FORWARD_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            VisNavigationEvent visNavigationEvent = new VisNavigationEvent();
            visNavigationEvent.id = 2;
            visNavigationEvent.value = 1;
            ImageNavigationActions.fireNavigEvent(visNavigationEvent);
            return true;
        }
    }

    private static class NextKeyImageAction
    extends AbstractKeyImageNavigationAction {
        public NextKeyImageAction() {
            super("next_item.svg");
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_KEYIMAGE_FORWARD");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(34);
        }

        @Override
        public String getID() {
            return ImageNavigationActions.NEXT_KEY_IMAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_KEYIMAGE_FORWARD_DESCRIPTION");
        }

        @Override
        Integer getNavigPos(VisDisplay2 visDisplay2) {
            KeyImageManager keyImageManager = KeyImageManager.getInstance();
            int n = visDisplay2.getNavigPos() + 1;
            int n2 = visDisplay2.getVisCount() - 1;
            while (n <= n2 && !keyImageManager.isMarked(visDisplay2.getVis(n).getFrameData())) {
                ++n;
            }
            if (n <= n2) {
                return n;
            }
            return null;
        }
    }

    private static class PreviousImageAction
    extends ImageAction {
        public PreviousImageAction() {
            super("previous_item.svg");
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_BACKWARD");
        }

        @Override
        public String getID() {
            return ImageNavigationActions.PREVIOUS_IMAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_BACKWARD_DESCRIPTION");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(37);
        }

        @Override
        public boolean perform(Component component) {
            VisNavigationEvent visNavigationEvent = new VisNavigationEvent();
            visNavigationEvent.id = 1;
            visNavigationEvent.value = -1;
            ImageNavigationActions.fireNavigEvent(visNavigationEvent);
            return true;
        }
    }

    private static class PreviousImagePageAction
    extends ImageAction {
        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_FAST_BACKWARD");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return null;
        }

        @Override
        public String getID() {
            return ImageNavigationActions.PREVIOUS_IMAGE_PAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_FAST_BACKWARD_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            VisNavigationEvent visNavigationEvent = new VisNavigationEvent();
            visNavigationEvent.id = 2;
            visNavigationEvent.value = -1;
            ImageNavigationActions.fireNavigEvent(visNavigationEvent);
            return true;
        }
    }

    private static class PreviousKeyImageAction
    extends AbstractKeyImageNavigationAction {
        public PreviousKeyImageAction() {
            super("previous_item.svg");
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_KEYIMAGE_BACKWARD");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(33);
        }

        @Override
        public String getID() {
            return ImageNavigationActions.PREVIOUS_KEY_IMAGE_ID;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_NAVIGATION_KEYIMAGE_BACKWARD_DESCRIPTION");
        }

        @Override
        Integer getNavigPos(VisDisplay2 visDisplay2) {
            KeyImageManager keyImageManager = KeyImageManager.getInstance();
            int n = visDisplay2.getNavigPos() - 1;
            while (n >= 0 && !keyImageManager.isMarked(visDisplay2.getVis(n).getFrameData())) {
                --n;
            }
            if (n >= 0) {
                return n;
            }
            return null;
        }
    }
}

