/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.info;

import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.util.TicketOffice;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ImageState {
    private static ImageState defaultImageState = new ImageState();
    public Matrix2d transform;
    public double wview;
    public double hview;
    public Rectangle validBounds;
    public Matrix2d i2s = new Matrix2d();
    public Matrix2d s2i = new Matrix2d();
    public double[] visOrig = new double[2];
    public double[] cv = new double[2];
    public double[] rv = new double[2];
    public double pixelSizeX;
    public double pixelSizeY;
    protected List<SpacingDef> spacingDefs;
    private int currentSpacingDef;
    public WindowDef window;
    private IValueMapping currentValueMapping;
    public long updateStamp = 0L;

    public ImageState() {
        this.spacingDefs = Collections.emptyList();
    }

    public ImageState(List<SpacingDef> arrayList) {
        this.spacingDefs = arrayList.isEmpty() ? arrayList : new ArrayList(arrayList);
    }

    public void updated() {
        this.updateStamp = TicketOffice.getNewStamp();
    }

    public void screenToImage(double[] dArray, double[] dArray2, Object object) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        this.s2i.transform(dArray2);
        dArray2[0] = dArray2[0] + this.visOrig[0];
        dArray2[1] = dArray2[1] + this.visOrig[1];
    }

    public void imageToScreen(double[] dArray, double[] dArray2, Object object) {
        dArray2[0] = dArray[0] - this.visOrig[0];
        dArray2[1] = dArray[1] - this.visOrig[1];
        this.i2s.transform(dArray2);
    }

    public void imageToScreen(float f, float f2, double[] dArray, Object object) {
        dArray[0] = (double)f - this.visOrig[0];
        dArray[1] = (double)f2 - this.visOrig[1];
        this.i2s.transform(dArray);
    }

    public static ImageState getDefaultImageState() {
        return defaultImageState;
    }

    public void setToCommon(ImageState imageState, ImageState imageState2) {
        if (Math.abs(imageState.pixelSizeX - imageState2.pixelSizeX) < 0.001 && Math.abs(imageState.pixelSizeY - imageState2.pixelSizeY) < 0.001) {
            this.pixelSizeX = imageState.pixelSizeX;
            this.pixelSizeY = imageState.pixelSizeY;
            this.visOrig[0] = imageState.visOrig[0];
            this.visOrig[1] = imageState.visOrig[1];
        } else {
            this.pixelSizeX = 0.0;
            this.pixelSizeY = 0.0;
        }
        if (imageState.getCurrentSpacingDef().equals(imageState2.getCurrentSpacingDef())) {
            this.setCurrentSpacingDef(imageState.getCurrentSpacingDef());
        } else if (imageState.getCurrentSpacingDef().getSizeUnit().equals((Object)imageState2.getCurrentSpacingDef().getSizeUnit())) {
            SpacingDef spacingDef = this.getCurrentSpacingDef();
            if (spacingDef == null) {
                spacingDef = new SpacingDef();
            }
            spacingDef.setSizeUnit(imageState.getCurrentSpacingDef().getSizeUnit());
        } else {
            this.pixelSizeX = 0.0;
            this.pixelSizeY = 0.0;
        }
        if (this.transform == null) {
            this.transform = new Matrix2d();
        }
        this.transform.set(Matrix2d.trafoUnity);
        this.updated();
    }

    public void initSpacing(IImageInformation iImageInformation) {
        this.spacingDefs = SpacingDef.generateSpacingDefs(iImageInformation);
        this.currentSpacingDef = this.spacingDefs.size() - 1;
    }

    protected void removePixelSpacing() {
        SpacingDef spacingDef;
        Iterator<SpacingDef> iterator = this.spacingDefs.iterator();
        while (iterator.hasNext()) {
            spacingDef = iterator.next();
            if (spacingDef.getSizeUnit() != SpacingDef.Unit.pix) continue;
            iterator.remove();
        }
        if (this.spacingDefs.size() == 0) {
            spacingDef = new SpacingDef();
            spacingDef.setSizeUnit(null);
            this.spacingDefs.add(spacingDef);
        }
        this.currentSpacingDef = this.spacingDefs.size() - 1;
    }

    public SpacingDef getCurrentSpacingDef() {
        if (this.spacingDefs.isEmpty()) {
            SpacingDef spacingDef = new SpacingDef();
            this.setCurrentSpacingDef(spacingDef);
            return spacingDef;
        }
        SpacingDef spacingDef = null;
        try {
            spacingDef = this.spacingDefs.get(this.currentSpacingDef);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return spacingDef;
    }

    public void setCurrentSpacingDef(int n) {
        if (n < this.spacingDefs.size()) {
            this.currentSpacingDef = n;
        }
        this.updated();
    }

    public void setCurrentSpacingDef(SpacingDef spacingDef) {
        if (spacingDef != null) {
            this.spacingDefs.add(spacingDef);
            this.currentSpacingDef = this.spacingDefs.size() - 1;
        }
        int n = this.spacingDefs.size();
        int n2 = 0;
        while (n2 < n) {
            if (n2 != this.currentSpacingDef && this.getCurrentSpacingDef().toString().equals(this.spacingDefs.get(n2).toString())) {
                this.spacingDefs.remove(n2);
                if (n2 >= this.currentSpacingDef) break;
                --this.currentSpacingDef;
                break;
            }
            ++n2;
        }
        this.updated();
    }

    public void selectCurrentSpacingDef(SpacingDef spacingDef) {
        int n = this.spacingDefs.indexOf(spacingDef);
        if (n >= 0) {
            spacingDef = this.spacingDefs.remove(n);
            this.spacingDefs.add(spacingDef);
            this.currentSpacingDef = this.spacingDefs.size() - 1;
        }
    }

    public void removeSpacingDef(SpacingDef spacingDef) {
        int n;
        if (spacingDef != null && (n = this.spacingDefs.indexOf(spacingDef)) > -1) {
            this.spacingDefs.remove(n);
            if (n <= this.currentSpacingDef) {
                --this.currentSpacingDef;
            }
        }
        this.updated();
    }

    public void removeSpacingDef(int n) {
        if (n > -1 && this.spacingDefs.size() > n) {
            this.spacingDefs.remove(n);
            if (n <= this.currentSpacingDef) {
                --this.currentSpacingDef;
            }
        }
        this.updated();
    }

    public IValueMapping getCurrentValueMapping() {
        if (this.currentValueMapping != null) {
            return this.currentValueMapping;
        }
        return this.window;
    }

    public void setCurrentValueMapping(IValueMapping iValueMapping) {
        this.currentValueMapping = iValueMapping;
        this.updated();
    }

    public void setDataPixelSizeX(double d) {
        this.getCurrentSpacingDef().setDataPixelSizeX(d);
    }

    public double getDataPixelSizeX() {
        return this.getCurrentSpacingDef().getDataPixelSizeX();
    }

    public void setDataPixelSizeY(double d) {
        this.getCurrentSpacingDef().setDataPixelSizeY(d);
    }

    public double getDataPixelSizeY() {
        return this.getCurrentSpacingDef().getDataPixelSizeY();
    }

    public double getDataPixelSizeY(Object object) {
        return this.getDataPixelSizeY();
    }

    public double getDataPixelSizeX(Object object) {
        return this.getDataPixelSizeX();
    }

    public void setProjectiveSpacing(boolean bl) {
        this.getCurrentSpacingDef().setProjectiveSpacing(bl);
    }

    public boolean isProjectiveSpacing() {
        return this.getCurrentSpacingDef().isProjectiveSpacing();
    }

    public String getDimensionUnit() {
        return this.getCurrentSpacingDef().toString();
    }

    public void setSizeUnit(SpacingDef.Unit unit) {
        this.getCurrentSpacingDef().setSizeUnit(unit);
    }

    public SpacingDef.Unit getSizeUnit() {
        return this.getCurrentSpacingDef().getSizeUnit();
    }

    public boolean isValidDataPixelSize() {
        return this.getDataPixelSizeX() != 0.0 && this.getDataPixelSizeY() != 0.0;
    }

    public List<SpacingDef> spacingDefs() {
        return this.spacingDefs;
    }

    public SpacingDef getSpacingDef(SpacingDef.Unit unit) {
        for (SpacingDef spacingDef : this.spacingDefs) {
            if (spacingDef.getSizeUnit() != unit) continue;
            return spacingDef;
        }
        return null;
    }

    public boolean isImgSpacingAllowed() {
        return true;
    }
}

