/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.fithandler;

import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.ViewPort;
import java.awt.Rectangle;

public class FullVisualFitHandler
extends AreaFitHandler {
    double zoomToMatch = 0.0;

    public FullVisualFitHandler() {
    }

    public FullVisualFitHandler(OutputDeviceMetric outputDeviceMetric) {
        super(outputDeviceMetric);
    }

    public FullVisualFitHandler(AreaFitHandler areaFitHandler) {
        super(areaFitHandler);
        this.zoomToMatch = this.getZoomFactor() * this.getViewScaleX();
        if (areaFitHandler.lastCalledActivedef != null) {
            this.getViewScale(areaFitHandler.lastCalledActivedef, areaFitHandler.lastCalledCwidth, areaFitHandler.lastCalledCheight);
        }
    }

    @Override
    public void set(AreaFitHandler areaFitHandler) {
        super.set(areaFitHandler);
        this.zoomToMatch = this.getZoomFactor() * this.getViewScaleX();
        if (areaFitHandler.lastCalledActivedef != null) {
            this.getViewScale(areaFitHandler.lastCalledActivedef, areaFitHandler.lastCalledCwidth, areaFitHandler.lastCalledCheight);
        }
    }

    @Override
    public double getViewScale(ImageDef imageDef, int n, int n2) {
        if (this.zoomToMatch != 0.0) {
            this.matchTotalZoom(imageDef, n, n2);
        }
        return this.computeViewScale(imageDef, n, n2);
    }

    private double computeViewScale(ImageDef imageDef, int n, int n2) {
        return Math.min((double)n / (double)imageDef.getDisplayedColumns(), (double)n2 / (double)imageDef.getDisplayedRows());
    }

    public void matchTotalZoom(double d) {
        this.zoomToMatch = d;
    }

    private void matchTotalZoom(ImageDef imageDef, int n, int n2) {
        double d = this.computeViewScale(imageDef, n, n2);
        this.setZoomFactor(this.zoomToMatch / d);
        this.zoomToMatch = 0.0;
    }

    @Override
    public void setZoomFactor(double d) {
        this.zoomToMatch = 0.0;
        super.setZoomFactor(d);
    }

    @Override
    protected double restrictZoom(double d) {
        if (d > 8.0) {
            d = 8.0;
        }
        return d;
    }

    @Override
    public void checkViewPortCenter(ImageDef imageDef, int n, int n2) {
        if (this.zoomFactor == 1.0 && this.borderLockMode) {
            imageDef.resetTransformedViewportCenter();
            return;
        }
        super.checkViewPortCenter(imageDef, n, n2);
    }

    @Override
    public void updateViewPort(ImageDef imageDef, ViewPort viewPort, Rectangle rectangle, int n, int n2) {
        super.updateViewPort(imageDef, viewPort, rectangle, n, n2);
    }

    @Override
    public boolean isUnrestrictedZoom() {
        return true;
    }
}

