/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ColorTablePool;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.WindowDef;
import org.dcm4che3.data.Attributes;

public class WindowTransferFunction
extends TransferFunction {
    protected GrayScaleTransformationSequence gsts;

    public WindowTransferFunction() {
    }

    public WindowTransferFunction(ILUTContainer iLUTContainer, IImageInformation iImageInformation, boolean bl, boolean bl2, IHistogramProvider iHistogramProvider) {
        super(1 << iImageInformation.getBitsStored());
        this.gsts = new GrayScaleTransformationSequence(iLUTContainer, iImageInformation.getHighBit(), bl, bl2, iImageInformation, iHistogramProvider);
        this.inverted = this.gsts.isInvertPostVOI();
    }

    public WindowTransferFunction(ILUTContainer iLUTContainer, int n, int n2, boolean bl, boolean bl2) {
        super(1 << n2);
        this.gsts = new GrayScaleTransformationSequence(iLUTContainer, n, bl, bl2);
        this.inverted = this.gsts.isInvertPostVOI();
    }

    public WindowTransferFunction(IImageInformation iImageInformation) {
        this((ILUTContainer)iImageInformation, iImageInformation.getHighBit(), iImageInformation.getBitsStored(), iImageInformation.isInverse(), iImageInformation.isSigned());
    }

    public WindowTransferFunction(WindowTransferFunction windowTransferFunction) {
        super(windowTransferFunction);
        if (windowTransferFunction.gsts != null) {
            this.gsts = new GrayScaleTransformationSequence(windowTransferFunction.gsts);
            this.inverted = this.gsts.isInvertPostVOI();
        }
    }

    public WindowTransferFunction(int n) {
        super(n);
        this.recalc();
    }

    @Override
    public int getUpdateID() {
        if (this.gsts != null) {
            return this.gsts.getContentID();
        }
        return 1;
    }

    @Override
    public void recalc() {
        this.modified = false;
    }

    public void superRecalc() {
        super.recalc();
    }

    public WindowDef getWindowDef() {
        return this.gsts.getWindowDef();
    }

    @Override
    public int getOffset(boolean bl) {
        if (this.gsts == null) {
            return 0;
        }
        return this.gsts.getOffset();
    }

    @Override
    public boolean isRawDataInverted() {
        if (this.gsts != null) {
            return this.gsts.isMono1();
        }
        return false;
    }

    @Override
    public int[] getRGB(boolean bl) {
        if (!this.lock && !this.gsts.hasLUTs()) {
            this.rgb = ColorTablePool.getColorTable(this.gsts.getWindowDef().getDataCenter(), this.gsts.getWindowDef().getDataWidth(), this.gsts.getInversion(), this.grays, this.gsts.getOffset());
            if (this.rgb != null) {
                int[] nArray = this.rgb;
                this.rgb = null;
                return nArray;
            }
        }
        if (this.rgb == null) {
            this.rgb = new int[this.grays];
        }
        this.rgb = this.gsts.getRGBMapping(this.rgb);
        if (!this.lock && !this.gsts.hasLUTs()) {
            ColorTablePool.setColorTable(this.gsts.getWindowDef().getDataCenter(), this.gsts.getWindowDef().getDataWidth(), this.gsts.getInversion(), this.grays, this.gsts.getOffset(), this.gsts.getRsDef().getIntercept(), this.gsts.getRsDef().getSlope(), this.rgb);
            int[] nArray = this.rgb;
            this.rgb = null;
            return nArray;
        }
        return this.rgb;
    }

    public void setWindow(WindowDef windowDef) {
        this.gsts.setWindow(windowDef);
    }

    public GrayScaleTransformationSequence getGSTS() {
        return this.gsts;
    }

    public void setGSTS(GrayScaleTransformationSequence grayScaleTransformationSequence) {
        this.rgb = null;
        this.gsts = grayScaleTransformationSequence;
    }

    public WindowTransferFunction getClone() {
        WindowTransferFunction windowTransferFunction = new WindowTransferFunction();
        windowTransferFunction.set(this);
        return windowTransferFunction;
    }

    public void set(WindowTransferFunction windowTransferFunction) {
        super.set(windowTransferFunction);
        if (windowTransferFunction.gsts != null) {
            this.gsts = new GrayScaleTransformationSequence(windowTransferFunction.gsts);
        }
    }

    @Override
    public void storeTo(Attributes attributes) {
        if (this.gsts != null) {
            this.gsts.storeTo(attributes);
        }
    }
}

