/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.impaxee.gsts.ILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.IWindowSettings;
import java.io.Serializable;
import java.text.DecimalFormat;

public class WindowDef
implements IWindowSettings,
IValueMapping,
Serializable {
    private static final String HFcap = "HU";
    private static final String SIcap = "SI";
    private static final String COUNTS_PER_SEC = "counts/s";
    public static final DecimalFormat defaultOutputFormat = new DecimalFormat("#");
    private static final DecimalFormat smallValueOutputFormat = new DecimalFormat("#.#");
    private static final DecimalFormat tinyValueOutputFormat = new DecimalFormat("#.#####");
    private int grays;
    private double center;
    private double width;
    private double slope;
    private double intercept;
    private boolean signed;
    private int offset;
    private ILUT MLUT;
    private String unit = "";
    private boolean useTinyValueOutputFormat = false;

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    public WindowDef(boolean bl, int n) {
        this.slope = 1.0;
        this.intercept = 0.0;
        this.center = 0.0;
        this.width = 0.0;
        this.grays = 2 << n;
        this.signed = bl;
        if (bl) {
            this.offset = 1 << n;
        }
    }

    public void computeWindow() {
        this.center = this.signed ? this.dataToLogical(0.0) : this.dataToLogical(this.grays / 2) - 1.0;
        this.width = this.grays - 1;
    }

    public WindowDef(IImageInformation iImageInformation) {
        this(iImageInformation, iImageInformation.getHighBit(), iImageInformation.isSigned());
    }

    public WindowDef(ILUTContainer iLUTContainer, int n, boolean bl) {
        this(bl, n);
        if (iLUTContainer.getModalityLUT() != null && iLUTContainer.getModalityLUT().hasSlopeIntercept()) {
            this.slope = iLUTContainer.getModalityLUT().getRescaleSlope();
            this.intercept = iLUTContainer.getModalityLUT().getRescaleIntercept();
        } else {
            this.slope = 1.0;
            this.intercept = 0.0;
        }
        IVOILUT iVOILUT = iLUTContainer.getVOILUT();
        if (iVOILUT != null && iVOILUT.hasWindow()) {
            this.center = iVOILUT.getWindowCenter();
            this.width = iVOILUT.getWindowWidth();
        } else {
            this.computeWindow();
        }
    }

    public WindowDef(WindowDef windowDef) {
        this.grays = windowDef.grays;
        this.center = windowDef.center;
        this.width = windowDef.width;
        this.slope = windowDef.slope;
        this.intercept = windowDef.intercept;
        this.unit = windowDef.unit;
        this.MLUT = windowDef.MLUT;
        this.signed = windowDef.signed;
        this.offset = windowDef.offset;
        this.unit = windowDef.unit;
    }

    WindowDef(int n, double d, double d2) {
        this.grays = n;
        this.center = d * (double)n;
        this.width = d2 * (double)n;
        this.slope = 1.0;
        this.intercept = 0.0;
        this.signed = false;
        this.offset = 0;
    }

    public WindowDef(int n, double d, double d2, double d3, double d4) {
        this.grays = n;
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        this.slope = d3;
        this.intercept = d4;
        this.setCenter(d);
        this.setWidth(d2);
    }

    public void setMLUT(ILUT iLUT) {
        this.MLUT = iLUT;
    }

    public ILUT getMLUT() {
        return this.MLUT;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    @Override
    public int getGrays() {
        return this.grays;
    }

    @Override
    public int getDataWidth() {
        return (int)Math.abs(this.logicalToData(this.center + this.width / 2.0) - this.logicalToData(this.center - this.width / 2.0));
    }

    @Override
    public int getDataCenter() {
        return (int)this.logicalToData(this.center);
    }

    @Override
    public double getCenter() {
        return this.center;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getNormalizedCenter() {
        if (this.MLUT != null) {
            return this.logicalToData(this.center) / (double)(1 << this.MLUT.getBitsOfIndex());
        }
        if (this.isSigned()) {
            return this.logicalToData(this.center) / (double)this.grays + 0.5;
        }
        return this.logicalToData(this.center) / (double)this.grays;
    }

    @Override
    public double getNormalizedWidth() {
        if (this.MLUT != null) {
            return this.logicalToData(this.width) / (double)(1 << this.MLUT.getBitsOfIndex());
        }
        return Math.abs(this.logicalToData(0.0) - this.logicalToData(this.width)) / (double)this.grays;
    }

    public void setCenter(double d) {
        this.center = d;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setNormalizedCenter(double d) {
        this.center = this.MLUT != null ? this.dataToLogicalNoLut(d * (double)(1 << this.MLUT.getBitsOfIndex())) : (this.isSigned() ? this.dataToLogicalNoLut((d - 0.5) * (double)this.grays) : this.dataToLogicalNoLut(d * (double)this.grays));
    }

    public void setNormalizedWidth(double d) {
        this.width = this.MLUT != null ? Math.abs(this.dataToLogicalNoLut(d * (double)(1 << this.MLUT.getBitsOfIndex())) - this.dataToLogicalNoLut(0.0)) : Math.abs(this.dataToLogicalNoLut(d * (double)this.grays) - this.dataToLogicalNoLut(0.0));
    }

    public void setCW(WindowDef windowDef) {
        this.setCenter(windowDef.getCenter());
        this.setWidth(windowDef.getWidth());
    }

    public void setDataCenter(double d) {
        this.center = this.dataToLogicalNoLut(d);
    }

    public void setDataWidth(double d) {
        this.width = Math.abs(this.dataToLogical(0 - this.offset) - this.dataToLogical(Math.abs(d) - (double)this.offset));
    }

    public void setIntercept(double d) {
        this.intercept = d;
    }

    @Override
    public double getIntercept() {
        return this.intercept;
    }

    public void setSlope(double d) {
        this.slope = d;
    }

    @Override
    public double getSlope() {
        return this.slope;
    }

    public double applyMapping(int n) {
        return this.dataToLogical(n);
    }

    @Override
    public double dataToLogical(double d) {
        if (this.MLUT == null) {
            return d * this.slope + this.intercept;
        }
        double d2 = d + (double)this.offset;
        if (d2 >= (double)this.MLUT.getData().length) {
            d2 = this.MLUT.getData().length - 1;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return this.MLUT.getData()[(int)d2] & 0xFFFF;
    }

    @Override
    @Deprecated
    public double dataToLogicalWithoutIntercept(double d) throws UnsupportedOperationException {
        if (this.MLUT == null) {
            return d * this.slope;
        }
        throw new UnsupportedOperationException("MLUT is present");
    }

    @Override
    public double dataToLogicalNoLut(double d) {
        if (this.MLUT == null) {
            return d * this.slope + this.intercept;
        }
        return d * (double)(1 << this.MLUT.getBitsStored() - this.MLUT.getBitsOfIndex());
    }

    @Override
    public double logicalToData(double d) {
        if (this.MLUT == null) {
            return (d - this.intercept) / this.slope;
        }
        return (int)d >> this.MLUT.getBitsStored() - this.MLUT.getBitsOfIndex();
    }

    public Integer getFirstValueMapped() {
        return null;
    }

    public Integer getLastValueMapped() {
        return null;
    }

    public String toString() {
        return "window: " + this.center + "/" + this.width + " sl/ic:" + this.slope + "/" + this.intercept;
    }

    public boolean isMonotonic() {
        return this.MLUT == null || this.MLUT.isMonotoneous();
    }

    public String formatValue(double d) {
        if (Double.isNaN(d)) {
            return "NA";
        }
        return this.formatWindowValue(d);
    }

    String formatWindowValue(double d) {
        DecimalFormat decimalFormat = this.useTinyValueOutputFormat ? tinyValueOutputFormat : (-10.0 < d && d < 10.0 ? smallValueOutputFormat : defaultOutputFormat);
        return decimalFormat.format(d);
    }

    public void setUnitFromModality(String string, String string2) {
        if ("CT".equalsIgnoreCase(string)) {
            this.setUnit(HFcap);
        } else if ("PT".equalsIgnoreCase(string)) {
            if ("CNTS".equalsIgnoreCase(string2)) {
                this.setUnit("counts");
            } else if ("CM2".equalsIgnoreCase(string2)) {
                this.setUnit("cm\u00b2");
            } else if ("PCNT".equalsIgnoreCase(string2)) {
                this.setUnit("%");
            } else if ("CPS".equalsIgnoreCase(string2)) {
                this.setUnit(COUNTS_PER_SEC);
                this.useTinyValueOutputFormat = true;
            } else if ("BQML".equalsIgnoreCase(string2)) {
                this.setUnit("Bq/ml");
            } else if ("MGMINML".equalsIgnoreCase(string2)) {
                this.setUnit("mg/min/ml");
            } else if ("UMOLMINML".equalsIgnoreCase(string2)) {
                this.setUnit("\u00b5mol/min/ml");
            } else if ("MLMING".equalsIgnoreCase(string2)) {
                this.setUnit("ml/min/g");
            } else if ("MLG".equalsIgnoreCase(string2)) {
                this.setUnit("ml/g");
            } else if ("1CM".equalsIgnoreCase(string2)) {
                this.setUnit("1/cm");
                this.useTinyValueOutputFormat = true;
            } else if ("UMOLML".equalsIgnoreCase(string2)) {
                this.setUnit("\u00b5mol/ml");
            } else if ("PROPCNTS".equalsIgnoreCase(string2)) {
                this.setUnit("prop. counts");
            } else if ("PROPCPS".equalsIgnoreCase(string2)) {
                this.setUnit("prop. counts/s");
            } else if ("MLMINML".equalsIgnoreCase(string2)) {
                this.setUnit("ml/min/ml");
            } else if ("MLML".equalsIgnoreCase(string2)) {
                this.setUnit("ml/ml");
            } else if ("GML".equalsIgnoreCase(string2)) {
                this.setUnit("g/ml");
            } else if ("STDDEV".equalsIgnoreCase(string2)) {
                this.setUnit("std dev");
            } else {
                this.setUnit("");
            }
        } else {
            this.setUnit(SIcap);
        }
    }
}

