/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.plugin.ExportProgressStateModel;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import com.tiani.jvision.image.AbstractWaitingView;
import com.tiani.jvision.toptoolbar.PluginActions;
import com.tiani.jvision.vis.VisDisplay2;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class WaitForImagesView
extends AbstractWaitingView
implements IObjectListener {
    private static final ALogger log = ALogger.getLogger(WaitForImagesView.class);
    private static final IFetcher fetcher = DataManager.getInstance().getFetcher();
    protected IFrameObjectData lightWeightFirstImage;
    protected int defaultIconHeight = GUI.getScaledDiagnosticInt((int)64);
    private int totalObjectCount;
    private Set<String> instanceUIDs = null;

    public WaitForImagesView(List<IFrameObjectData> list) {
        super(list);
        this.lightWeightFirstImage = list.get(0);
        this.instanceUIDs = Collections.synchronizedSet(new HashSet(list.size()));
        for (IFrameObjectData iFrameObjectData : list) {
            this.instanceUIDs.add(iFrameObjectData.getSOPInstanceUID());
        }
        this.totalObjectCount = this.instanceUIDs.size();
    }

    @Override
    protected void startDataFetching(final List<IFrameObjectData> list) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WaitForImagesView.this.addDatas(list);
            }
        };
        new Thread(runnable, "WaitingForImagesView").start();
    }

    protected void addDatas(List<IFrameObjectData> list) {
        ArrayList<IImageObjectData> arrayList = new ArrayList<IImageObjectData>();
        HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>();
        for (IFrameObjectData iDataObject : list) {
            hashSet.add(iDataObject.getMainFrame());
        }
        for (IImageObjectData iImageObjectData : hashSet) {
            iImageObjectData.addListener(this);
            if (iImageObjectData.isFullyLoaded()) continue;
            arrayList.add(iImageObjectData);
        }
        if (!arrayList.isEmpty()) {
            fetcher.changeToHigherPriorityIfExists(arrayList, (byte)1);
        }
    }

    @Override
    public void lossyObjectFinished(IObjectData iObjectData) {
    }

    @Override
    public void objectFinished(IObjectData iObjectData) {
        this.instanceUIDs.remove(iObjectData.getSOPInstanceUID());
        if (this.instanceUIDs.isEmpty() && !this.multipleSeriesPossible()) {
            this.dataFetchFinished();
        }
    }

    @Override
    public void cleanUp() {
        this.instanceUIDs.clear();
        super.cleanUp();
    }

    public double getLoadFraction() {
        return 1.0 - (double)this.instanceUIDs.size() / (double)this.totalObjectCount;
    }

    public void startExternalApplication() {
    }

    public void exportDisplaySets(List<IDisplaySet> list, File file, boolean bl) {
        ArrayList<IObjectData> arrayList = new ArrayList<IObjectData>();
        HashSet<String> hashSet = new HashSet<String>();
        for (IDisplaySet object2 : list) {
            IFrameObjectData[] iFrameObjectDataArray = object2.getObjects();
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
                IImageObjectData iImageObjectData = iFrameObjectData.getMainFrame();
                if (!hashSet.contains(iImageObjectData.getKey())) {
                    arrayList.add(iImageObjectData);
                    hashSet.add(iImageObjectData.getKey());
                }
                ++n2;
            }
        }
        ExportProgressStateModel exportProgressStateModel = new ExportProgressStateModel(this);
        DataManager.getInstance().getFetcher().exportDicomObjects(arrayList, file, bl, exportProgressStateModel);
    }

    public void addAdditionalSeries(List<IFrameObjectData> list) {
        int n = this.totalObjectCount + list.size();
        Set<String> set = this.instanceUIDs;
        this.instanceUIDs = Collections.synchronizedSet(new HashSet(n));
        this.instanceUIDs.addAll(set);
        for (IFrameObjectData iFrameObjectData : list) {
            if (!this.instanceUIDs.add(iFrameObjectData.getSOPInstanceUID())) continue;
            ++this.totalObjectCount;
        }
        this.addDatas(list);
    }

    public boolean multipleSeriesPossible() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isAlreadyRunning(String string) {
        BufferedReader bufferedReader = null;
        string = string.toLowerCase(Locale.ENGLISH);
        try {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(new String[]{"tasklist.exe"});
            }
            catch (IOException iOException) {
                process = Runtime.getRuntime().exec(new String[]{"tlist.exe"});
            }
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
            }
            return false;
        }
        catch (Exception exception) {
            log.warn("Problem determining if the process " + string + " is already running", (Throwable)exception);
            return false;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    log.debug("Closing stream failed.", (Throwable)iOException);
                }
            }
        }
    }

    protected class ProcessAliveListener
    extends Thread {
        private Process p;

        public ProcessAliveListener(Process process) {
            this.setPriority(1);
            this.setDaemon(true);
            this.p = process;
        }

        @Override
        public void run() {
            try {
                this.p.waitFor();
                log.info("External application ended!");
                VisDisplay2 visDisplay2 = WaitForImagesView.this.getDisplay();
                if (visDisplay2 != null) {
                    visDisplay2.getAction(PluginActions.PLUGIN_OFF).perform(null);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

