/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeInfoGlobal;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.MissingWindowCreator;
import com.tiani.jvision.image.DisplaySetSelectionPanel;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowLevelHelper;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.main.AbstractMouseModeInfo;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.DataProfile;
import com.tiani.jvision.overlay.HistogramOverlay;
import com.tiani.jvision.overlay.IEditableOverlay;
import com.tiani.jvision.overlay.IMultiViewOverlay;
import com.tiani.jvision.overlay.LocalizerHighlight;
import com.tiani.jvision.overlay.MiniLocalizerOverlay;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.RectangleOverlayMPR;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Timer;

public class ViewMouseHandler
extends Component
implements IViewMouseHandler,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final ALogger log = ALogger.getLogger(ViewMouseHandler.class);
    private static boolean deactivateMeasurementAfterDrawing = Config.impaxee.jvision.MEASUREMENT.DeactivateMeasurementAfterDrawing.get();
    private static PAction escapeMouseSubMode = PActionRegistry.getAction("MOUSE_MODE_NORMAL");
    private static boolean paintConnections;
    private static ConfigUpdater updater;
    private static boolean localizerIsClickableForImageClassMR;
    private static int MAX_TIME_BETWEEN_CLICKS;
    private static boolean fastMMB;
    private Timer timer;
    private MouseEvent lastEvent;
    private Set<States> state = EnumSet.noneOf(States.class);
    protected PresentationObject activePO;
    protected View view;
    private TextOverlay POtext;

    static {
        updater = new ConfigUpdater();
        localizerIsClickableForImageClassMR = Config.impaxee.jvision.DISPLAY.localizerIsClickableForImageClassMR.get();
        MAX_TIME_BETWEEN_CLICKS = (int)Config.impaxee.jvision.SEQLABEL.DoubleClickInterval.get();
        fastMMB = Config.impaxee.jvision.SEQPANEL.FastPreview.get();
    }

    public static boolean isPaintingConnections() {
        return paintConnections;
    }

    public static void setPaintingConnections(boolean bl) {
        paintConnections = bl;
    }

    @Override
    public void setMouseMoveListener(MouseMotionListener mouseMotionListener) {
        log.warn("Mouse motion listener not supported");
    }

    public ViewMouseHandler(View view) {
        this.view = view;
        this.timer = new Timer(MAX_TIME_BETWEEN_CLICKS, new TimerListener());
    }

    @Override
    public void destruct() {
        this.unEditTextROI();
    }

    @Override
    public PresentationObject getActivePO() {
        return this.activePO;
    }

    @Override
    public boolean roiCreationInProgress() {
        return this.state.contains((Object)States.ROICreation);
    }

    @Override
    public boolean handleLocalizer(MouseEvent mouseEvent) {
        if (this.view.getVis() == null) {
            return false;
        }
        IImageInformation iImageInformation = this.view.getVis().getImageInformation();
        if (iImageInformation != null) {
            List<LocalizerHighlight> list;
            IImageInformation.ImageClass imageClass = iImageInformation.getImageClass();
            IMouseModeInfo iMouseModeInfo = this.getMouseModeInfo();
            if (iMouseModeInfo.getSubMode() == MouseSubModes.DEFAULT && (imageClass == IImageInformation.ImageClass.CT || localizerIsClickableForImageClassMR && imageClass == IImageInformation.ImageClass.MR) && (list = this.view.getOverlays(LocalizerHighlight.class)) != null && list.size() > 0) {
                LocalizerHighlight localizerHighlight = list.get(0);
                return localizerHighlight.handleMouseEvent(mouseEvent);
            }
        }
        return false;
    }

    @Override
    public boolean wantsEvent(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        if (vis2 == null || vis2.getData() == null) {
            return false;
        }
        IMouseModeInfo iMouseModeInfo = this.getMouseModeInfo();
        if (this.view.handleMouseEvent(mouseEvent)) {
            this.state.add(States.Greedy);
            return true;
        }
        if (this.state.contains((Object)States.GetMoves) && mouseEvent.getID() == 503) {
            return true;
        }
        if (ModifierKeys.isLMB((MouseEvent)mouseEvent) && mouseEvent.getID() == 501) {
            if (iMouseModeInfo.isAnyPresentationObjectToPlace(this.view) || this.roiCreationInProgress()) {
                return true;
            }
            if (iMouseModeInfo.getSubMode() == MouseSubModes.DEFAULT || iMouseModeInfo.allowsSelection()) {
                boolean bl;
                boolean bl2 = bl = this.view.getDisplay().getSelectedPO() != null;
                if (this.state.contains((Object)States.isEditingTextROI)) {
                    this.stopEditingTextROI();
                }
                if (!iMouseModeInfo.isAnyPresentationObjectToPlace(vis2.getView())) {
                    boolean bl3 = this.POmousePressed(mouseEvent.getX(), mouseEvent.getY(), true);
                    if (!(bl3 || this.POselectedOnThisView() && (this.activePO == null || this.activePO.isPriorityHandle()))) {
                        this.POmousePressed(mouseEvent.getX(), mouseEvent.getY(), false);
                    }
                } else {
                    this.POmousePressed(mouseEvent.getX(), mouseEvent.getY(), false);
                }
                if (this.POtext != null) {
                    this.editTextROI();
                }
                this.view.getVisView().repaint();
                return bl || this.POselected();
            }
            if (iMouseModeInfo.getSubMode() == MouseSubModes.ZOOM_RECT) {
                return true;
            }
        }
        if (mouseEvent.getID() == 500) {
            if (ModifierKeys.isMMB((MouseEvent)mouseEvent)) {
                return true;
            }
            if (mouseEvent.getClickCount() == 1 && ModifierKeys.is5MButton((MouseEvent)mouseEvent)) {
                return true;
            }
        }
        return false;
    }

    private void onMousePressZoomRect(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        if (vis2.hasData()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 1) {
                n = 1;
            }
            if (n > vis2.getBounds().width - 3) {
                n = vis2.getBounds().width - 3;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            if (n2 > vis2.getBounds().height - 3) {
                n2 = vis2.getBounds().height - 3;
            }
            vis2.startZoomRect(n, n2);
            vis2.repaint();
        }
    }

    private void onMouseReleaseZoomRect(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        if (vis2.hasData()) {
            Object object;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 1) {
                n = 1;
            }
            if (n > vis2.getBounds().width - 3) {
                n = vis2.getBounds().width - 3;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            if (n2 > vis2.getBounds().height - 3) {
                n2 = vis2.getBounds().height - 3;
            }
            vis2.stopZoomRect(n, n2);
            int n3 = Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x;
            int n4 = Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y;
            if (n3 < 0) {
                Vis2.zoomRectStartPt.x = Vis2.zoomRectEndPt.x;
                Vis2.zoomRectEndPt.x = Vis2.zoomRectStartPt.x + Math.abs(n3);
            }
            if (n4 < 0) {
                Vis2.zoomRectStartPt.y = Vis2.zoomRectEndPt.y;
                Vis2.zoomRectEndPt.y = Vis2.zoomRectStartPt.y + Math.abs(n4);
            }
            float f = Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x + 1;
            float f2 = Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y + 1;
            if (f < (float)(this.getBounds().width / 10)) {
                f = this.getBounds().width / 10;
            }
            if (f2 < (float)(this.getBounds().height / 10)) {
                f2 = this.getBounds().height / 10;
            }
            float f3 = f / (float)(this.getBounds().width - 3);
            float f4 = f2 / (float)(this.getBounds().height - 3);
            float f5 = (float)Vis2.zoomRectStartPt.x / (float)(this.getBounds().width - 3);
            float f6 = (float)Vis2.zoomRectStartPt.y / (float)(this.getBounds().height - 3);
            IVOILUT iVOILUT = null;
            if (Config.impaxee.jvision.ZOOMRECT.autoWindowingForZoom.get()) {
                object = this.view.getRenderer().getImageState();
                double[] dArray = new double[]{Vis2.zoomRectStartPt.x, Vis2.zoomRectStartPt.y};
                double[] dArray2 = new double[]{Vis2.zoomRectEndPt.x, Vis2.zoomRectEndPt.y};
                double[] dArray3 = new double[2];
                double[] dArray4 = new double[2];
                ((ImageState)object).screenToImage(dArray, dArray3, null);
                ((ImageState)object).screenToImage(dArray2, dArray4, null);
                RectangleOverlayMPR rectangleOverlayMPR = new RectangleOverlayMPR(dArray3[0], dArray3[1], dArray4[0] - dArray3[0], dArray4[1] - dArray3[1], AnnotationUnits.Pixel);
                rectangleOverlayMPR.setImageState((ImageState)object);
                rectangleOverlayMPR.updateLegend();
                ImageRegion imageRegion = new ImageRegion(rectangleOverlayMPR);
                IImageRegionProperties iImageRegionProperties = vis2.getData().getFrameData().getRawDataContainer().getImageRegionProperties(imageRegion, 0, 0, null);
                iVOILUT = MissingWindowCreator.createMinMaxWindowLevel(vis2.getData().getImageInformation(), iImageRegionProperties.getHistogram());
            }
            object = new ViewportDefinition(f5, f6, f3, f4, vis2.getView());
            this.view.getRenderer().broadcastViewportChange((ViewportDefinition)object);
            if (Config.impaxee.jvision.ZOOMRECT.autoWindowingForZoom.get() && iVOILUT != null) {
                WindowLevelHelper.setWindowLevelForLastModifiedVis(iVOILUT.getWindowCenter(), iVOILUT.getWindowWidth());
            }
            if (Config.impaxee.jvision.ZOOMRECT.UseOnlyOnce.get()) {
                this.view.getDisplayData().getDisplayPlugin().getMouseModeInfo().resetSubMode();
            }
        }
    }

    private void onMouseDragZoomRect(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        if (vis2.hasData()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 1) {
                n = 1;
            }
            if (n > vis2.getBounds().width - 3) {
                n = vis2.getBounds().width - 3;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            if (n2 > vis2.getBounds().height - 3) {
                n2 = vis2.getBounds().height - 3;
            }
            vis2.dragZoomRect(n, n2);
            vis2.repaint();
        }
    }

    private void onMousePressROISelect(MouseEvent mouseEvent) {
        this.view.refresh();
    }

    private void onMouseReleaseROISelect(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        this.POmouseReleased(mouseEvent);
        if (this.view.isImgInvalid()) {
            this.view.refresh();
            vis2.repaint();
        }
    }

    private void onMouseDragROISelect(MouseEvent mouseEvent) {
        if (this.POmouseDragged(mouseEvent) && (this.activePO == null || !this.activePO.isPriorityHandle() || this.view.isImgInvalid())) {
            this.view.repaint();
        }
    }

    private void onMousePressROI(MouseEvent mouseEvent) {
        PresentationObject presentationObject = null;
        if (!this.view.allowROIs()) {
            return;
        }
        if (this.state.contains((Object)States.isEditingTextROI)) {
            this.unEditTextROI();
            return;
        }
        AbstractMouseModeInfo abstractMouseModeInfo = (AbstractMouseModeInfo)this.getMouseModeInfo();
        if (this.roiCreationInProgress()) {
            this.POmousePressed(mouseEvent.getX(), mouseEvent.getY(), false);
            this.view.repaint();
            return;
        }
        AnnotationUnits annotationUnits = abstractMouseModeInfo.isROIRelativeScreen() ? AnnotationUnits.Display : AnnotationUnits.Pixel;
        presentationObject = abstractMouseModeInfo.getPresentationObjectToPlace(this.view);
        if (presentationObject != null) {
            presentationObject.initPlacement(mouseEvent.getX(), mouseEvent.getY(), annotationUnits, abstractMouseModeInfo.isROIFilled(), abstractMouseModeInfo.isROIShuttered());
            this.startPresentationObectCreation(presentationObject);
            if (presentationObject instanceof IMultiViewOverlay) {
                this.copyToOtherViews((IMultiViewOverlay)((Object)presentationObject));
            }
        }
    }

    @Override
    public void startPresentationObectCreation(PresentationObject presentationObject) {
        this.startPresentationObjectCreationImpl(presentationObject, true);
    }

    void startPresentationObjectCreationImpl(PresentationObject presentationObject, boolean bl) {
        Vis2 vis2 = this.view.getVisView();
        if (vis2 != null) {
            vis2.setHRPaintMode(false);
        }
        if (this.view instanceof ImgView2 && ((ImgView2)this.view).isMagnifierOn()) {
            ((ImgView2)this.view).disableMagnifyingGlass();
        }
        if (vis2 != null) {
            vis2.setHRPaintMode(true);
        }
        if (presentationObject instanceof TextOverlay) {
            this.state.add(States.EditAfterCreate);
        }
        this.activatePresentationObject(presentationObject, bl);
        HashSet<Overlay> hashSet = new HashSet<Overlay>();
        if (this.view.getExcludeFromLock() != null) {
            hashSet.addAll(this.view.getExcludeFromLock());
        }
        hashSet.add(presentationObject);
        Overlay[] overlayArray = presentationObject.getCompanions();
        if (overlayArray != null && overlayArray.length > 0 && overlayArray[0] != null && overlayArray[0] instanceof TextOverlay) {
            hashSet.add(overlayArray[0]);
        }
        this.setState(States.WasLockedBefore, this.view.lockBackground);
        this.view.lockBackground(true, hashSet);
        this.view.repaint();
        this.state.add(States.GetMoves);
        this.state.add(States.ROICreation);
    }

    private void copyToOtherViews(IMultiViewOverlay iMultiViewOverlay) {
        for (VisData visData : this.view.getDisplay().getVis()) {
            PresentationObject presentationObject;
            View view = visData.getView();
            if (view == this.view || (presentationObject = iMultiViewOverlay.createCopyFor(view)) == null) continue;
            view.getMouseHandler().startPresentationObectCreation(presentationObject);
        }
    }

    @Override
    public void editPresentationObject(PresentationObject presentationObject) {
        if (presentationObject instanceof IEditableOverlay) {
            ((IEditableOverlay)((Object)presentationObject)).startEditMode();
            new FunctionExecutor(presentationObject){

                @Override
                void executeOn(PresentationObject presentationObject, ViewMouseHandler viewMouseHandler) {
                    viewMouseHandler.startPresentationObjectCreationImpl(presentationObject, false);
                }
            }.execute();
        }
    }

    @Override
    public void deSelect() {
        this.view.lockBackground(false);
        if (this.view.getDisplay() != null) {
            VisDisplay2 visDisplay2 = this.view.getDisplay();
            PresentationObject presentationObject = visDisplay2.getSelectedPO();
            if (presentationObject != null) {
                View view = presentationObject.getView();
                if (view != null && view.getDisplay() != null) {
                    IViewMouseHandler iViewMouseHandler = view.getMouseHandler();
                    if (iViewMouseHandler.POselectedOnThisView()) {
                        iViewMouseHandler.deSelectOnThisView();
                    }
                } else {
                    visDisplay2.setSelectedPO(null);
                }
            } else if (this.POselectedOnThisView()) {
                this.deSelectOnThisView();
            }
        }
    }

    @Override
    public void deSelectOnThisView() {
        new FunctionExecutor(this.activePO){

            @Override
            void executeOn(PresentationObject presentationObject, ViewMouseHandler viewMouseHandler) {
                viewMouseHandler.activePO = presentationObject;
                viewMouseHandler.deSelectOnThisViewImpl();
            }
        }.execute();
    }

    void deSelectOnThisViewImpl() {
        VisDisplayData visDisplayData;
        if (this.activePO != null) {
            this.activePO.select(false);
            if (this.view.getDisplay().getSelectedPO() == this.activePO) {
                this.view.getDisplay().setSelectedPO(null);
            }
        }
        this.activePO = null;
        if (this.POtext != null && !this.isEditingTextROI()) {
            this.POtext = null;
        }
        if ((visDisplayData = this.view.getDisplayData()) != null) {
            IMouseModeInfo iMouseModeInfo = visDisplayData.getDisplayPlugin().getMouseModeInfo();
            if (!this.roiCreationInProgress() && !iMouseModeInfo.isAnyPresentationObjectToPlace(this.view)) {
                this.view.getDisplayData().getDisplayPlugin().getMouseModeInfo().setHotRegionsInside(true);
            }
        }
        this.view.invalidate();
        this.view.repaint();
    }

    private void onMouseReleaseROI(MouseEvent mouseEvent) {
        this.POmouseReleased(mouseEvent);
        new FunctionExecutor(this.activePO){

            @Override
            void executeOn(PresentationObject presentationObject, ViewMouseHandler viewMouseHandler) {
                viewMouseHandler.activePO = presentationObject;
                viewMouseHandler.onMouseReleaseROIImpl();
            }
        }.execute();
    }

    void onMouseReleaseROIImpl() {
        if (this.roiCreationInProgress()) {
            PresentationObject presentationObject = this.activePO;
            this.setState(States.ROICreation, this.checkPresentationObjectCreationStatus());
            if (!this.roiCreationInProgress()) {
                if (this.state.contains((Object)States.WasLockedBefore) && presentationObject != null && this.view.getExcludeFromLock() != null) {
                    this.view.getExcludeFromLock().remove(presentationObject);
                }
                this.view.lockBackground(false);
                if (this.state.contains((Object)States.EditAfterCreate) && this.POtext != null) {
                    this.state.remove((Object)States.EditAfterCreate);
                    if (this.activePO != null) {
                        this.view.presentationObjectCreationDone(this.activePO);
                    }
                    this.editTextROI();
                    this.getMouseModeInfo().setSubMode(MouseSubModes.DEFAULT);
                } else {
                    this.deSelect();
                    this.view.presentationObjectCreationDone(presentationObject);
                    this.view.refresh();
                    this.view.repaint();
                }
                if (this.state.contains((Object)States.WasLockedBefore)) {
                    this.view.lockBackground(true, this.view.excludeFromLock);
                    this.state.remove((Object)States.WasLockedBefore);
                }
                this.state.remove((Object)States.GetMoves);
                return;
            }
        }
        if (this.roiCreationInProgress()) {
            this.view.repaint();
        }
        if (this.activePO != null && this.activePO.isPriorityHandle()) {
            this.deSelect();
        }
    }

    private void onMouseDragROI(MouseEvent mouseEvent) {
        this.POmouseDragged(mouseEvent);
        if (this.roiCreationInProgress()) {
            this.view.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.view != null) {
            this.view.handleMouseEvent(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.view != null) {
            this.view.handleMouseEvent(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.roiCreationInProgress() && paintConnections) {
            for (Overlay overlay : this.view.getVisiblePresentationObjects()) {
                if (!(overlay instanceof PresentationObject) || !((PresentationObject)overlay).mouseMoved(mouseEvent.getX(), mouseEvent.getY())) continue;
                this.view.invalidate();
                this.view.repaint();
                break;
            }
        }
        if (this.state.contains((Object)States.GetMoves)) {
            this.mouseDragged(mouseEvent);
        } else if (this.view != null) {
            this.view.handleMouseEvent(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        if (this.state.contains((Object)States.Greedy)) {
            vis2.getView().handleMouseEvent(mouseEvent);
            return;
        }
        IMouseModeInfo iMouseModeInfo = this.getMouseModeInfo();
        if (iMouseModeInfo.getSubMode() == MouseSubModes.ZOOM_RECT) {
            if (vis2.getData().getParent().getZoomMode() != ZoomMode.TRUESIZE) {
                this.onMouseDragZoomRect(mouseEvent);
            }
        } else if (iMouseModeInfo.getSubMode() == MouseSubModes.DEFAULT || iMouseModeInfo.allowsSelection()) {
            this.onMouseDragROISelect(mouseEvent);
        } else {
            this.onMouseDragROI(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        IMouseModeInfo iMouseModeInfo = this.getMouseModeInfo();
        if (iMouseModeInfo.getSubMode() == MouseSubModes.ZOOM_RECT) {
            this.onMousePressZoomRect(mouseEvent);
        } else if (iMouseModeInfo.getSubMode() == MouseSubModes.DEFAULT || iMouseModeInfo.allowsSelection()) {
            if (iMouseModeInfo.isAnyPresentationObjectToPlace(vis2.getView()) || this.roiCreationInProgress()) {
                this.onMousePressROI(mouseEvent);
            } else {
                this.onMousePressROISelect(mouseEvent);
            }
        } else {
            this.onMousePressROI(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        if (this.state.contains((Object)States.Greedy)) {
            this.state.remove((Object)States.Greedy);
            vis2.getView().handleMouseEvent(mouseEvent);
            return;
        }
        IMouseModeInfo iMouseModeInfo = this.getMouseModeInfo();
        if (iMouseModeInfo.getSubMode() == MouseSubModes.ZOOM_RECT) {
            if (vis2.getData().getParent().getZoomMode() != ZoomMode.TRUESIZE) {
                this.onMouseReleaseZoomRect(mouseEvent);
            }
        } else if (iMouseModeInfo.getSubMode() == MouseSubModes.DEFAULT || iMouseModeInfo.allowsSelection()) {
            if (vis2 != null && iMouseModeInfo.isAnyPresentationObjectToPlace(vis2.getView()) || this.roiCreationInProgress() || this.activePO != null && this.activePO.isPriorityHandle()) {
                this.onMouseReleaseROI(mouseEvent);
            } else {
                this.onMouseReleaseROISelect(mouseEvent);
            }
        } else {
            this.onMouseReleaseROI(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.view != null && mouseEvent.getID() == 500) {
            if (ModifierKeys.isMMB((MouseEvent)mouseEvent)) {
                if (mouseEvent.getClickCount() > 2) {
                    return;
                }
                this.lastEvent = mouseEvent;
                if (fastMMB) {
                    if (ModifierKeys.isCtrl() || ModifierKeys.isSpacePressed()) {
                        this.doubleClick(mouseEvent);
                    } else {
                        this.singleClick(mouseEvent);
                    }
                } else if (this.timer.isRunning()) {
                    this.timer.stop();
                    this.doubleClick(this.lastEvent);
                } else {
                    this.timer.restart();
                }
            } else if (ModifierKeys.is5MButton((MouseEvent)mouseEvent) && mouseEvent.getClickCount() == 1) {
                MouseModeInfoGlobal mouseModeInfoGlobal = MouseModeInfoGlobal.getInstance();
                mouseModeInfoGlobal.setLastSubMode();
                for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
                    IMouseModeInfo iMouseModeInfo = visDisplay2.getData().getDisplayPlugin().getMouseModeInfo();
                    if (mouseModeInfoGlobal == iMouseModeInfo) continue;
                    iMouseModeInfo.setSubMode(mouseModeInfoGlobal.getSubMode());
                }
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.state.remove((Object)States.Greedy);
        this.view.handleMouseWheel(mouseWheelEvent);
    }

    protected IMouseModeInfo getMouseModeInfo() {
        if (this.view != null) {
            return this.view.getDisplayData().getDisplayPlugin().getMouseModeInfo();
        }
        return null;
    }

    private boolean checkPresentationObjectCreationStatus() {
        this.POtext = null;
        if (this.activePO != null) {
            boolean bl;
            boolean bl2 = bl = !this.activePO.isCompleted();
            if (!bl) {
                Overlay[] overlayArray;
                this.state.remove((Object)States.POCreation);
                boolean bl3 = this.activePO.retainEditModeAfterCompletion();
                if (this.activePO instanceof TextOverlay) {
                    this.POtext = (TextOverlay)this.activePO;
                }
                if ((overlayArray = this.activePO.getCompanions()) != null) {
                    int n = 0;
                    while (n < overlayArray.length) {
                        if (overlayArray[n] instanceof TextOverlay) {
                            this.POtext = (TextOverlay)overlayArray[n];
                        }
                        this.deSelect();
                        if (overlayArray[n] instanceof PresentationObject) {
                            if (((PresentationObject)overlayArray[n]).getView() == null) {
                                this.POadd((PresentationObject)overlayArray[n]);
                            }
                        } else if (overlayArray[n] != null) {
                            this.view.addOverlay(overlayArray[n]);
                        }
                        this.deSelect();
                        ++n;
                    }
                }
                this.deactivateMeasurement(bl3);
                this.getMouseModeInfo().restoreStateAfterMeasurement(this.view);
            }
            return bl;
        }
        return false;
    }

    protected void deactivateMeasurement(boolean bl) {
        if (deactivateMeasurementAfterDrawing && !bl) {
            this.activePO = null;
            escapeMouseSubMode.perform(null);
        }
    }

    private boolean POselected() {
        List<VisData> list = this.view.getDisplay().getVisDatas();
        boolean bl = false;
        for (VisData visData : list) {
            if (!visData.getView().getMouseHandler().POselectedOnThisView()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean POselectedOnThisView() {
        return this.POtext != null || this.activePO != null;
    }

    @Override
    public boolean roiLocatedAt(int n, int n2) {
        List<Overlay> list = this.view.getOverlays();
        for (Overlay overlay : list) {
            PresentationObject presentationObject;
            if (!(overlay instanceof PresentationObject) || !(presentationObject = (PresentationObject)overlay).inBounds(n, n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean priorityRoiLocatedAt(int n, int n2) {
        List<Overlay> list = this.view.getOverlays();
        for (Overlay overlay : list) {
            PresentationObject presentationObject;
            if (!(overlay instanceof PresentationObject) || !(presentationObject = (PresentationObject)overlay).isPriorityHandle()) continue;
            boolean bl = presentationObject.acceptsMousePressAt(n, n2);
            return bl;
        }
        return false;
    }

    protected boolean POmousePressed(int n, int n2, boolean bl) {
        Vis2 vis2 = this.view.getVisView();
        this.POtext = null;
        if (this.state.contains((Object)States.POCreation) && this.activePO != null) {
            this.activePO.mousePressed(n, n2);
            return true;
        }
        this.state.remove((Object)States.POModified);
        if (this.activePO != null) {
            if (this.activePO.mousePressed(n, n2)) {
                this.state.add(States.POModified);
                return true;
            }
            if (this.activePO.inBounds(n, n2) && this.activePO instanceof TextOverlay) {
                this.POtext = (TextOverlay)this.activePO;
                return true;
            }
        }
        View view = null;
        if (vis2 == null) {
            return false;
        }
        view = vis2.getView();
        List<Overlay> list = view.getVisiblePresentationObjects();
        int n3 = -1;
        int n4 = 0;
        if (this.activePO != null) {
            n3 = list.indexOf(this.activePO);
        }
        if (n3 < 0) {
            n3 = -1;
        }
        boolean bl2 = false;
        if (list.size() == 1) {
            bl2 = true;
        }
        if (list.size() > 0) {
            int n5 = (n3 + 1) % list.size();
            while (bl2 || n5 != n3 && n4 < list.size()) {
                PresentationObject presentationObject;
                bl2 = false;
                ++n4;
                if (list.get(n5) instanceof PresentationObject && ((PresentationObject)list.get(n5)).isPriorityHandle() == bl && (presentationObject = (PresentationObject)list.get(n5)).mousePressed(n, n2)) {
                    if (this.activePO != presentationObject) {
                        this.setBackgroundForPriorityHandle(presentationObject);
                    }
                    return true;
                }
                n5 = (n5 + 1) % list.size();
            }
        }
        if (view.getDisplay() != null && view.getDisplay().getSelectedPO() != null && (!bl || this.activePO != null && this.activePO.isPriorityHandle())) {
            this.deSelect();
            view.lockBackground(false);
            view.getDisplayData().getDisplayPlugin().getMouseModeInfo().setHotRegionsInside(true);
        }
        return false;
    }

    @Override
    public void setBackgroundForPriorityHandle(PresentationObject presentationObject) {
        PresentationObject presentationObject2 = this.view.getDisplay().getSelectedPO();
        if (presentationObject2 != null) {
            this.deSelect();
            this.view.getDisplay().setSelectedPO(null);
        }
        new FunctionExecutor(presentationObject){

            @Override
            void executeOn(PresentationObject presentationObject, ViewMouseHandler viewMouseHandler) {
                viewMouseHandler.setBackgroundForPriorityHandleImpl(presentationObject);
            }
        }.execute();
    }

    void setBackgroundForPriorityHandleImpl(PresentationObject presentationObject) {
        this.activePO = presentationObject;
        this.activePO.select(true);
        this.view.getDisplay().setSelectedPO(this.activePO);
        this.lockBackgroundForPOandCompanions(this.activePO);
        if (!this.activePO.isPriorityHandle()) {
            this.view.getDisplayData().getDisplayPlugin().getMouseModeInfo().setHotRegionsInside(false);
        }
    }

    @Override
    public void lockBackgroundForPOandCompanions(PresentationObject presentationObject) {
        if (presentationObject != null && presentationObject.doBackgroundLock()) {
            List<PresentationObject> list;
            HashSet<Overlay> hashSet = new HashSet<Overlay>();
            if (this.view.getExcludeFromLock() != null) {
                hashSet.addAll(this.view.getExcludeFromLock());
            }
            hashSet.add(presentationObject);
            Overlay[] overlayArray = presentationObject.getCompanions();
            if (overlayArray != null) {
                int n = 0;
                while (n < overlayArray.length) {
                    if (overlayArray[n] != null) {
                        hashSet.add(overlayArray[n]);
                    }
                    ++n;
                }
            }
            if ((list = presentationObject.getTranslationListeners()) != null) {
                int n = 0;
                while (n < list.size()) {
                    if (list.get(n) != null) {
                        hashSet.add(list.get(n));
                    }
                    ++n;
                }
            }
            this.view.lockBackground(true, hashSet);
        }
    }

    @Override
    public boolean isEditingTextROI() {
        return this.state.contains((Object)States.isEditingTextROI);
    }

    @Override
    public void stopEditingTextROI() {
        this.unEditTextROI();
        PActionRegistry.getAction("MOUSE_MODE_NORMAL").perform(null);
    }

    protected boolean POmouseDragged(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        if (vis2 == null || !vis2.getView().acceptMouseEvent(mouseEvent)) {
            return false;
        }
        if (this.activePO != null) {
            if (mouseEvent.getID() == 506) {
                this.activePO.mouseDragged(mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.activePO.mouseMovedWhileInit(mouseEvent.getX(), mouseEvent.getY());
            }
        }
        vis2.getView().mouseEventComplete(mouseEvent);
        return true;
    }

    protected void POmouseReleased(MouseEvent mouseEvent) {
        Vis2 vis2 = this.view.getVisView();
        if (vis2 != null && vis2.getView().getLastDenied()) {
            this.POmouseDragged(mouseEvent);
        }
        if (this.activePO != null) {
            this.activePO.mouseReleased();
            if (this.activePO.isPriorityHandle()) {
                this.deSelect();
            }
        }
        if (this.state.contains((Object)States.POModified)) {
            this.view.presentationObjectModified(this.activePO);
        }
    }

    @Override
    public void deleteROI(PresentationObject presentationObject) {
        if (this.activePO == presentationObject) {
            this.onROIDelete();
        } else {
            this.view.removeOverlay(presentationObject);
        }
    }

    @Override
    public void onROIDelete() {
        Vis2 vis2 = this.view.getVisView();
        this.POdelete();
        if (this.activePO == null) {
            this.view.lockBackground(false);
            this.view.getDisplayData().getDisplayPlugin().getMouseModeInfo().setHotRegionsInside(true);
            if (vis2 != null && vis2.getView() != null) {
                vis2.getView().refresh();
                vis2.getView().repaint();
            }
        }
    }

    @Override
    public void onROIDeleteAll(boolean bl) {
        this.deSelect();
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>(this.view.getPresentationObjects());
        try {
            for (Overlay object : arrayList) {
                if (object == null || !(object instanceof PresentationObject) || !((PresentationObject)object).isRemoveable() || ((PresentationObject)object).isShutter() && bl) continue;
                this.POdelete((PresentationObject)object);
            }
        }
        catch (Exception exception) {
            log.error("Error deleting presentation object: ", (Throwable)exception);
        }
        if (this.view.getDisplayData().getDisplayPlugin().getMouseModeInfo().isAnyPresentationObjectToPlace(this.view)) {
            this.view.getDisplayData().getDisplayPlugin().getMouseModeInfo().setHotRegionsInside(false);
        }
        this.view.lockBackground(false);
        if (this.view.isInView()) {
            this.view.refresh();
            this.view.repaint();
            Vis2 vis2 = this.view.getVisView();
            if (vis2 != null) {
                vis2.repaint();
            }
        }
    }

    private void editTextROI() {
        Vis2 vis2 = this.view.getVisView();
        this.view.refresh();
        vis2.add(this.POtext.getTextArea());
        this.POtext.startEdit();
        this.state.add(States.isEditingTextROI);
        this.view.refresh();
        this.repaint();
    }

    private void setState(States states, boolean bl) {
        if (bl) {
            this.state.add(states);
        } else {
            this.state.remove((Object)states);
        }
    }

    @Override
    public void setEditingTextROI(boolean bl) {
        this.setState(States.isEditingTextROI, bl);
    }

    @Override
    public void unEditTextROI() {
        Vis2 vis2 = this.view.getVisView();
        if (this.POtext != null && vis2 != null) {
            this.state.remove((Object)States.isEditingTextROI);
            vis2.remove(this.POtext.stopEditing());
            this.deSelect();
        }
    }

    private void POdelete(PresentationObject presentationObject) {
        this.activePO = presentationObject;
        this.POdelete();
    }

    private void POdelete() {
        new FunctionExecutor(this.activePO){

            @Override
            void executeOn(PresentationObject presentationObject, ViewMouseHandler viewMouseHandler) {
                viewMouseHandler.activePO = presentationObject;
                viewMouseHandler.POdeleteImpl();
            }
        }.execute();
    }

    void POdeleteImpl() {
        this.state.remove((Object)States.ROICreation);
        if (this.activePO != null && this.activePO.isRemoveable()) {
            this.activePO.select(false);
            if (this.view.getDisplay().getSelectedPO() == this.activePO) {
                this.view.getDisplay().setSelectedPO(null);
            }
            this.deletePOWithCompanions(this.activePO);
            this.activePO = null;
        }
    }

    private void deletePOWithCompanions(PresentationObject presentationObject) {
        if (presentationObject == null) {
            return;
        }
        SyncablePresentationObject syncablePresentationObject = presentationObject.getCompanionOwner();
        if (syncablePresentationObject != null && (presentationObject instanceof HistogramOverlay || presentationObject instanceof DataProfile || presentationObject instanceof TextOverlay)) {
            presentationObject.setVisible(false);
            if (presentationObject instanceof TextOverlay) {
                ((TextOverlay)presentationObject).setManuallyHidden(true);
            }
            syncablePresentationObject.companionVisibilityChanged(presentationObject, false);
            return;
        }
        List<Overlay> list = this.view.getOverlays();
        Overlay[] overlayArray = presentationObject.getCompanions();
        int n = 0;
        while (overlayArray != null && n < overlayArray.length) {
            if (overlayArray[n] != null) {
                if (overlayArray[n] instanceof PresentationObject) {
                    presentationObject.removeCompanion((PresentationObject)overlayArray[n]);
                }
                this.view.removeOverlay(overlayArray[n]);
                list.remove(overlayArray[n]);
            }
            ++n;
        }
        for (Overlay overlay : list) {
            PresentationObject presentationObject2;
            if (!(overlay instanceof PresentationObject) || !(presentationObject2 = (PresentationObject)overlay).hasCompanion(presentationObject)) continue;
            presentationObject2.removeCompanion(presentationObject);
        }
        if (presentationObject instanceof MiniLocalizerOverlay) {
            LocalizerManager.removeMiniLocalizerFrom(this.view.getDisplay(), (MiniLocalizerOverlay)presentationObject);
        }
        if (presentationObject instanceof SyncablePresentationObject) {
            ((SyncablePresentationObject)presentationObject).removeFromSynclist();
        }
        this.view.removeOverlay(presentationObject);
        list.remove(presentationObject);
    }

    private void POadd(PresentationObject presentationObject) {
        this.activatePresentationObject(presentationObject, true);
    }

    private void activatePresentationObject(PresentationObject presentationObject, boolean bl) {
        if (this.activePO != null) {
            this.view.lockBackground(false);
        }
        Vis2 vis2 = this.view.getVisView();
        if (presentationObject == null) {
            return;
        }
        presentationObject.select(false);
        if (!presentationObject.isCompleted()) {
            this.state.add(States.POCreation);
        }
        if (bl) {
            this.view.addOverlay(presentationObject);
        }
        if (this.activePO != null) {
            this.activePO.select(false);
        }
        this.activePO = presentationObject;
        if (vis2.getView() != null) {
            vis2.getView().refreshPresentationObjects();
        }
    }

    @Override
    public void cancelPresentationObjectCreation() {
        this.state.remove((Object)States.POCreation);
        this.state.remove((Object)States.GetMoves);
    }

    private void singleClick(MouseEvent mouseEvent) {
        if (Config.impaxee.jvision.SEQPANEL.PreviewImagesInMMBContextMenu.get()) {
            if (VisData.getLastModified() != this.view.getVis()) {
                this.view.getVisView().makeTheLastModified();
                if (this.view.getVisView() != null) {
                    this.view.getVisView().repaintBorder();
                }
            }
            DisplaySetSelectionPanel.showAsPopup(mouseEvent, VisData.getLastModified().getParent().getVisDisplay());
        }
    }

    private void doubleClick(MouseEvent mouseEvent) {
        if (Config.impaxee.jvision.DISPLAY.LocalWindowDoubleClick.get()) {
            this.view.localWindow(mouseEvent.getX(), mouseEvent.getY());
        } else {
            if (View.isPointOfInterestBroadcasting()) {
                return;
            }
            this.view.sendLiveSyncEvent(mouseEvent.getPoint());
        }
    }

    private static class ConfigUpdater
    implements IConfigurationChangeListener {
        public ConfigUpdater() {
            ConfigurationProviderFactory.getConfig().registerConfigurationChangeListener(Config.impaxee.jvision.DISPLAY.showConnectionOverlayAndAnnotationOnMouseOver.getKey(), (IConfigurationChangeListener)this);
            this.configurationChanged(null);
        }

        public void configurationChanged(String string) {
            paintConnections = Config.impaxee.jvision.DISPLAY.showConnectionOverlayAndAnnotationOnMouseOver.get();
        }
    }

    private abstract class FunctionExecutor {
        private final PresentationObject overlay;

        FunctionExecutor(PresentationObject presentationObject) {
            this.overlay = presentationObject;
        }

        void execute() {
            this.executeOn(this.overlay, ViewMouseHandler.this);
            if (this.overlay instanceof IMultiViewOverlay) {
                for (PresentationObject presentationObject : ((IMultiViewOverlay)((Object)this.overlay)).getSiblings()) {
                    View view = presentationObject.getView();
                    if (view == null || view == ViewMouseHandler.this.view || !(view.getMouseHandler() instanceof ViewMouseHandler)) continue;
                    this.executeOn(presentationObject, (ViewMouseHandler)view.getMouseHandler());
                }
            }
        }

        abstract void executeOn(PresentationObject var1, ViewMouseHandler var2);
    }

    private static enum States {
        Greedy,
        EditAfterCreate,
        WasLockedBefore,
        POCreation,
        ROICreation,
        POModified,
        GetMoves,
        isEditingTextROI;

    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewMouseHandler.this.timer != null) {
                ViewMouseHandler.this.timer.stop();
                ViewMouseHandler.this.singleClick(ViewMouseHandler.this.lastEvent);
            }
        }
    }
}

