/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.tiani.util.TicketOffice;
import org.dcm4che3.data.Attributes;

public abstract class TransferFunction
implements Cloneable {
    private static final int colorBlack = 0;
    protected boolean lock = false;
    protected int[] rgb;
    protected int tusi;
    protected boolean modified = true;
    protected int grays;
    protected boolean inverted = false;

    public TransferFunction() {
        this.tusi = (int)TicketOffice.getNewStamp();
    }

    TransferFunction(TransferFunction transferFunction) {
        this.set(transferFunction);
    }

    TransferFunction(int n) {
        this();
        this.grays = n;
        while ((n & 1) == 0) {
            n >>= 1;
        }
    }

    public void set(TransferFunction transferFunction) {
        if (transferFunction == null) {
            return;
        }
        this.tusi = Math.max(this.tusi, transferFunction.tusi) + 1;
        ++this.tusi;
        this.modified = transferFunction.modified;
        this.grays = transferFunction.grays;
        this.inverted = transferFunction.inverted;
    }

    public void setUpdateID(int n) {
        this.tusi = n;
    }

    public void lockTable(boolean bl) {
        this.lock = bl;
    }

    public int getGrays() {
        return this.grays;
    }

    public abstract int getOffset(boolean var1);

    public abstract int[] getRGB(boolean var1);

    public abstract boolean isRawDataInverted();

    public int[] getRGBWithoutOpacity(boolean bl) {
        return this.getRGB(bl);
    }

    public int getUpdateID() {
        return this.tusi;
    }

    public void recalc() {
        this.tusi = (int)TicketOffice.getNewStamp();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public int getMinimumColor() {
        return 0;
    }

    public int getMinimumRampColor() {
        if (this.rgb != null && this.rgb.length > 0) {
            return this.rgb[0];
        }
        return 0;
    }

    public void storeTo(Attributes attributes) {
    }
}

