/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.listtext.dicomobject.lut.IColorLookupTableSource;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTable;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.tiani.jvision.image.PaletteColorLUT;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowTransferFunction;
import org.dcm4che3.data.Attributes;

public class SegmentedPaletteColorLUT
extends PaletteColorLUT {
    private int center;
    private int width;

    public SegmentedPaletteColorLUT(IColorLookupTableSource iColorLookupTableSource, int n, WindowDef windowDef, int n2) {
        super(iColorLookupTableSource, n);
        this.paddingValue = n2;
        this.setWindow(windowDef);
    }

    public SegmentedPaletteColorLUT(SegmentedPaletteColorLUT segmentedPaletteColorLUT) {
        super(segmentedPaletteColorLUT);
        this.center = segmentedPaletteColorLUT.center;
        this.width = segmentedPaletteColorLUT.width;
    }

    private byte[] scale(ILookupTable iLookupTable, int n, int n2) {
        int[] nArray = iLookupTable.getLUT();
        byte[] byArray = new byte[this.grays];
        int n3 = iLookupTable.getOutputBits() - 8;
        int n4 = n2 >= 0 ? 0 : -n2;
        int n5 = 0;
        while (n5 < n2) {
            byArray[n4++] = (byte)(nArray[0] >> n3);
            ++n5;
        }
        n5 = 0;
        while (n5 < n) {
            int n6 = (int)((long)n5 * 256L * (long)nArray.length / (long)n);
            int n7 = n6 / 256;
            int n8 = n6 & 0xFF;
            if (n4 >= byArray.length || n7 >= nArray.length - 1) break;
            if (n4 >= 0) {
                byArray[n4] = (byte)((nArray[n7] * (256 - n8) + nArray[n7 + 1] * n8) / 256 >> n3);
            }
            ++n4;
            ++n5;
        }
        while (n4 < byArray.length) {
            if (n4 >= 0) {
                byArray[n4] = (byte)(nArray[nArray.length - 1] >> n3);
            }
            ++n4;
        }
        return byArray;
    }

    @Override
    public void setWindow(WindowDef windowDef) {
        int n = windowDef.getDataCenter();
        int n2 = windowDef.getDataWidth();
        if (n != this.center || n2 != this.width) {
            this.width = n2;
            this.center = n;
            this.ccRed = this.scale(this.redLUT, this.width + 1, this.center - (this.width >> 1));
            this.ccGreen = this.scale(this.greenLUT, this.width + 1, this.center - (this.width >> 1));
            this.ccBlue = this.scale(this.blueLUT, this.width + 1, this.center - (this.width >> 1));
            this.modified = true;
        }
    }

    @Override
    public WindowTransferFunction getClone() {
        SegmentedPaletteColorLUT segmentedPaletteColorLUT = new SegmentedPaletteColorLUT(this);
        return segmentedPaletteColorLUT;
    }

    public int getCenter() {
        return this.center;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void storeTo(Attributes attributes) {
        PaletteColorLUTModule paletteColorLUTModule = new PaletteColorLUTModule();
        paletteColorLUTModule.setTo(IColorLookupTableSource.Channel.Red, this.redLUT);
        paletteColorLUTModule.setTo(IColorLookupTableSource.Channel.Green, this.greenLUT);
        paletteColorLUTModule.setTo(IColorLookupTableSource.Channel.Blue, this.blueLUT);
        paletteColorLUTModule.writeTo(attributes);
    }

    @Override
    public WindowDef getWindowDef() {
        WindowDef windowDef = new WindowDef(this.getGrays(), (double)this.center / (double)this.getGrays(), (double)this.width / (double)this.getGrays());
        return windowDef;
    }
}

