/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.util.List;

public class ModalityLUTAction
extends SelectablePAction {
    public static final String ID = "MODALITY_LUT_ENABLING";

    @Override
    public boolean isSelected() {
        return this.getGSTS().isModalityLUTEnabled();
    }

    @Override
    public String getCaption() {
        return Messages.getString("Action.ModalityLUT.Caption");
    }

    @Override
    public String getName() {
        return Messages.getString("Action.ModalityLUT.Name");
    }

    @Override
    protected boolean isEnabledImpl() {
        GrayScaleTransformationSequence grayScaleTransformationSequence = this.getGSTS();
        IImageInformation iImageInformation = this.getImageInformation();
        if (grayScaleTransformationSequence == null || iImageInformation == null) {
            return false;
        }
        ModalityLUT modalityLUT = iImageInformation.getModalityLUT();
        return grayScaleTransformationSequence.hasModalityLUTEnabled() || modalityLUT != null && modalityLUT.getModalityLookupTable() != null;
    }

    private GrayScaleTransformationSequence getGSTS() {
        View view = AbstractPDataAction.getCurrentImage().getView();
        if (!(view instanceof ImgView2)) {
            return null;
        }
        ImgView2 imgView2 = (ImgView2)view;
        TransferFunction transferFunction = imgView2.getTransferFunction();
        if (transferFunction == null) {
            return null;
        }
        return ((WindowTransferFunction)transferFunction).getGSTS();
    }

    private IImageInformation getImageInformation() {
        View view = AbstractPDataAction.getCurrentImage().getView();
        if (view == null) {
            return null;
        }
        return view.getImageInformation();
    }

    @Override
    public boolean isUpdatingListeners() {
        return false;
    }

    @Override
    public String getGroupName() {
        return WINDOW_LEVEL_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public boolean perform(Component component) {
        this.notifyActionPerformed();
        List<VisData> list = AbstractPDataAction.getVisDatas(PDataScope.CurrentDisplay);
        if (list.size() == 0) {
            Message.info(Messages.getString("VISPOPUP_NO_SELECTED_IMAGES"));
            return false;
        }
        boolean bl = !this.isSelected();
        for (VisData visData : list) {
            WindowTransferFunction windowTransferFunction = (WindowTransferFunction)visData.getView().getTransferFunction();
            if (windowTransferFunction == null) continue;
            GrayScaleTransformationSequence grayScaleTransformationSequence = windowTransferFunction.getGSTS();
            if (bl) {
                grayScaleTransformationSequence.useModalityLUT(visData.getView().getImageInformation());
            } else {
                grayScaleTransformationSequence.useModalityLUT(null);
            }
            View view = visData.getView();
            view.invalidate();
            view.repaint();
        }
        return true;
    }
}

