/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.tiani.base.data.ClippingShape;
import java.awt.Rectangle;

public class ClippingCircle
implements ClippingShape {
    protected int x;
    protected int y;
    protected int r;
    protected int diameter;
    protected int rSquared;
    protected boolean bboxOnly = false;

    public ClippingCircle(int n, int n2, double d) {
        this.x = n;
        this.y = n2;
        this.r = (int)d;
        this.rSquared = (int)(d * d);
        this.diameter = (int)(2.0 * d);
    }

    public void setCenter(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setBBoxOnly(boolean bl) {
        this.bboxOnly = bl;
    }

    @Override
    public boolean useBBoxOnly() {
        return this.bboxOnly;
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this.x - this.r, this.y - this.r, this.diameter, this.diameter);
    }

    @Override
    public Rectangle getImageSpaceBoundingBox() {
        return new Rectangle(this.x - this.r, this.y - this.r, this.diameter, this.diameter);
    }

    @Override
    public boolean isInside(int n, int n2) {
        return (n -= this.x) * n + (n2 -= this.y) * n2 < this.rSquared;
    }

    @Override
    public double[] pixelToDef(double d, double d2) {
        return new double[]{d, d2};
    }
}

