/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.PixelSizeCalibrationDialog;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.overlay.LengthOverlay;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;

public class CalibrationAction
extends AbstractPAction {
    public static final String ID = "IMAGE_CALIBRATION";

    @Override
    public String getCaption() {
        return Messages.getString("ImgView2.CalibratePixelSize");
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    protected boolean isEnabledImpl() {
        PluginName pluginName;
        VisDisplay2 visDisplay2 = AbstractPDataAction.getCurrentDisplay();
        if (visDisplay2 != null && visDisplay2.hasData() && ((pluginName = visDisplay2.getData().getPlugin().getPluginName()) == PluginName.DEFAULT || pluginName == PluginName.ADDSUB)) {
            IImageInformation iImageInformation = AbstractPDataAction.getCurrentImage().getImageInformation();
            boolean bl = iImageInformation.hasImageRegionSpacing();
            boolean bl2 = ImageDef.hasQuadraticPixels(iImageInformation);
            return !bl && bl2;
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return !Product.isCDViewer() && !Product.isReducedVersion();
    }

    @Override
    public boolean perform(Component component) {
        VisData visData;
        LengthOverlay lengthOverlay;
        block8: {
            block7: {
                this.notifyActionPerformed();
                lengthOverlay = null;
                visData = AbstractPDataAction.getCurrentImage();
                if (visData != null) break block7;
                return false;
            }
            if (visData.getView() instanceof ImgView2) break block8;
            return false;
        }
        try {
            ImgView2 imgView2 = (ImgView2)visData.getView();
            for (LengthOverlay object : Overlay.filter(LengthOverlay.class, imgView2.getOverlays())) {
                if (!object.isSelected() && lengthOverlay != null) continue;
                lengthOverlay = object;
            }
            if (lengthOverlay != null) {
                PixelSizeCalibrationDialog pixelSizeCalibrationDialog = new PixelSizeCalibrationDialog(imgView2, Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_TITLE"), lengthOverlay);
                pixelSizeCalibrationDialog.setVisible(true);
            } else {
                Message.error(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_NOOVERLAY"));
            }
        }
        catch (Exception exception) {}
        return true;
    }
}

