/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.dnd;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.tiani.jvision.dnd.DisplaySetDataFlavorProviderFactory;
import com.tiani.jvision.dnd.IDisplaySetDataFlavorProvider;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SeqTransferable
implements Transferable {
    private static final List<DataFlavor> flavors = SeqTransferable.getSupportedFlavors();
    private WeakReference<IDisplaySet> displaySet;

    public SeqTransferable(IDisplaySet iDisplaySet) {
        this.displaySet = new WeakReference<IDisplaySet>(iDisplaySet);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return flavors.contains(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        IDisplaySet iDisplaySet = (IDisplaySet)this.displaySet.get();
        if (iDisplaySet == null) {
            return null;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return iDisplaySet.toString();
        }
        if (IDisplaySet.dataFlavor.equals(dataFlavor)) {
            return iDisplaySet;
        }
        Collection<IDisplaySetDataFlavorProvider> collection = DisplaySetDataFlavorProviderFactory.getInstance().getDisplaySetDataFlavorProvider();
        if (collection != null) {
            for (IDisplaySetDataFlavorProvider iDisplaySetDataFlavorProvider : collection) {
                if (!iDisplaySetDataFlavorProvider.isFlavorSupported(dataFlavor)) continue;
                return iDisplaySetDataFlavorProvider.getTransferData(dataFlavor, iDisplaySet);
            }
        }
        return null;
    }

    private static List<DataFlavor> getSupportedFlavors() {
        ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
        arrayList.add(DataFlavor.stringFlavor);
        arrayList.add(IDisplaySet.dataFlavor);
        Collection<IDisplaySetDataFlavorProvider> collection = DisplaySetDataFlavorProviderFactory.getInstance().getDisplaySetDataFlavorProvider();
        if (collection != null) {
            for (IDisplaySetDataFlavorProvider iDisplaySetDataFlavorProvider : collection) {
                DataFlavor[] dataFlavorArray = iDisplaySetDataFlavorProvider.getSupportedFlavors();
                if (dataFlavorArray == null) continue;
                DataFlavor[] dataFlavorArray2 = dataFlavorArray;
                int n = dataFlavorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor dataFlavor = dataFlavorArray2[n2];
                    if (!arrayList.contains(dataFlavor)) {
                        arrayList.add(dataFlavor);
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }
}

