/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.workarounds.multimonitor;

import com.tiani.gui.workarounds.multimonitor.MultiMonitorLabel;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorList;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public abstract class MultiMonitorCellRenderer<E>
extends MultiMonitorLabel
implements ListCellRenderer<E> {
    protected final Color selectionBackgroundColor;
    protected final Color selectionForegroundColor;
    protected final Color defaultForegroundColor;
    protected final Color defaultBackgroundColor;

    public MultiMonitorCellRenderer() {
        this(2, 4);
    }

    public MultiMonitorCellRenderer(int n, int n2) {
        this(new MultiMonitorList(), n, n2);
    }

    public MultiMonitorCellRenderer(JList<E> jList, int n, int n2) {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(n, n2, n, n2));
        this.defaultForegroundColor = jList.getForeground();
        this.defaultBackgroundColor = jList.getBackground();
        this.selectionBackgroundColor = jList.getSelectionBackground();
        this.selectionForegroundColor = jList.getSelectionForeground();
    }

    public void setSelected(boolean bl) {
        this.setBackground(bl ? this.selectionBackgroundColor : this.defaultBackgroundColor);
        this.setForeground(bl ? this.selectionForegroundColor : this.defaultForegroundColor);
    }

    @Override
    public MultiMonitorCellRenderer<E> getListCellRendererComponent(JList<? extends E> jList, E e, int n, boolean bl, boolean bl2) {
        this.setSelected(bl);
        this.setFont(jList.getFont());
        this.setText(e == null ? null : this.getText(e));
        this.setToolTipText(e == null ? null : this.getToolTipText(e, this.getText()));
        this.setOpaque(bl);
        return this;
    }

    protected abstract String getText(E var1);

    protected abstract String getToolTipText(E var1, String var2);
}

