/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible;

import com.agfa.pacs.impaxee.Messages;
import com.tiani.gui.util.panel.flexible.FlexiblePanel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractBehaviourControl
implements ChangeListener {
    protected static final int POPUP_STATE_INDEX = 0;
    protected static final int DIALOG_STATE_INDEX = 1;
    protected static final int DOCKED_STATE_INDEX = 2;
    protected static final int INVISIBLE_STATE_INDEX = 3;
    protected static final int LAST_STATE_INDEX = 3;
    protected Action[] orderedActions;
    protected FlexiblePanel flexiblePanel;

    protected AbstractBehaviourControl(FlexiblePanel flexiblePanel, int n) {
        AbstractAction abstractAction;
        this.flexiblePanel = flexiblePanel;
        this.orderedActions = new Action[4];
        if ((n & 4) != 0 || (n & 1) != 0) {
            abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractBehaviourControl.this.flexiblePanel.setBehaviour(AbstractBehaviourControl.this.flexiblePanel.getPopupBehaviour());
                }
            };
            abstractAction.putValue("SmallIcon", this.loadIcon("popup.gif"));
            abstractAction.putValue("Name", Messages.getString("Popup_Behaviour"));
            abstractAction.putValue("ShortDescription", Messages.getString("Popup_Behaviour_Tooltip"));
            this.orderedActions[0] = abstractAction;
        }
        if ((n & 8) != 0) {
            abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractBehaviourControl.this.flexiblePanel.setBehaviour(8);
                }
            };
            abstractAction.putValue("SmallIcon", this.loadIcon("restore.gif"));
            abstractAction.putValue("Name", Messages.getString("Dialog_Behaviour"));
            abstractAction.putValue("ShortDescription", Messages.getString("Dialog_Behaviour_Tooltip"));
            this.orderedActions[1] = abstractAction;
        }
        if ((n & 2) != 0) {
            abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractBehaviourControl.this.flexiblePanel.setBehaviour(2);
                }
            };
            abstractAction.putValue("SmallIcon", this.loadIcon("maximize.gif"));
            abstractAction.putValue("Name", Messages.getString("Docked_Behaviour"));
            abstractAction.putValue("ShortDescription", Messages.getString("Docked_Behaviour_Tooltip"));
            this.orderedActions[2] = abstractAction;
        }
        if ((n & 0x10) != 0) {
            abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractBehaviourControl.this.flexiblePanel.setBehaviour(16);
                }
            };
            abstractAction.putValue("SmallIcon", this.loadIcon("hide.gif"));
            abstractAction.putValue("Name", Messages.getString("Invisible_Behaviour"));
            abstractAction.putValue("ShortDescription", Messages.getString("Invisible_Behaviour_Tooltip"));
            this.orderedActions[3] = abstractAction;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        FlexiblePanel flexiblePanel = (FlexiblePanel)changeEvent.getSource();
        int n = flexiblePanel.getBehaviour();
        int n2 = 0;
        while (n2 < this.orderedActions.length) {
            if (this.orderedActions[n2] != null) {
                this.orderedActions[n2].setEnabled(!this.isIndexForState(n, n2));
            }
            ++n2;
        }
    }

    protected final boolean isIndexForState(int n, int n2) {
        return n2 == 0 && (n == 1 || n == 4) || n2 == 1 && n == 8 || n2 == 3 && n == 16 || n2 == 2 && n == 2;
    }

    protected abstract Icon loadIcon(String var1);

    public void close() {
        this.orderedActions = null;
        this.flexiblePanel = null;
    }
}

