/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.icon;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ScalableIcon
implements Cloneable,
Icon {
    private static final float DARKEN_FACTOR_ON_POPUP = 0.8f;
    private ImageIcon icon;
    private ImageIcon lightIcon;

    public ScalableIcon(ImageIcon imageIcon, int n) {
        this.icon = imageIcon;
        this.calculateIcons(n);
    }

    public Object clone() {
        return new ScalableIcon(this.icon, this.getIconHeight());
    }

    public Icon getLightIcon() {
        return this.lightIcon;
    }

    private void calculateIcons(int n) {
        int n2;
        int n3 = this.icon.getIconWidth();
        int n4 = this.icon.getIconHeight();
        if (n4 != (n2 = GUI.getScaledDiagnosticInt((int)n))) {
            double d = (double)n3 / (double)n4;
            n4 = n2;
            n3 = (int)Math.round((double)n4 * d);
        }
        if (n3 != this.icon.getIconWidth() || n4 != this.icon.getIconHeight()) {
            Image image = IconUtil.scaleImage((Image)this.icon.getImage(), (int)n3, (int)n4);
            this.lightIcon = new ImageIcon(image);
            this.icon = this.darkenIcon(this.lightIcon);
        } else {
            this.lightIcon = this.icon;
            this.icon = this.darkenIcon(this.icon);
        }
    }

    private void darkenLightenImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f) {
        int[] nArray = bufferedImage.getRaster().getPixels(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), (int[])null);
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)((float)nArray[n] * 0.8f) & 0xFF;
            nArray[n + 1] = (int)((float)nArray[n + 1] * 0.8f) & 0xFF;
            nArray[n + 2] = (int)((float)nArray[n + 2] * 0.8f) & 0xFF;
            n += 4;
        }
        bufferedImage2.getRaster().setPixels(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), nArray);
    }

    private ImageIcon darkenIcon(ImageIcon imageIcon) {
        if (imageIcon.getImage() instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)imageIcon.getImage();
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
            this.darkenLightenImage(bufferedImage, bufferedImage2, 0.8f);
            return new ImageIcon(bufferedImage2);
        }
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics2D.dispose();
        this.darkenLightenImage(bufferedImage, bufferedImage, 0.8f);
        return new ImageIcon(bufferedImage);
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.icon.paintIcon(component, graphics, n, n2);
    }
}

