/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.event;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RecursivelyInstallableMouseListenerMixin
extends MouseAdapter {
    private static final Logger log = Logger.getLogger(RecursivelyInstallableMouseListenerMixin.class);
    private ContainerListener containerListener = new DynamicContainerChangesListener();
    private List<Class<?>> excludedClasses = new ArrayList();
    private List<Class<?>> includedClasses = null;

    public synchronized void installOn(Component component) {
        this.installOn(component, null);
    }

    public synchronized void installOn(Component component, Class<?> clazz) {
        this.handleMouseListenerRecursive(component, true, clazz, this.containerListener);
    }

    public synchronized void deinstallFrom(Component component) {
        this.handleMouseListenerRecursive(component, false, null, this.containerListener);
    }

    protected Component[] getChildrenForListenerInstallation(Container container) {
        return container.getComponents();
    }

    protected void handleMouseListenerRecursive(Component component, boolean bl, Class<?> clazz, ContainerListener containerListener) {
        if (clazz != null) {
            this.excludeSubComponentFromListening(clazz);
        }
        if (component == null) {
            return;
        }
        if (bl && (this.isExcluded(component.getClass()) || !this.isIncluded(component.getClass()))) {
            return;
        }
        component.removeMouseMotionListener(this);
        component.removeMouseListener(this);
        if (bl) {
            component.addMouseMotionListener(this);
            component.addMouseListener(this);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(containerListener);
            if (bl) {
                container.addContainerListener(containerListener);
            }
            Component[] componentArray = this.getChildrenForListenerInstallation(container);
            int n = 0;
            while (n < componentArray.length) {
                this.handleMouseListenerRecursive(componentArray[n], bl, clazz, containerListener);
                ++n;
            }
        }
    }

    private boolean isExcluded(Class<?> clazz) {
        int n = 0;
        while (n < this.excludedClasses.size()) {
            Class<?> clazz2 = this.excludedClasses.get(n);
            if (clazz2 == clazz || clazz2.isAssignableFrom(clazz)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isIncluded(Class<?> clazz) {
        if (this.includedClasses == null) {
            return true;
        }
        int n = 0;
        while (n < this.includedClasses.size()) {
            Class<?> clazz2 = this.includedClasses.get(n);
            if (clazz2 == clazz || clazz2.isAssignableFrom(clazz)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void excludeSubComponentFromListening(Class<?> clazz) {
        if (this.excludedClasses.indexOf(clazz) < 0) {
            this.excludedClasses.add(clazz);
            if (this.excludedClasses.size() > 10) {
                log.warn((Object)("WARNING: too much elements in exclude-list: " + this.excludedClasses.size()));
            }
        }
    }

    public void includeSubComponentIntoListening(Class<?> clazz) {
        if (this.includedClasses == null) {
            this.includedClasses = new ArrayList();
        }
        if (this.includedClasses.indexOf(clazz) < 0) {
            this.includedClasses.add(clazz);
            if (this.includedClasses.size() > 10) {
                log.warn((Object)("WARNING: too much elements in include-list: " + this.includedClasses.size()));
            }
        }
    }

    private class DynamicContainerChangesListener
    implements ContainerListener {
        private DynamicContainerChangesListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            RecursivelyInstallableMouseListenerMixin.this.handleMouseListenerRecursive(containerEvent.getChild(), true, null, this);
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            RecursivelyInstallableMouseListenerMixin.this.handleMouseListenerRecursive(containerEvent.getChild(), false, null, this);
        }
    }
}

