/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.event;

import com.tiani.gui.util.event.DefaultMouseMoveListener;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class PanelDragListener
extends DefaultMouseMoveListener {
    private final JPanel panel;
    private Point mouseDown;

    private PanelDragListener(JPanel jPanel) {
        this.panel = jPanel;
        this.includeSubComponentIntoListening(JTabbedPane.class);
        this.includeSubComponentIntoListening(JPanel.class);
        this.installOn(jPanel);
    }

    public static PanelDragListener activateFor(JPanel jPanel) {
        return new PanelDragListener(jPanel);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDown = this.convertPoint(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        Window window = SwingUtilities.windowForComponent(this.panel);
        if (window instanceof JDialog || window instanceof JWindow) {
            Point point = this.convertPoint(mouseEvent);
            int n = point.x - this.mouseDown.x;
            int n2 = point.y - this.mouseDown.y;
            Point point2 = window.getLocation();
            int n3 = point2.x + n;
            int n4 = point2.y + n2;
            window.setLocation(n3, n4);
        }
    }

    private Point convertPoint(MouseEvent mouseEvent) {
        return SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.panel);
    }
}

