/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util;

import com.agfa.pacs.impaxee.utils.IconFactory;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class TIcon
extends ImageIcon {
    private static final ALogger log = ALogger.getLogger(TIcon.class);
    public static final String ICON_PATH = "/icons/";
    private static final IconFactory iconFactory = new IconFactory(new String[]{"/icons"});
    private boolean defaultIconUsed = false;
    private URL deferredURL;
    private int iconWidth = -1;
    private int iconHeight = -1;
    private boolean scale = false;

    public TIcon(String string) {
        this.initURL(string);
    }

    protected TIcon(String string, int n, int n2) {
        this(string);
        this.initIconScale(n, n2);
        this.initURL(string);
    }

    public TIcon(Image image, String string) {
        super(image);
    }

    protected TIcon(Image image, String string, int n, int n2) {
        this(image, string);
        this.initIconScale(n, n2);
        this.ensureScaledIcon(image);
    }

    private void ensureScaledIcon(Image image) {
        if (this.scale) {
            image = IconUtil.scaleImage((Image)image, (int)this.iconWidth, (int)this.iconHeight);
        }
        this.setImage(image);
    }

    private void initIconScale(int n, int n2) {
        this.iconWidth = n;
        this.iconHeight = n2;
        this.scale = n > 0 || n2 > 0;
    }

    private void initURL(String string) {
        this.deferredURL = iconFactory.getResource(string, this.getClass());
        if (this.deferredURL == null) {
            this.makeDefaultIcon();
        }
    }

    private void doLoad() {
        if (this.deferredURL == null) {
            return;
        }
        try {
            try {
                Image image = Toolkit.getDefaultToolkit().getImage(this.deferredURL);
                this.loadImage(image);
                this.ensureScaledIcon(image);
            }
            catch (Exception exception) {
                log.error("TIcon load error!", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            log.error("TIcon invalid image " + this.deferredURL.toString(), (Throwable)exception);
        }
        this.deferredURL = null;
    }

    private void makeDefaultIcon() {
        int n = 32;
        int n2 = 32;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (graphics2D != null) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setColor(Color.red);
            graphics2D.drawRect(0, 0, n - 1, n2 - 1);
            graphics2D.drawLine(0, 0, n - 1, n2 - 1);
            graphics2D.drawLine(0, n2 - 1, n - 1, 0);
            graphics2D.dispose();
        }
        this.setImage(bufferedImage);
        bufferedImage.flush();
        this.defaultIconUsed = true;
    }

    public boolean isDefaultIcon() {
        return this.defaultIconUsed;
    }

    @Override
    public int getIconHeight() {
        this.doLoad();
        return super.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        this.doLoad();
        return super.getIconWidth();
    }

    @Override
    public Image getImage() {
        this.doLoad();
        return super.getImage();
    }

    @Override
    public int getImageLoadStatus() {
        this.doLoad();
        return super.getImageLoadStatus();
    }

    @Override
    public ImageObserver getImageObserver() {
        this.doLoad();
        return super.getImageObserver();
    }

    @Override
    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.doLoad();
        super.paintIcon(component, graphics, n, n2);
    }
}

