/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util;

import com.agfa.pacs.base.util.Product;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;

public class GraphicsDeviceInfo {
    public final RasterScreen[] screens;

    public GraphicsDeviceInfo() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (Product.isHeadless()) {
            this.screens = null;
            return;
        }
        Dimension dimension = toolkit.getScreenSize();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray != null ? graphicsDeviceArray.length : -1;
        ArrayList<GraphicsDevice> arrayList = new ArrayList<GraphicsDevice>(4);
        ArrayList<GraphicsDevice> arrayList2 = new ArrayList<GraphicsDevice>(2);
        ArrayList<GraphicsDevice> arrayList3 = new ArrayList<GraphicsDevice>();
        boolean bl = System.getProperty("os.name").toLowerCase().contains("win");
        int n2 = 0;
        while (n2 < n) {
            if (graphicsDeviceArray[n2].getType() == 0) {
                if (!bl || graphicsDeviceArray[n2].getDisplayMode().getRefreshRate() != 0) {
                    arrayList.add(graphicsDeviceArray[n2]);
                }
            } else if (graphicsDeviceArray[n2].getType() == 1) {
                arrayList2.add(graphicsDeviceArray[n2]);
            } else if (graphicsDeviceArray[n2].getType() == 2) {
                arrayList3.add(graphicsDeviceArray[n2]);
            }
            ++n2;
        }
        Comparator<GraphicsDevice> comparator = new Comparator<GraphicsDevice>(){

            @Override
            public int compare(GraphicsDevice graphicsDevice, GraphicsDevice graphicsDevice2) {
                return graphicsDevice.getDefaultConfiguration().getBounds().x - graphicsDevice2.getDefaultConfiguration().getBounds().x;
            }
        };
        Collections.sort(arrayList, comparator);
        this.screens = new RasterScreen[arrayList.size()];
        int n3 = 0;
        while (n3 < arrayList.size()) {
            this.screens[n3] = this.createDeviceInfo((GraphicsDevice)arrayList.get(n3), arrayList.get(n3) == graphicsDevice, dimension, toolkit);
            ++n3;
        }
    }

    private RasterScreen createDeviceInfo(GraphicsDevice graphicsDevice, boolean bl, Dimension dimension, Toolkit toolkit) {
        Object object;
        Properties properties = new Properties();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        boolean bl2 = dimension != null && rectangle.x >= 0 && rectangle.x + rectangle.width <= dimension.width;
        try {
            properties.put("accelerated", "" + graphicsConfiguration.getImageCapabilities().isAccelerated());
            properties.put("trueVolatile", "" + graphicsConfiguration.getImageCapabilities().isTrueVolatile());
            object = toolkit.getScreenInsets(graphicsConfiguration);
            properties.put("insets left", "" + ((Insets)object).left);
            properties.put("insets right", "" + ((Insets)object).right);
            properties.put("insets top", "" + ((Insets)object).top);
            properties.put("insets bottom", "" + ((Insets)object).bottom);
            properties.put("displayChangeSupported", "" + graphicsDevice.isDisplayChangeSupported());
            properties.put("fullScreenSupported", "" + graphicsDevice.isFullScreenSupported());
        }
        catch (Error error) {
            error.printStackTrace();
        }
        try {
            object = graphicsDevice.getDisplayMode();
            properties.put("displayModeHeight", "" + ((DisplayMode)object).getHeight());
            properties.put("displayModeWidth", "" + ((DisplayMode)object).getWidth());
            properties.put("bitDepth", "" + ((DisplayMode)object).getBitDepth());
            properties.put("refreshRate", "" + ((DisplayMode)object).getRefreshRate());
        }
        catch (Error error) {
            error.printStackTrace();
        }
        try {
            object = graphicsConfiguration.getColorModel();
            properties.put("bitsPerPixel", "" + ((ColorModel)object).getPixelSize());
            properties.put("transparency", ((ColorModel)object).getTransparency() == 3 ? "TRANSLUCENT" : (((ColorModel)object).getTransparency() == 1 ? "OPAQUE" : (((ColorModel)object).getTransparency() == 2 ? "BITMASK" : "(unknown)")));
            properties.put("alpha", "" + ((ColorModel)object).hasAlpha());
            properties.put("alphaPremultiplied", "" + ((ColorModel)object).isAlphaPremultiplied());
        }
        catch (Error error) {
            error.printStackTrace();
        }
        return graphicsDevice.getType() == 0 ? new RasterScreen(graphicsDevice, properties, bl, bl2) : null;
    }

    public static class RasterScreen {
        public final boolean isDefault;
        public final boolean isWithinAWTScreen;
        public final GraphicsDevice device;
        public final Properties properties;

        public RasterScreen(GraphicsDevice graphicsDevice, Properties properties, boolean bl, boolean bl2) {
            this.device = graphicsDevice;
            this.properties = properties;
            this.isDefault = bl;
            this.isWithinAWTScreen = bl2;
        }

        public Rectangle getBounds() {
            return this.device.getDefaultConfiguration().getBounds();
        }
    }
}

