/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config.mappingfonts.model;

import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.Wordgroup;
import com.tiani.config.xml.minijaxb.AbstractIntermediateXMLElement;
import java.util.ArrayList;
import java.util.List;

public class Line
extends AbstractIntermediateXMLElement {
    private Font font;
    private final List<Wordgroup> wordgroups = new ArrayList<Wordgroup>();

    public Line() {
    }

    public Line(Line line) {
        if (line.font != null) {
            this.font = new Font(line.font);
        }
        for (Wordgroup wordgroup : line.wordgroups) {
            this.wordgroups.add(new Wordgroup(wordgroup));
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Wordgroup getWordgroup(int n) {
        return n >= this.wordgroups.size() || n < 0 ? null : this.wordgroups.get(n);
    }

    public Wordgroup[] getWordgroups() {
        return this.wordgroups.toArray(new Wordgroup[this.wordgroups.size()]);
    }

    public void setWordgroup(int n, Wordgroup wordgroup) {
        this.wordgroups.set(n, wordgroup);
    }

    public void addWordgroup(Wordgroup wordgroup) {
        this.wordgroups.add(wordgroup);
    }

    public void addWordgroup(int n, Wordgroup wordgroup) {
        this.wordgroups.add(n, wordgroup);
    }

    public void removeWordgroup(int n) {
        this.wordgroups.remove(n);
    }

    public void removeWordgroup(Wordgroup wordgroup) {
        this.wordgroups.remove((Object)wordgroup);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(50);
        for (Wordgroup wordgroup : this.wordgroups) {
            stringBuilder.append(wordgroup.toString());
        }
        return stringBuilder.toString();
    }

    public int wordgroupCount() {
        return this.wordgroups.size();
    }

    public int indexOf(Wordgroup wordgroup) {
        return this.wordgroups.indexOf((Object)wordgroup);
    }
}

