/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogram;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUT;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.ImageInformation2;
import java.util.Hashtable;
import java.util.Map;

public class MissingWindowCreator {
    private static ALogger log;
    private static double WIDENING_FACTOR;
    private static Map<String, WindowCreationFunction> configuration;

    static {
        String[] stringArray;
        log = ALogger.getLogger(MissingWindowCreator.class);
        WIDENING_FACTOR = 5.0;
        configuration = new Hashtable<String, WindowCreationFunction>();
        String string = Config.impaxee.jvision.missingWindowConfiguration.get();
        log.info("No Window Info Configuration:" + string);
        String[] stringArray2 = string.split("(;)|(=)");
        int n = 0;
        while (n < stringArray2.length) {
            if (stringArray2[n].length() != 0 && stringArray2[n + 1].length() != 0) {
                try {
                    configuration.put(stringArray2[n], WindowCreationFunction.valueOf(stringArray2[n + 1]));
                }
                catch (Exception exception) {
                    log.error("Could not parse configuration", (Throwable)exception);
                }
            }
            n += 2;
        }
        String[] stringArray3 = stringArray = new String[]{"1.2.840.10008.5.1.4.1.1.128", "1.2.840.10008.5.1.4.1.1.130"};
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray3[n3];
            if (!configuration.containsKey(string2)) {
                configuration.put(string2, WindowCreationFunction.MinMax);
            }
            ++n3;
        }
    }

    public static IVOILUT createMinMaxWindowLevel(IImageInformation iImageInformation, IHistogramProvider iHistogramProvider) {
        if (iImageInformation == null || iHistogramProvider == null || iHistogramProvider.getHistogram() == null) {
            return null;
        }
        return MissingWindowCreator.createVoiLutFromMinMax(iHistogramProvider.getHistogram(), iImageInformation.getModalityLUT());
    }

    public static IVOILUT createMinMaxWindowLevel(IImageInformation iImageInformation, IHistogram iHistogram) {
        if (iImageInformation == null || iHistogram == null) {
            return null;
        }
        return MissingWindowCreator.createVoiLutFromMinMax(iHistogram, iImageInformation.getModalityLUT());
    }

    static IVOILUT createMissingWindowLevels(ImageInformation2 imageInformation2, IHistogramProvider iHistogramProvider, WindowCreationFunction windowCreationFunction) {
        if (iHistogramProvider == null) {
            return null;
        }
        if (windowCreationFunction == null) {
            windowCreationFunction = configuration.get(imageInformation2.getSOPClassUID());
        }
        ModalityLUT modalityLUT = imageInformation2.getModalityLUT();
        if (windowCreationFunction == null) {
            return null;
        }
        IHistogram iHistogram = iHistogramProvider.getHistogram();
        if (iHistogram == null) {
            return null;
        }
        if (windowCreationFunction == WindowCreationFunction.StdDev) {
            IVOILUT iVOILUT = VOILUT.create((double)MissingWindowCreator.data2MLut(iHistogram.getMean(), modalityLUT), (double)MissingWindowCreator.data2MLutAbs(WIDENING_FACTOR * iHistogram.getStdDev(), modalityLUT));
            log.warn("No window information present,creating window based on StdDev:" + iHistogram.getStdDev() + "," + iHistogram.getMean());
            return iVOILUT;
        }
        if (windowCreationFunction == WindowCreationFunction.MinMax) {
            log.warn("No window information present,creating window based on MinMax:" + iHistogram.getMin() + "," + iHistogram.getMax());
            return MissingWindowCreator.createVoiLutFromMinMax(iHistogram, modalityLUT);
        }
        return null;
    }

    private static IVOILUT createVoiLutFromMinMax(IHistogram iHistogram, ModalityLUT modalityLUT) {
        return VOILUT.create((double)MissingWindowCreator.data2MLut((iHistogram.getMin() + iHistogram.getMax()) / 2.0, modalityLUT), (double)MissingWindowCreator.data2MLutAbs(iHistogram.getMax() - iHistogram.getMin(), modalityLUT));
    }

    private static double data2MLut(double d, ModalityLUT modalityLUT) {
        if (modalityLUT == null) {
            return d;
        }
        if (modalityLUT.getModalityLookupTable() != null) {
            return modalityLUT.getModalityLookupTable().getLookupTable().getLUT()[(short)d];
        }
        return d * modalityLUT.getRescaleSlope() + modalityLUT.getRescaleIntercept();
    }

    private static double data2MLutAbs(double d, ModalityLUT modalityLUT) {
        if (modalityLUT == null) {
            return d;
        }
        if (modalityLUT.getModalityLookupTable() != null) {
            return modalityLUT.getModalityLookupTable().getLookupTable().getLUT()[(short)d];
        }
        return d * modalityLUT.getRescaleSlope();
    }

    static enum WindowCreationFunction {
        MinMax,
        StdDev;

    }
}

