/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.impaxee.Messages;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageRegionProperties;

public class ImageRegionProperties
implements IImageRegionProperties {
    private final Histogram histogram;

    public ImageRegionProperties(Histogram histogram) {
        this.histogram = histogram;
    }

    @Override
    public boolean isValid() {
        return this.histogram.isMeanValid();
    }

    @Override
    public double getMean() {
        return this.histogram.getMean();
    }

    @Override
    public double getStdDev() {
        return this.histogram.getStdDev();
    }

    @Override
    public double getMin() {
        return this.histogram.getMin();
    }

    @Override
    public double getMax() {
        return this.histogram.getMax();
    }

    @Override
    public String getUnit() {
        return this.histogram.getUnit();
    }

    @Override
    public Histogram getHistogram() {
        return this.histogram;
    }

    @Override
    public String getStatistics() {
        String string = this.getUnit();
        boolean bl = string != null && string.length() > 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.histogram.formatValue(this.getMin()));
        stringBuilder.append(' ');
        stringBuilder.append(Messages.getString("VIEW_INFO_TO"));
        stringBuilder.append(' ');
        stringBuilder.append(this.histogram.formatValue(this.getMax()));
        if (bl) {
            stringBuilder.append(' ');
            stringBuilder.append(string);
        }
        stringBuilder.append(" (");
        stringBuilder.append(Messages.getString("VIEW_INFO_AVERAGE"));
        stringBuilder.append(' ');
        stringBuilder.append(this.histogram.formatValue(this.getMean()));
        if (bl) {
            stringBuilder.append(' ');
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getStatistics();
    }
}

