/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.data.shared.valuemapping.IdentityValueMapping;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageRegionProperties;

public class ImagePointProperties
implements IImageRegionProperties {
    private final IValueMapping mapping;
    private final double mean;

    public ImagePointProperties(int n, IValueMapping iValueMapping) {
        this.mapping = iValueMapping == null ? IdentityValueMapping.INSTANCE : iValueMapping;
        this.mean = this.mapping.applyMapping(n);
    }

    @Override
    public boolean isValid() {
        return !Double.isNaN(this.mean);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getStdDev() {
        return 0.0;
    }

    @Override
    public double getMin() {
        return this.mean;
    }

    @Override
    public double getMax() {
        return this.mean;
    }

    @Override
    public String getUnit() {
        return this.mapping.getUnit();
    }

    @Override
    public Histogram getHistogram() {
        return null;
    }

    @Override
    public String getStatistics() {
        if (Double.isNaN(this.mean)) {
            return "NA";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mapping.formatValue(this.mean));
        String string = this.getUnit();
        if (string != null && string.length() > 0) {
            stringBuilder.append(' ');
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getStatistics();
    }
}

