/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.data.shared.valuemapping.IdentityValueMapping;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogram;
import com.tiani.base.data.ClippingShape;
import java.awt.Rectangle;

public class Histogram
implements IHistogram {
    private int[] his;
    private boolean meanValid;
    private int mask;
    private boolean beExact = false;
    private double mean;
    private double std;
    private double min;
    private double max;
    private int minIndex;
    private int maxIndex;
    private int minCount;
    private int maxCount;
    private int pixCount;
    private int signOffset;
    private IValueMapping mapping = IdentityValueMapping.INSTANCE;

    public Histogram(short[] sArray, int n, int n2) {
        this(sArray, 0, sArray.length, n, false, null, n2);
    }

    public Histogram(short[] sArray, int n, IValueMapping iValueMapping, int n2) {
        this(sArray, 0, sArray.length, n, true, iValueMapping, n2);
    }

    public Histogram(short[] sArray, int n, int n2, int n3, int n4) {
        this(sArray, n, n2, n3, (Integer)null, (Integer)null, n4);
    }

    public Histogram(short[] sArray, int n, int n2, int n3, Integer n4, Integer n5, int n6) {
        this.signOffset = n6;
        this.mask = n3 - 1;
        this.his = DataCacheProviderFactory.getCache().allocAndClearInts((long)n3);
        int n7 = n;
        while (n7 < n + n2) {
            int n8 = sArray[n7] + n6 & this.mask;
            this.his[n8] = this.his[n8] + 1;
            ++n7;
        }
        this.calcValues(n2, n4, n5);
    }

    public Histogram(int[] nArray, int n, int n2, int n3) {
        this(nArray, n, n2, n3, null, null);
    }

    public Histogram(int[] nArray, int n, int n2, int n3, Integer n4, Integer n5) {
        int n6 = 8 * n3;
        this.his = DataCacheProviderFactory.getCache().allocAndClearInts(256L);
        int n7 = n;
        while (n7 < n + n2) {
            int n8 = nArray[n7] >> n6 & 0xFF;
            this.his[n8] = this.his[n8] + 1;
            ++n7;
        }
        this.calcValues(n2, n4, n5);
    }

    private Histogram(short[] sArray, int n, int n2, int n3, boolean bl, IValueMapping iValueMapping, int n4) {
        this(sArray, n, n2, n3, bl, iValueMapping, null, null, n4);
    }

    private Histogram(short[] sArray, int n, int n2, int n3, boolean bl, IValueMapping iValueMapping, Integer n4, Integer n5, int n6) {
        this.signOffset = n6;
        this.beExact = bl;
        this.mask = n3 - 1;
        this.his = DataCacheProviderFactory.getCache().allocAndClearInts((long)n3);
        int n7 = n;
        while (n7 < n + n2) {
            int n8 = sArray[n7] + n6 & this.mask;
            this.his[n8] = this.his[n8] + 1;
            ++n7;
        }
        this.setValueMapping(iValueMapping);
        this.calcValues(n2, n4, n5);
    }

    public Histogram(byte[] byArray, int n, int n2, int n3) {
        this(byArray, n, n2, null, null, n3);
    }

    public Histogram(byte[] byArray, int n, int n2, Integer n3, Integer n4, int n5) {
        this.signOffset = n5;
        this.his = DataCacheProviderFactory.getCache().allocAndClearInts((long)n2);
        int n6 = 0;
        while (n6 < n) {
            int n7 = n5 + byArray[n6] & 0xFF;
            this.his[n7] = this.his[n7] + 1;
            ++n6;
        }
        this.calcValues(n, n3, n4);
    }

    public Histogram(byte[] byArray, int n, int n2, int n3, ClippingShape clippingShape, IValueMapping iValueMapping, Integer n4, Integer n5, int n6) {
        this(byArray, 0, n, n2, n3, clippingShape, iValueMapping, n4, n5, n6);
    }

    public Histogram(byte[] byArray, int n, int n2, int n3, int n4, ClippingShape clippingShape, IValueMapping iValueMapping, Integer n5, Integer n6, int n7) {
        this.signOffset = n7;
        this.beExact = true;
        this.his = DataCacheProviderFactory.getCache().allocAndClearInts((long)n2);
        Rectangle rectangle = new Rectangle();
        if (clippingShape != null) {
            rectangle = clippingShape.getImageSpaceBoundingBox();
        }
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        int n10 = n8 + rectangle.width;
        int n11 = n9 + rectangle.height;
        n8 = Histogram.limitValue(n8, 0, n3 - 1);
        n10 = Histogram.limitValue(n10, 0, n3 - 1);
        n9 = Histogram.limitValue(n9, 0, n4 - 1);
        n11 = Histogram.limitValue(n11, 0, n4 - 1);
        int n12 = 0;
        if (clippingShape != null) {
            if (clippingShape.useBBoxOnly()) {
                int n13 = n9;
                while (n13 <= n11) {
                    int n14 = n + n13 * n3;
                    int n15 = n8;
                    while (n15 <= n10) {
                        int n16 = byArray[n14 + n15] + n7 & 0xFF;
                        this.his[n16] = this.his[n16] + 1;
                        ++n12;
                        ++n15;
                    }
                    ++n13;
                }
            } else {
                double[] dArray = clippingShape.pixelToDef(n8, n9);
                double[] dArray2 = clippingShape.pixelToDef(n8 + rectangle.width, n9);
                double[] dArray3 = clippingShape.pixelToDef(n8, n9 + rectangle.height);
                int n17 = (int)((dArray2[0] - dArray[0]) / (double)rectangle.width * 65536.0);
                int n18 = (int)((dArray2[1] - dArray[1]) / (double)rectangle.width * 65536.0);
                int n19 = (int)((dArray3[0] - dArray[0]) / (double)rectangle.height * 65536.0);
                int n20 = (int)((dArray3[1] - dArray[1]) / (double)rectangle.height * 65536.0);
                int n21 = (int)(dArray[0] * 65536.0);
                int n22 = (int)(dArray[1] * 65536.0);
                int n23 = n9;
                while (n23 <= n11) {
                    int n24 = n21 + (n23 - n9) * n19;
                    int n25 = n22 + (n23 - n9) * n20;
                    int n26 = n + n23 * n3;
                    int n27 = n8;
                    while (n27 <= n10) {
                        if (clippingShape.isInside(n24 >> 16, n25 >> 16) && n26 + n27 >= 0 && n26 + n27 < byArray.length) {
                            int n28 = byArray[n26 + n27] + n7 & 0xFF;
                            this.his[n28] = this.his[n28] + 1;
                            ++n12;
                        }
                        n24 += n17;
                        n25 += n18;
                        ++n27;
                    }
                    ++n23;
                }
            }
        }
        this.setValueMapping(iValueMapping);
        this.calcValues(n12, n5, n6);
    }

    public Histogram(short[] sArray, int n, int n2, int n3, ClippingShape clippingShape, IValueMapping iValueMapping, Integer n4, Integer n5, int n6) {
        this(sArray, 0, n, n2, n3, clippingShape, iValueMapping, n4, n5, n6);
    }

    public Histogram(short[] sArray, int n, int n2, int n3, ClippingShape clippingShape, IValueMapping iValueMapping, int n4) {
        this(sArray, 0, n, n2, n3, clippingShape, iValueMapping, null, null, n4);
    }

    public Histogram(short[] sArray, int n, int n2, int n3, int n4, ClippingShape clippingShape, IValueMapping iValueMapping, Integer n5, Integer n6, int n7) {
        this.signOffset = n7;
        this.beExact = true;
        this.his = DataCacheProviderFactory.getCache().allocAndClearInts((long)n2);
        Rectangle rectangle = new Rectangle();
        if (clippingShape != null) {
            rectangle = clippingShape.getImageSpaceBoundingBox();
        }
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        int n10 = n8 + rectangle.width;
        int n11 = n9 + rectangle.height;
        int n12 = 0;
        n8 = Histogram.limitValue(n8, 0, n3 - 1);
        n10 = Histogram.limitValue(n10, 0, n3 - 1);
        n9 = Histogram.limitValue(n9, 0, n4 - 1);
        n11 = Histogram.limitValue(n11, 0, n4 - 1);
        if (clippingShape != null) {
            if (clippingShape.useBBoxOnly()) {
                int n13 = n9;
                while (n13 <= n11) {
                    int n14 = n + n13 * n3;
                    int n15 = n8;
                    while (n15 <= n10) {
                        int n16 = n14 + n15;
                        if (n16 >= 0 && n16 < sArray.length && (sArray[n16] + n7 & 0xFFFF) > 0 && (sArray[n16] + n7 & 0xFFFF) < this.his.length) {
                            int n17 = sArray[n14 + n15] + n7 & 0xFFFF;
                            this.his[n17] = this.his[n17] + 1;
                            ++n12;
                        }
                        ++n15;
                    }
                    ++n13;
                }
            } else {
                double[] dArray = clippingShape.pixelToDef(n8, n9);
                double[] dArray2 = clippingShape.pixelToDef(n8 + rectangle.width, n9);
                double[] dArray3 = clippingShape.pixelToDef(n8, n9 + rectangle.height);
                int n18 = (int)((dArray2[0] - dArray[0]) / (double)rectangle.width * 65536.0);
                int n19 = (int)((dArray2[1] - dArray[1]) / (double)rectangle.width * 65536.0);
                int n20 = (int)((dArray3[0] - dArray[0]) / (double)rectangle.height * 65536.0);
                int n21 = (int)((dArray3[1] - dArray[1]) / (double)rectangle.height * 65536.0);
                int n22 = (int)(dArray[0] * 65536.0);
                int n23 = (int)(dArray[1] * 65536.0);
                int n24 = n9;
                while (n24 <= n11) {
                    int n25 = n22 + (n24 - n9) * n20;
                    int n26 = n23 + (n24 - n9) * n21;
                    int n27 = n + n24 * n3;
                    int n28 = n8;
                    while (n28 <= n10) {
                        if (clippingShape.isInside(n25 >> 16, n26 >> 16) && n24 * n3 + n28 < sArray.length && n24 * n3 + n28 > 0) {
                            int n29 = sArray[n27 + n28] + n7 & 0xFFFF;
                            this.his[n29] = this.his[n29] + 1;
                            ++n12;
                        }
                        n25 += n18;
                        n26 += n19;
                        ++n28;
                    }
                    ++n24;
                }
            }
        }
        this.setValueMapping(iValueMapping);
        this.calcValues(n12, n5, n6);
    }

    private Histogram(byte[] byArray, int n, int n2, int n3, ClippingShape clippingShape, IValueMapping iValueMapping, int n4) {
        int n5;
        Rectangle rectangle = clippingShape.getImageSpaceBoundingBox();
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = n6 + rectangle.width;
        int n9 = n7 + rectangle.height;
        n6 = Histogram.limitValue(n6, 0, n2 - 1);
        n8 = Histogram.limitValue(n8, 0, n2 - 1);
        n7 = Histogram.limitValue(n7, 0, n3 - 1);
        n9 = Histogram.limitValue(n9, 0, n3 - 1);
        this.min = 2.147483647E9;
        this.max = -2.147483648E9;
        double d = 0.0;
        double d2 = 0.0;
        int n10 = 0;
        if (clippingShape.useBBoxOnly()) {
            int n11 = n7;
            while (n11 <= n9) {
                n5 = n + n11 * n2 * (n4 >> 3);
                int n12 = n6;
                while (n12 <= n8) {
                    long l = n4 == 16 ? (long)Histogram.get2ByteValue(byArray, n5 + (n12 << 1)) : Histogram.get4ByteValue(byArray, n5 + (n12 << 2));
                    if ((double)l < this.min) {
                        this.min = l;
                    }
                    if ((double)l > this.max) {
                        this.max = l;
                    }
                    d += (double)l;
                    d2 += (double)(l * l);
                    ++n10;
                    ++n12;
                }
                ++n11;
            }
        } else {
            int n13 = n7;
            while (n13 <= n9) {
                n5 = n + n13 * n2 * (n4 >> 3);
                int n14 = n6;
                while (n14 <= n8) {
                    if (clippingShape.isInside(n14, n13)) {
                        long l = n4 == 16 ? (long)Histogram.get2ByteValue(byArray, n5 + (n14 << 1)) : Histogram.get4ByteValue(byArray, n5 + (n14 << 2));
                        if ((double)l < this.min) {
                            this.min = l;
                        }
                        if ((double)l > this.max) {
                            this.max = l;
                        }
                        d += (double)l;
                        d2 += (double)(l * l);
                        ++n10;
                    }
                    ++n14;
                }
                ++n13;
            }
        }
        this.setValueMapping(iValueMapping);
        this.min = iValueMapping.applyMapping((int)this.min);
        this.max = iValueMapping.applyMapping((int)this.max);
        if (n10 > 0) {
            double d3 = d / (double)n10;
            this.mean = iValueMapping.applyMapping((int)d3);
            this.std = iValueMapping.applyMapping((int)Math.sqrt(d2 / (double)n10 - d3 * d3));
        }
        this.meanValid = n10 > 0;
        this.pixCount = n10;
    }

    public static Histogram create32BitHistogramFromByteArray(byte[] byArray, int n, int n2, int n3, ClippingShape clippingShape, IValueMapping iValueMapping) {
        return new Histogram(byArray, n, n2, n3, clippingShape, iValueMapping, 32);
    }

    public static Histogram create16BitHistogramFromByteArray(byte[] byArray, int n, int n2, int n3, ClippingShape clippingShape, IValueMapping iValueMapping) {
        return new Histogram(byArray, n, n2, n3, clippingShape, iValueMapping, 16);
    }

    private static long get4ByteValue(byte[] byArray, int n) {
        return (long)((byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16)) + (((long)byArray[n + 3] & 0xFFL) << 24);
    }

    private static int get2ByteValue(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
    }

    private static int limitValue(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public boolean isMeanValid() {
        return this.meanValid;
    }

    private void calcStats(Integer n, Integer n2) {
        double d;
        int n3;
        int n4 = 0;
        this.mean = 0.0;
        double d2 = 0.0;
        int n5 = n != null ? n + this.signOffset : 0;
        if (n5 < this.minIndex) {
            n5 = this.minIndex;
        }
        if ((n3 = n2 != null ? n2 + this.signOffset : this.his.length - 1) > this.maxIndex) {
            n3 = this.maxIndex;
        }
        int n6 = n5;
        while (n6 <= n3) {
            if (this.his[n6] > 0) {
                d = this.mapping.applyMapping(n6 - this.signOffset);
                this.mean += d * (double)this.his[n6];
                n4 += this.his[n6];
            }
            ++n6;
        }
        this.meanValid = n4 > 0 && !Double.isNaN(this.mean);
        this.mean /= (double)n4;
        if (this.meanValid) {
            n6 = n5;
            while (n6 <= n3) {
                if (this.his[n6] > 0) {
                    d = this.mapping.applyMapping(n6 - this.signOffset) - this.mean;
                    d2 += d * d * (double)this.his[n6];
                }
                ++n6;
            }
            this.std = Math.sqrt(d2 / (double)n4);
        }
    }

    private void calcValues(int n, Integer n2, Integer n3) {
        this.pixCount = n;
        this.minCount = Integer.MAX_VALUE;
        this.maxCount = Integer.MIN_VALUE;
        int n4 = 0;
        while (n4 < this.his.length) {
            if (this.his[n4] > this.maxCount) {
                this.maxCount = this.his[n4];
            }
            if (this.his[n4] < this.minCount) {
                this.minCount = this.his[n4];
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.his.length && this.his[n4] == 0) {
            ++n4;
        }
        if (n4 == this.his.length) {
            n4 = 0;
        }
        this.minIndex = n4;
        n4 = this.his.length - 1;
        while (n4 >= 0 && this.his[n4] == 0) {
            --n4;
        }
        this.maxIndex = n4;
        this.calcStats(n2, n3);
        if (!this.beExact) {
            int n5 = this.maxIndex;
            int n6 = this.minIndex;
            if (this.maxIndex - this.minIndex > 20) {
                this.minIndex = 1;
                int n7 = 0;
                int n8 = (int)(4.0 * Math.sqrt(n));
                while (this.minIndex < this.his.length && n7 < n8) {
                    n7 += this.his[this.minIndex++];
                }
            }
            this.maxIndex = this.his.length - 1;
            while (this.maxIndex >= 0 && this.his[this.maxIndex] == 0) {
                --this.maxIndex;
            }
            if (this.minIndex > this.maxIndex) {
                this.maxIndex = n5;
                this.minIndex = n6;
            }
        }
        this.calcMinMax();
    }

    private void calcMinMax() {
        if (this.mapping.isMonotonic()) {
            this.min = this.mapping.applyMapping(this.getRawMin());
            this.max = this.mapping.applyMapping(this.getRawMax());
        } else {
            this.calcMinMaxNonMonotonic();
        }
    }

    private void calcMinMaxNonMonotonic() {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < this.his.length) {
            if (this.his[n] > 0) {
                double d = this.mapping.applyMapping(n - this.signOffset);
                if (d < this.min) {
                    this.min = d;
                }
                if (d > this.max) {
                    this.max = d;
                }
            }
            ++n;
        }
    }

    public int[] getRawHistogram() {
        return this.his;
    }

    private void setValueMapping(IValueMapping iValueMapping) {
        this.mapping = iValueMapping == null ? IdentityValueMapping.INSTANCE : iValueMapping;
    }

    public String getUnit() {
        return this.mapping.getUnit();
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return this.std;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getRawMin() {
        return this.minIndex - this.signOffset;
    }

    public int getRawMax() {
        return this.maxIndex - this.signOffset;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getSignOffset() {
        return this.signOffset;
    }

    public int getMinValidIndex() {
        int n = 0;
        if (this.mapping.getFirstValueMapped() != null) {
            n = Math.max(this.mapping.getFirstValueMapped() + this.signOffset, n);
        }
        return n;
    }

    public int getMaxValidIndex() {
        int n = this.his.length - 1;
        if (this.mapping.getFirstValueMapped() != null) {
            n = Math.min(this.mapping.getLastValueMapped() + this.signOffset, n);
        }
        return n;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getPixelCount() {
        return this.pixCount;
    }

    public boolean hasMonotonicValueMapping() {
        return this.mapping.isMonotonic();
    }

    public double applyMapping(int n) {
        return this.mapping.applyMapping(n);
    }

    public String formatValue(double d) {
        return this.mapping.formatValue(d);
    }
}

