/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.windowingtree;

import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.windowingtree.WindowingTree;
import java.text.Collator;
import java.util.Collections;
import javax.swing.tree.DefaultMutableTreeNode;

public class WindowingTreeNode
extends DefaultMutableTreeNode
implements Comparable<WindowingTreeNode> {
    private String ID;
    private String configID = null;
    private IConfigurationProvider configProvider = null;
    private Collator collator = Collator.getInstance();

    public String getConfigID() {
        return this.configID;
    }

    public IConfigurationProvider getConfigProvider() {
        return this.configProvider;
    }

    public WindowingTreeNode(Object object) {
        super(object);
        this.collator.setStrength(0);
    }

    public WindowingTreeNode(Object object, IConfigurationProvider iConfigurationProvider, String string) {
        this(object);
        this.configProvider = iConfigurationProvider;
        this.configID = string;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.ID = string;
    }

    @Override
    public void setUserObject(Object object) {
        String string;
        if (this.configProvider == null) {
            super.setUserObject(object);
            return;
        }
        if (this.ID.equals("center") || this.ID.equals("width")) {
            int n;
            try {
                n = Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            Long l = this.configProvider.getLong(this.ID);
            if (l == null || l != (long)n) {
                this.configProvider.setLong(this.ID, (long)n);
                this.ensureItemOnOneLevel();
            }
        } else if (this.ID.equals(WindowingTree.LEVEL1)) {
            String string2 = this.configProvider.getString("name");
            if (!string2.equals(object.toString())) {
                this.configProvider.setString("name", object.toString());
                this.ensureItemOnOneLevel();
            }
        } else if (this.ID.equals(WindowingTree.LEVEL0) && !(string = this.configProvider.getString("category")).equals(object.toString())) {
            this.configProvider.setString("category", object.toString());
        }
        super.setUserObject(object);
    }

    private void ensureItemOnOneLevel() {
        Long l = this.configProvider.getLong("center");
        Long l2 = this.configProvider.getLong("width");
        String string = this.configProvider.getString("name");
        this.configProvider.setLong("center", l + 1L);
        this.configProvider.setLong("width", l2 + 1L);
        this.configProvider.setString("name", String.valueOf(string) + "temp");
        this.configProvider.setLong("center", l.longValue());
        this.configProvider.setLong("width", l2.longValue());
        this.configProvider.setString("name", string);
    }

    @Override
    public int compareTo(WindowingTreeNode windowingTreeNode) {
        if (this.userObject != null) {
            if (windowingTreeNode.userObject != null) {
                return this.collator.compare(this.userObject.toString(), windowingTreeNode.userObject.toString());
            }
            return 1;
        }
        if (windowingTreeNode.userObject == null) {
            return 0;
        }
        return -1;
    }

    public void sortChilds() {
        Collections.sort(this.children);
    }

    public int getIndexFor(WindowingTreeNode windowingTreeNode) {
        int n = Collections.binarySearch(this.children, windowingTreeNode);
        return n < 0 ? -n - 1 : n;
    }
}

