/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vistoolbar;

import com.agfa.pacs.impaxee.actions.PActionPersistenceRef;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VisDisplayToolbarAction
extends PActionPersistenceRef {
    public static final String POSITION_XML_ATTR_NAME = "pos";
    private int pos;
    private Collection<IVisDisplayToolbarActionListener> listeners;

    public VisDisplayToolbarAction(String string, int n) {
        super(string);
        this.pos = n;
    }

    public static VisDisplayToolbarAction create(Node node) throws Exception {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("id").getNodeValue();
        int n = Integer.valueOf(namedNodeMap.getNamedItem(POSITION_XML_ATTR_NAME).getNodeValue());
        return new VisDisplayToolbarAction(string, n);
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int n) {
        if (this.pos != n) {
            this.pos = n;
            this.fireActionChanged();
        }
    }

    public VisDisplayToolbarAction copy() {
        return new VisDisplayToolbarAction(this.getActionId(), this.getPosition());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof VisDisplayToolbarAction) {
            VisDisplayToolbarAction visDisplayToolbarAction = (VisDisplayToolbarAction)object;
            return this.getActionId().equals(visDisplayToolbarAction.getActionId());
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        String string = this.getActionId();
        return string.hashCode();
    }

    public void addActionListener(IVisDisplayToolbarActionListener iVisDisplayToolbarActionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IVisDisplayToolbarActionListener>();
        }
        if (!this.listeners.contains(iVisDisplayToolbarActionListener)) {
            this.listeners.add(iVisDisplayToolbarActionListener);
        }
    }

    public void removeActionListener(IVisDisplayToolbarActionListener iVisDisplayToolbarActionListener) {
        if (this.listeners != null) {
            this.listeners.remove(iVisDisplayToolbarActionListener);
        }
    }

    @Override
    protected String attrsToXML() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(super.attrsToXML());
        stringBuilder.append(" ");
        stringBuilder.append(POSITION_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Integer.toString(this.pos));
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private void fireActionChanged() {
        if (this.listeners != null) {
            for (IVisDisplayToolbarActionListener iVisDisplayToolbarActionListener : this.listeners) {
                iVisDisplayToolbarActionListener.actionChanged(this);
            }
        }
    }

    public static /* bridge */ /* synthetic */ PActionPersistenceRef create(Node node) throws Exception {
        return VisDisplayToolbarAction.create(node);
    }

    public static interface IVisDisplayToolbarActionListener {
        public void actionChanged(VisDisplayToolbarAction var1);
    }
}

