/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vistoolbar;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.SeparatorPAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.DropDownButton;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolbarAction;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolbarLayout;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolbarModel;
import com.agfa.pacs.listtext.swingx.controls.DropDownBox;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.controls.hotregion.HotRegionListener;
import com.tiani.gui.util.event.DefaultMouseMoveListener;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayScrollBar;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;

public class VisDisplayToolBar
extends JPanel
implements HotRegionListener {
    private static final ALogger log = ALogger.getLogger(VisDisplayToolBar.class);
    private boolean hidden = VisDisplayToolBar.isHideToolbar();
    private Timer hideTimeout;
    private DefaultMouseMoveListener hideMouseIndicator;
    private static int ITEM_GAP;
    private VisDisplayToolbarModel model;
    private VisDisplay2 display;
    private Map<VisDisplayToolbarAction, IActionUI> actionMap;

    static {
        VisDisplayScrollBar.getConfiguredAlignment();
        ITEM_GAP = GUI.getScaledDiagnosticInt((int)4);
    }

    public VisDisplayToolBar(VisDisplay2 visDisplay2) {
        super(new VisDisplayToolbarLayout(VisDisplayToolbarLayout.Orientation.Vertical, ITEM_GAP));
        this.display = visDisplay2;
        this.actionMap = new HashMap<VisDisplayToolbarAction, IActionUI>();
        this.model = VisDisplayToolbarModel.getRuntimeInstance();
        this.model.addModelListener(new VisDisplayToolbarModelListener());
        this.buildToolbar();
    }

    @Override
    public VisDisplayToolbarLayout getLayout() {
        return (VisDisplayToolbarLayout)super.getLayout();
    }

    @Override
    public final void setLayout(LayoutManager layoutManager) {
        if (!(layoutManager instanceof VisDisplayToolbarLayout)) {
            throw new UnsupportedOperationException("Custom layout is not supported!");
        }
        super.setLayout(layoutManager);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public static VisDisplayToolbarLayout.Orientation getConfiguredOrientation() {
        return VisDisplayToolBar.getConfiguredAlignment() == 1 || VisDisplayToolBar.getConfiguredAlignment() == 0 ? VisDisplayToolbarLayout.Orientation.Vertical : VisDisplayToolbarLayout.Orientation.Horizontal;
    }

    public static int getConfiguredAlignment() {
        return VisDisplayScrollBar.getConfiguredAlignment(true, Config.impaxee.jvision.DISPLAY.ToolBarAlign.get());
    }

    public static boolean isHideToolbar() {
        return Config.impaxee.jvision.DISPLAY.HideToolbar.get() || !Config.impaxee.jvision.DISPLAY.UseToolbar.get();
    }

    public void setHidden(boolean bl) {
        if (!Config.impaxee.jvision.DISPLAY.UseToolbar.get()) {
            return;
        }
        if (bl != this.hidden) {
            this.hidden = bl;
            JComponent jComponent = (JComponent)this.getParent();
            if (jComponent != null) {
                jComponent.revalidate();
                jComponent.repaint();
            }
            if (!bl) {
                this.startHideTimeout();
            }
        }
    }

    private void buildToolbar() {
        this.releaseToolbar();
        this.getLayout().setOrientation(VisDisplayToolBar.getConfiguredOrientation());
        this.setBorder(BorderFactory.createEmptyBorder(GUI.getScaledDiagnosticInt((int)2), GUI.getScaledDiagnosticInt((int)2), GUI.getScaledDiagnosticInt((int)2), GUI.getScaledDiagnosticInt((int)2)));
        if (VisDisplayToolBar.isHideToolbar()) {
            return;
        }
        SortedMap<VisDisplayToolbarAction, PAction> sortedMap = this.model.getActions(this.display);
        for (Map.Entry entry : sortedMap.entrySet()) {
            try {
                IActionUI exception = ActionUIFactory.createUI((PAction)entry.getValue(), ActionUIScope.DisplayToolbar);
                if (exception == null) continue;
                this.actionMap.put((VisDisplayToolbarAction)entry.getKey(), exception);
                JComponent jComponent = exception.getComponent();
                this.prepareComponent(jComponent);
                this.add(jComponent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                log.warn("Creating action-ui for action '" + ((VisDisplayToolbarAction)entry.getKey()).getActionId() + "' failed! Skipped...");
            }
        }
        boolean bl = false;
        SortedMap<VisDisplayToolbarAction, PAction> sortedMap2 = this.model.getDynamicActions(this.display);
        for (Map.Entry entry : sortedMap2.entrySet()) {
            try {
                IActionUI iActionUI = ActionUIFactory.createUI((PAction)entry.getValue(), ActionUIScope.DisplayToolbar);
                if (iActionUI == null) continue;
                if (!bl) {
                    this.add(ActionUIFactory.createUI(new SeparatorPAction()).getComponent());
                    bl = true;
                }
                this.actionMap.put((VisDisplayToolbarAction)entry.getKey(), iActionUI);
                JComponent jComponent = iActionUI.getComponent();
                this.prepareComponent(jComponent);
                this.add(jComponent);
            }
            catch (Exception exception) {
                log.warn("Creating action-ui for action '" + ((VisDisplayToolbarAction)entry.getKey()).getActionId() + "' failed! Skipped...");
            }
        }
    }

    private void releaseToolbar() {
        for (IActionUI iActionUI : this.actionMap.values()) {
            iActionUI.release();
        }
        this.actionMap.clear();
        this.removeAll();
    }

    private void actionAdded(VisDisplayToolbarAction visDisplayToolbarAction) {
        try {
            IActionUI iActionUI;
            PAction pAction = this.model.resolveAction(visDisplayToolbarAction, this.display);
            if (pAction != null && (iActionUI = ActionUIFactory.createUI(pAction, ActionUIScope.DisplayToolbar)) != null) {
                this.actionMap.put(visDisplayToolbarAction, iActionUI);
                JComponent jComponent = iActionUI.getComponent();
                this.prepareComponent(jComponent);
                this.add(jComponent);
                this.revalidate();
                this.repaint();
            }
        }
        catch (Exception exception) {
            log.warn("Creating action-ui for action '" + visDisplayToolbarAction.getActionId() + "' failed! Skipped...");
        }
    }

    private void actionRemoved(VisDisplayToolbarAction visDisplayToolbarAction) {
        IActionUI iActionUI = this.actionMap.get(visDisplayToolbarAction);
        if (iActionUI != null) {
            int n = Arrays.asList(this.getComponents()).indexOf(iActionUI.getComponent());
            Component component = this.getComponent(n + 1);
            this.remove(iActionUI.getComponent());
            this.remove(component);
            iActionUI.release();
            this.revalidate();
            this.repaint();
        }
    }

    private void allActionsRemoved() {
        for (IActionUI iActionUI : this.actionMap.values()) {
            iActionUI.release();
        }
        this.actionMap.clear();
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    private void prepareComponent(Component component) {
        if (component instanceof DropDownBox) {
            if (VisDisplayToolBar.getConfiguredAlignment() == 2) {
                ((DropDownBox)component).setOrientation(DropDownBox.Orientation.bottom);
            } else if (VisDisplayToolBar.getConfiguredAlignment() == 3) {
                ((DropDownBox)component).setOrientation(DropDownBox.Orientation.top);
            } else if (VisDisplayToolBar.getConfiguredAlignment() == 0) {
                ((DropDownBox)component).setOrientation(DropDownBox.Orientation.right);
            } else if (VisDisplayToolBar.getConfiguredAlignment() == 1) {
                ((DropDownBox)component).setOrientation(DropDownBox.Orientation.left);
            }
        } else if (component instanceof DropDownButton) {
            if (VisDisplayToolBar.getConfiguredAlignment() == 2) {
                ((DropDownButton)component).setOrientation(DropDownButton.Orientation.bottom);
            } else if (VisDisplayToolBar.getConfiguredAlignment() == 3) {
                ((DropDownButton)component).setOrientation(DropDownButton.Orientation.top);
            } else if (VisDisplayToolBar.getConfiguredAlignment() == 0) {
                ((DropDownButton)component).setOrientation(DropDownButton.Orientation.right);
            } else if (VisDisplayToolBar.getConfiguredAlignment() == 1) {
                ((DropDownButton)component).setOrientation(DropDownButton.Orientation.left);
            }
        }
    }

    private void startHideTimeout() {
        if (this.hideTimeout != null) {
            this.hideTimeout.stop();
            this.hideMouseIndicator.deinstallFrom(this);
        }
        this.hideMouseIndicator = new DefaultMouseMoveListener();
        this.hideTimeout = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!VisDisplayToolBar.this.hideMouseIndicator.isMouseOver() && actionEvent.getWhen() - VisDisplayToolBar.this.hideMouseIndicator.getLastMoveTime() > 1200L) {
                    VisDisplayToolBar.this.hideTimeout.stop();
                    VisDisplayToolBar.this.hideMouseIndicator.deinstallFrom(VisDisplayToolBar.this);
                    if (!VisDisplayToolBar.this.isHidden()) {
                        VisDisplayToolBar.this.setHidden(true);
                    }
                }
            }
        });
        this.hideMouseIndicator.installOn(this);
        this.hideTimeout.start();
    }

    @Override
    public void hotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent) {
    }

    @Override
    public void hotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
    }

    @Override
    public void hotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
    }

    private class VisDisplayToolbarModelListener
    implements VisDisplayToolbarModel.IVisDisplayToolbarModelListener {
        private VisDisplayToolbarModelListener() {
        }

        @Override
        public void modelChanged() {
            VisDisplayToolBar.this.buildToolbar();
            VisDisplayToolBar.this.revalidate();
            VisDisplayToolBar.this.repaint();
        }

        @Override
        public void actionAdded(VisDisplayToolbarAction visDisplayToolbarAction) {
            VisDisplayToolBar.this.actionAdded(visDisplayToolbarAction);
        }

        @Override
        public void actionRemoved(VisDisplayToolbarAction visDisplayToolbarAction) {
            VisDisplayToolBar.this.actionRemoved(visDisplayToolbarAction);
        }

        @Override
        public void allActionsRemoved() {
            VisDisplayToolBar.this.allActionsRemoved();
        }
    }
}

