/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vismenu;

import com.agfa.pacs.impaxee.actions.PActionPersistenceRef;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisMenuAction
extends PActionPersistenceRef {
    public static final String POSITION_XML_ATTR_NAME = "pos";
    private int pos;
    private Collection<VisMenuActionListener> listeners;

    public VisMenuAction(String string, int n) {
        super(string);
        this.pos = n;
    }

    public static VisMenuAction create(Node node) throws Exception {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("id").getNodeValue();
        int n = Integer.valueOf(namedNodeMap.getNamedItem(POSITION_XML_ATTR_NAME).getNodeValue());
        if ("VIS_MENU_SUBMENU".equals(string)) {
            String string2 = namedNodeMap.getNamedItem("caption").getNodeValue();
            ArrayList<VisMenuAction> arrayList = null;
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            if (n2 > 0) {
                arrayList = new ArrayList<VisMenuAction>(n2);
                int n3 = 0;
                while (n3 < n2) {
                    VisMenuAction visMenuAction = VisMenuAction.create(nodeList.item(n3));
                    if (visMenuAction != null) {
                        arrayList.add(visMenuAction);
                    }
                    ++n3;
                }
                Collections.sort(arrayList, new VisMenuActionComparator());
            }
            return new VisMenuSubmenuAction(n, string2, arrayList);
        }
        return new VisMenuAction(string, n);
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int n) {
        if (this.pos != n) {
            this.pos = n;
            this.fireActionChanged();
        }
    }

    public VisMenuAction copy() {
        return new VisMenuAction(this.getActionId(), this.getPosition());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof VisMenuAction) {
            VisMenuAction visMenuAction = (VisMenuAction)object;
            if ("SEPARATOR".equals(visMenuAction.getActionId()) && "SEPARATOR".equals(this.getActionId())) {
                return false;
            }
            return this.getActionId().equals(visMenuAction.getActionId());
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        String string = this.getActionId();
        return string.hashCode();
    }

    public void addActionListener(VisMenuActionListener visMenuActionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<VisMenuActionListener>();
        }
        if (!this.listeners.contains(visMenuActionListener)) {
            this.listeners.add(visMenuActionListener);
        }
    }

    public void removeActionListener(VisMenuActionListener visMenuActionListener) {
        if (this.listeners != null) {
            this.listeners.remove(visMenuActionListener);
        }
    }

    @Override
    protected String attrsToXML() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(super.attrsToXML());
        stringBuilder.append(" ");
        stringBuilder.append(POSITION_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(Integer.toString(this.pos));
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    protected void fireActionChanged() {
        if (this.listeners != null) {
            for (VisMenuActionListener visMenuActionListener : this.listeners) {
                visMenuActionListener.actionChanged(this);
            }
        }
    }

    public static /* bridge */ /* synthetic */ PActionPersistenceRef create(Node node) throws Exception {
        return VisMenuAction.create(node);
    }

    public static class VisMenuActionComparator
    implements Comparator<VisMenuAction> {
        @Override
        public int compare(VisMenuAction visMenuAction, VisMenuAction visMenuAction2) {
            return Integer.valueOf(visMenuAction.getPosition()).compareTo(visMenuAction2.getPosition());
        }
    }

    public static interface VisMenuActionListener {
        public void actionChanged(VisMenuAction var1);
    }
}

