/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vismenu;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionPersistenceContainer;
import com.agfa.pacs.impaxee.actions.PActionPersistenceRef;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.impl.SeparatorPAction;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.vismenu.VisMenuAction;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuAction;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.menu.LegacyMenuConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Document;

public abstract class AbstractVisMenuModel {
    private static final ALogger log = ALogger.getLogger(AbstractVisMenuModel.class);
    private PActionPersistenceContainer<VisMenuAction> actionContainer;

    protected AbstractVisMenuModel(IConfigurationProvider iConfigurationProvider) {
        this.actionContainer = this.createActionContainer(iConfigurationProvider);
    }

    public boolean equalsRuntimeInstance() {
        return this.actionContainer.getConfigurationProvider() == ConfigurationProviderFactory.getConfig();
    }

    public void addAction(VisMenuAction visMenuAction) {
        if ("SEPARATOR".equals(visMenuAction.getActionId()) || !this.actionContainer.containsActionRef(visMenuAction)) {
            this.actionContainer.addActionRef(visMenuAction);
        }
    }

    public void removeAction(VisMenuAction visMenuAction) {
        if (this.actionContainer.containsActionRef(visMenuAction)) {
            this.actionContainer.removeActionRef(visMenuAction);
        }
    }

    public void removeAllActions() {
        this.actionContainer.removeAll();
    }

    public SortedMap<VisMenuAction, PAction> getDynamicActions(Vis2 vis2) {
        View view;
        TreeMap<VisMenuAction, PAction> treeMap = new TreeMap<VisMenuAction, PAction>(new VisMenuAction.VisMenuActionComparator());
        if (vis2 != null && (view = vis2.getView()) != null) {
            ArrayList<PAction> arrayList = new ArrayList<PAction>();
            arrayList.addAll(view.getDisplayData().getDisplayPlugin().getPluginContextMenuTextActions(view));
            PresentationObject presentationObject = view.getSelectedPO();
            if (presentationObject != null) {
                arrayList.addAll(LegacyMenuConverter.generateActions(presentationObject.getMenuEntries()));
            }
            arrayList.addAll(view.getMenuEntries());
            arrayList.addAll(LegacyMenuConverter.generateActions(view.getLegacyMenuEntries()));
            if (!arrayList.isEmpty()) {
                int n = 0;
                treeMap.put(new VisMenuAction("SEPARATOR", n++), new SeparatorPAction());
                for (PAction pAction : arrayList) {
                    treeMap.put(new VisMenuAction(pAction.getID(), n++), pAction);
                }
                treeMap.put(new VisMenuAction("SEPARATOR", n++), new SeparatorPAction());
            }
        }
        return treeMap;
    }

    public SortedMap<VisMenuAction, PAction> getDynamicDisplayPluginActions(Vis2 vis2) {
        View view;
        TreeMap<VisMenuAction, PAction> treeMap = new TreeMap<VisMenuAction, PAction>(new VisMenuAction.VisMenuActionComparator());
        if (vis2 != null && (view = vis2.getView()) != null) {
            ArrayList<PAction> arrayList = new ArrayList<PAction>();
            VisDisplayData visDisplayData = view.getDisplayData();
            IDisplayPlugin iDisplayPlugin = visDisplayData.getDisplayPlugin();
            arrayList.addAll(iDisplayPlugin.getPluginContextMenuButtonActions(view));
            if (!arrayList.isEmpty()) {
                int n = 0;
                for (PAction pAction : arrayList) {
                    treeMap.put(new VisMenuAction(pAction.getID(), n++), pAction);
                }
                treeMap.put(new VisMenuAction("SEPARATOR", n++), new SeparatorPAction());
            }
        }
        return treeMap;
    }

    public Map<VisMenuAction, PAction> getActions(Vis2 vis2) {
        return this.getConfiguredActions(vis2);
    }

    public void resetToDefault() throws Exception {
        this.actionContainer.resetToDefault();
        this.save();
    }

    public void resetToRole() throws Exception {
        this.actionContainer.resetToRole();
        this.save();
    }

    public void init(AbstractVisMenuModel abstractVisMenuModel) {
        this.actionContainer.init(abstractVisMenuModel.actionContainer);
    }

    public void init(Document document) {
        this.actionContainer.init(document);
    }

    public String toXML() {
        return this.actionContainer.toXML();
    }

    public void save() {
        try {
            this.actionContainer.save();
        }
        catch (Exception exception) {
            log.error("Writing vis-menu action references to config failed!", (Throwable)exception);
        }
    }

    public void addModelListener(IModelListener iModelListener) {
        this.actionContainer.addContainerListener(new ModelListenerWrapper(iModelListener));
    }

    public void removeModelListener(IModelListener iModelListener) {
        Collection<PActionPersistenceContainer.IActionContainerListener> collection = this.actionContainer.getContainerListeners();
        if (collection != null) {
            for (PActionPersistenceContainer.IActionContainerListener iActionContainerListener : collection) {
                if (!(iActionContainerListener instanceof ModelListenerWrapper) || ((ModelListenerWrapper)iActionContainerListener).l != iModelListener) continue;
                this.actionContainer.removeContainerListener(iActionContainerListener);
                break;
            }
        }
    }

    public static PAction resolveAction(VisMenuAction visMenuAction, Vis2 vis2) throws ActionNotFoundException {
        VisDisplay2 visDisplay2;
        VisDisplay2 visDisplay22 = visDisplay2 = vis2 != null ? vis2.getVisDisplay() : null;
        if (visMenuAction instanceof VisMenuSubmenuAction) {
            return ((VisMenuSubmenuAction)visMenuAction).createAction(vis2);
        }
        String string = visMenuAction.getActionId();
        if (visDisplay2 != null && string.equals("SYNCHRONIZE@" + PDataScope.CurrentDisplay.name())) {
            string = string.substring(0, string.indexOf(64));
        }
        if (visDisplay2 != null && string.equals("SUV@" + PDataScope.CurrentDisplay.name())) {
            string = string.substring(0, string.indexOf(64));
        }
        return PActionRegistry.getAction(string, visDisplay2);
    }

    protected abstract PActionPersistenceContainer<VisMenuAction> createActionContainer(IConfigurationProvider var1);

    private Map<VisMenuAction, PAction> getConfiguredActions(Vis2 vis2) {
        Collection<VisMenuAction> collection;
        LinkedHashMap<VisMenuAction, PAction> linkedHashMap = new LinkedHashMap<VisMenuAction, PAction>();
        if (this.actionContainer.getActionRefCount() > 0 && (collection = this.actionContainer.getActionRefs()) != null) {
            ArrayList<VisMenuAction> arrayList = new ArrayList<VisMenuAction>(collection);
            Collections.sort(arrayList, new VisMenuAction.VisMenuActionComparator());
            for (VisMenuAction visMenuAction : arrayList) {
                try {
                    PAction pAction = AbstractVisMenuModel.resolveAction(visMenuAction, vis2);
                    if (pAction == null) continue;
                    linkedHashMap.put(visMenuAction, pAction);
                }
                catch (ActionNotFoundException actionNotFoundException) {
                    log.warn("Resolving vis-menu action '" + visMenuAction.getActionId() + " failed! Skipped");
                }
            }
        }
        return linkedHashMap;
    }

    public static interface IModelListener {
        public void menuActionAdded(AbstractVisMenuModel var1, VisMenuAction var2);

        public void menuActionRemoved(AbstractVisMenuModel var1, VisMenuAction var2);

        public void menuActionMoved(AbstractVisMenuModel var1, VisMenuAction var2);

        public void modelChanged(AbstractVisMenuModel var1);
    }

    private class ModelListenerWrapper
    implements PActionPersistenceContainer.IActionContainerListener {
        private IModelListener l;

        public ModelListenerWrapper(IModelListener iModelListener) {
            this.l = iModelListener;
        }

        @Override
        public void actionRefAdded(PActionPersistenceContainer<?> pActionPersistenceContainer, PActionPersistenceRef pActionPersistenceRef) {
            this.l.menuActionAdded(AbstractVisMenuModel.this, (VisMenuAction)pActionPersistenceRef);
        }

        @Override
        public void actionRefRemoved(PActionPersistenceContainer<?> pActionPersistenceContainer, PActionPersistenceRef pActionPersistenceRef) {
            this.l.menuActionRemoved(AbstractVisMenuModel.this, (VisMenuAction)pActionPersistenceRef);
        }

        @Override
        public void actionRefMoved(PActionPersistenceContainer<?> pActionPersistenceContainer, PActionPersistenceRef pActionPersistenceRef) {
            this.l.menuActionMoved(AbstractVisMenuModel.this, (VisMenuAction)pActionPersistenceRef);
        }

        @Override
        public void containerChanged(PActionPersistenceContainer<?> pActionPersistenceContainer) {
            this.l.modelChanged(AbstractVisMenuModel.this);
        }
    }
}

