/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.valuemapping.suv;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.valuemapping.DecayCorrectionMethod;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.data.shared.valuemapping.ISUVStudyData;
import com.agfa.pacs.data.shared.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.data.shared.valuemapping.SUVData;
import com.agfa.pacs.data.shared.valuemapping.SUVMapping;
import com.agfa.pacs.data.shared.valuemapping.SUVStudyData;
import com.agfa.pacs.data.shared.valuemapping.StandardizedUptakeValueMethod;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.ImageInformation2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.util.Date;
import java.util.Locale;
import org.dcm4che3.data.Attributes;

public class SUVUtil {
    private SUVUtil() {
    }

    public static boolean isSUVPermitted() {
        return !Product.isCDViewer();
    }

    static boolean isSUVSupported(VisDisplay2 visDisplay2) {
        return visDisplay2 != null && visDisplay2.getData() != null && visDisplay2.getData().getDisplaySet() != null && SUVUtil.isSUVSupported(visDisplay2.getData().getDisplaySet().getOneObject());
    }

    public static boolean isSUVSupported(IFrameObjectData iFrameObjectData) {
        return iFrameObjectData != null && SUVUtil.isSUVSupported(iFrameObjectData.getImageInformation());
    }

    static boolean isSUVSupported(IImageInformation iImageInformation) {
        return iImageInformation != null && SUVUtil.isSUVSupported(iImageInformation.getDataset(), iImageInformation.getImageClass());
    }

    static boolean isSUVSupported(Attributes attributes) {
        return attributes != null && SUVUtil.isSUVSupported(attributes, ImageInformation2.getImageClass(attributes.getString(524310)));
    }

    private static boolean isSUVSupported(Attributes attributes, IImageInformation.ImageClass imageClass) {
        return imageClass == IImageInformation.ImageClass.PT && attributes.getDate(2251945843097650L) != null && SUVUtil.isBQML(attributes.getString(5509121)) && DecayCorrectionMethod.isSupported((Attributes)attributes);
    }

    private static boolean isBQML(String string) {
        if (string != null) {
            return "BQML".equals(string.toUpperCase(Locale.ENGLISH));
        }
        return false;
    }

    static boolean isSUVActive(VisDisplay2 visDisplay2) {
        for (VisData visData : visDisplay2.getVisDatas()) {
            if (!SUVUtil.isSUVActive(visData.getView())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSUVActive(View view) {
        IValueMapping iValueMapping;
        return view != null && view.getRenderer() != null && (iValueMapping = view.getRenderer().getImageState().getCurrentValueMapping()) instanceof SUVMapping;
    }

    public static ISUVData getSUVDataForFrame(VisDisplay2 visDisplay2, IFrameObjectData iFrameObjectData) {
        IDisplaySet iDisplaySet = null;
        if (visDisplay2 != null && visDisplay2.hasData()) {
            iDisplaySet = visDisplay2.getData().getDisplaySet();
        }
        ISUVData iSUVData = null;
        if (iDisplaySet != null) {
            iSUVData = iDisplaySet.getSUVData();
        }
        if (iSUVData == null) {
            IStudyData iStudyData = iFrameObjectData.getParent().getParent();
            ISUVStudyData iSUVStudyData = iStudyData.getSUVData();
            if (iSUVStudyData == null) {
                iSUVStudyData = new SUVStudyData(iFrameObjectData.getDicomObject(), SUVUtil.getDefaultMethod());
                iStudyData.setSUVData(iSUVStudyData);
            }
            iSUVData = new SUVData(iFrameObjectData.getDicomObject(), SUVUtil.getBaseDateForSUVCalculation(iDisplaySet), iSUVStudyData);
            if (iDisplaySet != null) {
                iDisplaySet.setSUVData(iSUVData);
            }
        }
        return iSUVData;
    }

    private static Date getBaseDateForSUVCalculation(IDisplaySet iDisplaySet) {
        if (iDisplaySet == null) {
            return null;
        }
        Date date = iDisplaySet.getOneObject().getDicomObject().getDate(2251941548130353L);
        Date date2 = iDisplaySet.getOneObject().getImageInformation().getAcquisitionDateTime();
        if (date == null || date2 == null || date.after(date2)) {
            return null;
        }
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
            Date date3 = iFrameObjectData.getImageInformation().getAcquisitionDateTime();
            if (date3 == null || !date3.equals(date2)) {
                return null;
            }
            ++n2;
        }
        return date;
    }

    static IStandardizedUptakeValueMethod getDefaultMethod() {
        try {
            return StandardizedUptakeValueMethod.valueOf((String)Config.impaxee.jvision.ValueMapping.SUV.Method.get());
        }
        catch (Exception exception) {
            return StandardizedUptakeValueMethod.BodyWeight;
        }
    }
}

