/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.valuemapping.suv;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.data.shared.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.pacs.data.shared.valuemapping.StandardizedUptakeValueMethod;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVMappingFactory;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.List;

class SUVActivatorDataAction
extends AbstractPDataAction {
    public static final String ID_PREFIX = "SUV_";
    private final StandardizedUptakeValueMethod method;

    SUVActivatorDataAction(StandardizedUptakeValueMethod standardizedUptakeValueMethod) {
        this.method = standardizedUptakeValueMethod;
    }

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new SUVActivatorAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    @Override
    public String getID() {
        return ID_PREFIX + this.method.name();
    }

    private class SUVActivatorAction
    extends AbstractPDataAction.AbstractInnerPAction {
        SUVActivatorAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope, pDataProvider);
        }

        @Override
        public boolean isAvailable() {
            return Product.isRunningAutoTests() && SUVUtil.isSUVPermitted();
        }

        @Override
        public String getCaption() {
            return SUVActivatorDataAction.this.method.getName();
        }

        @Override
        public String getGroupName() {
            return "INTERNAL";
        }

        @Override
        public String getToolTipText() {
            return SUVActivatorDataAction.this.method.toString();
        }

        private VisDisplay2 getVisDisplay() {
            List<VisDisplay2> list = this.scope != null ? SUVActivatorDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
            if (list != null && list.size() == 1) {
                return list.get(0);
            }
            return null;
        }

        @Override
        public boolean perform(Component component) {
            VisDisplay2 visDisplay2 = this.getVisDisplay();
            if (!SUVUtil.isSUVSupported(visDisplay2)) {
                return false;
            }
            this.notifyActionPerformed();
            CursorUtil.setWaitCursor((Component)visDisplay2);
            visDisplay2.getVis(visDisplay2.getNavigPos()).getView().getFrameData().addListener(new SUVActivatorListener(visDisplay2));
            return true;
        }
    }

    private class SUVActivatorListener
    implements IFrameListener {
        private final VisDisplay2 vd;

        SUVActivatorListener(VisDisplay2 visDisplay2) {
            this.vd = visDisplay2;
        }

        @Override
        public boolean frameAvailable(IFrameObjectData iFrameObjectData, String string) {
            if (CursorUtil.isWaitCursor((Component)this.vd)) {
                CursorUtil.resetWaitCursor((Component)this.vd);
            }
            ISUVData iSUVData = SUVUtil.getSUVDataForFrame(this.vd, iFrameObjectData);
            iSUVData.setMethod((IStandardizedUptakeValueMethod)SUVActivatorDataAction.this.method);
            if (!iSUVData.needsData()) {
                TEvent tEvent = new TEvent(120);
                TEventDispatch.sendEventToVis(this.vd, tEvent, new SUVMappingFactory(iSUVData), TEventDispatch.ALL_VISUALS);
            }
            if (this.vd.hasAction("SUV")) {
                this.vd.getAction("SUV").forcedSelectionChanged();
            }
            return false;
        }

        @Override
        public void notifyHasError(String string) {
            if (CursorUtil.isWaitCursor((Component)this.vd)) {
                CursorUtil.resetWaitCursor((Component)this.vd);
            }
        }
    }
}

