/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toptoolbar;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.toolbar.ToolbarModel;
import com.agfa.pacs.impaxee.toptoolbar.TopToolbarPaneModel;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TopToolbarConfigModel {
    private static final ALogger log = ALogger.getLogger(TopToolbarConfigModel.class);
    private TopToolbarPaneModel topToolbarModel;
    private List<ToolbarModel> models;
    private boolean modified;

    private TopToolbarConfigModel(TopToolbarPaneModel topToolbarPaneModel) {
        this.topToolbarModel = topToolbarPaneModel;
        this.models = new ArrayList<ToolbarModel>();
        this.update();
        this.modified = false;
    }

    public static TopToolbarConfigModel createRuntimeInstance() {
        return new TopToolbarConfigModel(TopToolbarPaneModel.getRuntimeInstance());
    }

    public static TopToolbarConfigModel createInstance(TopToolbarPaneModel topToolbarPaneModel) {
        return new TopToolbarConfigModel(topToolbarPaneModel);
    }

    public boolean modified() {
        if (!this.modified) {
            for (ToolbarModel toolbarModel : this.models) {
                if (!toolbarModel.isModified()) continue;
                return true;
            }
        }
        return this.modified;
    }

    public TopToolbarPaneModel getTopToolbarModel() {
        return this.topToolbarModel;
    }

    public Collection<PAction> getAvailableActions() {
        List<PAction> list = PActionRegistry.getAllUserConfigurableToolbarActions(PDataProvider.ProviderType.Screen);
        Collections.sort(list, new Comparator<PAction>(){

            @Override
            public int compare(PAction pAction, PAction pAction2) {
                String string = ActionUIUtilities.getActionConfigText(pAction);
                String string2 = ActionUIUtilities.getActionConfigText(pAction2);
                if (string != null && string2 != null) {
                    return string.compareTo(string2);
                }
                if (string != null) {
                    return -1;
                }
                if (string2 != null) {
                    return 1;
                }
                return -1;
            }
        });
        return list;
    }

    public Collection<ToolbarModel> getToolbarModels() {
        return Collections.unmodifiableCollection(this.models);
    }

    public void addToolbar(ToolbarModel toolbarModel) throws DuplicateToolbarException, IllegalArgumentException {
        if (toolbarModel == null) {
            log.warn("Adding top-toolbar failed: Toolbar must not be null!");
            throw new IllegalArgumentException();
        }
        if (this.models.contains(toolbarModel)) {
            log.warn("Adding top-toolbar failed: There is already a top-toolbar with that name '" + toolbarModel + "'");
            throw new DuplicateToolbarException();
        }
        this.models.add(toolbarModel);
        this.modified = true;
    }

    public void removeToolbar(ToolbarModel toolbarModel) throws IllegalArgumentException, NoSuchToolbarException {
        if (toolbarModel == null) {
            log.warn("Removing top-toolbar failed: Toolbar must not be null!");
            throw new IllegalArgumentException();
        }
        if (!this.models.contains(toolbarModel)) {
            log.warn("Removing top-toolbar failed: There is no toolbar with that name '" + toolbarModel + "'");
            throw new NoSuchToolbarException();
        }
        this.models.remove(toolbarModel);
        this.modified = true;
    }

    public void update() {
        this.models.clear();
        Collection<ToolbarModel> collection = this.topToolbarModel.getToolbars();
        if (collection != null) {
            for (ToolbarModel toolbarModel : collection) {
                ToolbarModel toolbarModel2 = toolbarModel.copy();
                this.models.add(toolbarModel2);
            }
        }
        this.modified = true;
    }

    public void save() throws Exception {
        if (this.modified()) {
            ArrayList<ToolbarModel> arrayList = new ArrayList<ToolbarModel>(this.topToolbarModel.getToolbars());
            for (ToolbarModel toolbarModel : arrayList) {
                if (this.getModelForName(this.models, toolbarModel.getName()) != null) continue;
                this.topToolbarModel.removeToolbar(toolbarModel);
            }
            for (ToolbarModel toolbarModel : this.models) {
                ToolbarModel toolbarModel2 = this.getModelForName(this.topToolbarModel.getToolbars(), toolbarModel.getName());
                if (toolbarModel2 == null) {
                    this.topToolbarModel.addToolbar(toolbarModel);
                    continue;
                }
                if (!toolbarModel.isModified()) continue;
                toolbarModel2.setActions(toolbarModel.getActions());
                toolbarModel2.getLayoutConstraint().update(toolbarModel.getLayoutConstraint());
            }
            this.topToolbarModel.save(false);
            this.modified = false;
        }
    }

    private ToolbarModel getModelForName(Collection<ToolbarModel> collection, String string) {
        for (ToolbarModel toolbarModel : collection) {
            if (!string.equals(toolbarModel.getName())) continue;
            return toolbarModel;
        }
        return null;
    }

    public static class DuplicateToolbarException
    extends Exception {
    }

    public static class NoSuchToolbarException
    extends Exception {
    }
}

