/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.model;

import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresetsType;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import java.util.SortedMap;
import java.util.TreeMap;

public class ManualSplitAndSortPresets {
    private static final ALogger log = ALogger.getLogger(ManualSplitAndSortPresets.class);
    private ManualSplitAndSortPresetsType type;
    private final SortedMap<String, String> presets = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public ManualSplitAndSortPresets(ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
        this.type = manualSplitAndSortPresetsType;
        this.init();
    }

    public final void init() {
        this.presets.clear();
        IConfigurationList iConfigurationList = this.type.getConfigList();
        if (iConfigurationList != null) {
            for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
                try {
                    String string = iConfigurationProvider.getString("name");
                    String string2 = iConfigurationProvider.getString("value");
                    this.presets.put(string, string2);
                }
                catch (Exception exception) {
                    log.error("Could not read preset", (Throwable)exception);
                }
            }
        }
    }

    public String[] getNames() {
        return this.presets.keySet().toArray(new String[this.presets.size()]);
    }

    public SplitAndSort loadPreset(String string) {
        String string2 = (String)this.presets.get(string);
        if (string2 != null) {
            try {
                return (SplitAndSort)((Object)new XmlLoader().load(string2, SplitAndSort.class));
            }
            catch (MarshalException marshalException) {
                log.error("Could not read preset", (Throwable)marshalException);
            }
        }
        return null;
    }
}

