/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.twolists.AbstractListItemEditor;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.sortorders.model.xml.CustomSortOrder;
import com.agfa.pacs.impaxee.sortorders.registry.CustomSortOrderRegistry;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EditSortCriterionPanel
extends AbstractListItemEditor<SortField>
implements IConfigurationChangeListener {
    private JComboBox comboBoxCustomSortOrder;
    private JComboBox comboBoxSortDirection;
    private SortField sortField;
    private JPanel panel;
    private boolean blockDataChangedEvents = false;

    public EditSortCriterionPanel(IComponentFactory iComponentFactory) {
        this.init(iComponentFactory);
    }

    private void init(IComponentFactory iComponentFactory) {
        this.comboBoxCustomSortOrder = iComponentFactory.createComboBox();
        this.comboBoxSortDirection = iComponentFactory.createComboBox();
        this.panel = new JPanel(new GridBagLayout());
        this.panel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("EditSortCriterionPanel.SortDirection")) + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.comboBoxSortDirection, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("EditSortCriterionPanel.CustomSortOrder")) + ":"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.comboBoxCustomSortOrder, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.comboBoxSortDirection.addItem(Messages.getString("EditSortCriterionPanel.Ascending"));
        this.comboBoxSortDirection.addItem(Messages.getString("EditSortCriterionPanel.Descending"));
        this.comboBoxSortDirection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (EditSortCriterionPanel.this.sortField != null) {
                    if (EditSortCriterionPanel.this.comboBoxSortDirection.getSelectedIndex() == 0) {
                        EditSortCriterionPanel.this.sortField.setIsDescending(false);
                    } else if (EditSortCriterionPanel.this.comboBoxSortDirection.getSelectedIndex() == 1) {
                        EditSortCriterionPanel.this.sortField.setIsDescending(true);
                    }
                    EditSortCriterionPanel.this.fireDataChanged();
                }
            }
        });
        this.comboBoxCustomSortOrder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (EditSortCriterionPanel.this.sortField != null) {
                    if (EditSortCriterionPanel.this.comboBoxCustomSortOrder.getSelectedIndex() == 0) {
                        EditSortCriterionPanel.this.sortField.setCustomOrderName("");
                    } else if (EditSortCriterionPanel.this.comboBoxCustomSortOrder.getSelectedIndex() > 0) {
                        EditSortCriterionPanel.this.sortField.setCustomOrderName(EditSortCriterionPanel.this.comboBoxCustomSortOrder.getSelectedItem().toString());
                    }
                    EditSortCriterionPanel.this.fireDataChanged();
                }
            }
        });
        this.comboBoxCustomSortOrder.setEnabled(false);
        this.comboBoxSortDirection.setEnabled(false);
    }

    public void setItem(SortField sortField) {
        this.blockDataChangedEvents = true;
        this.sortField = sortField;
        if (sortField == null) {
            this.comboBoxCustomSortOrder.setSelectedIndex(-1);
            this.comboBoxSortDirection.setSelectedIndex(-1);
            this.comboBoxCustomSortOrder.setEnabled(false);
            this.comboBoxSortDirection.setEnabled(false);
        } else {
            this.comboBoxCustomSortOrder.setEnabled(true);
            this.comboBoxSortDirection.setEnabled(true);
            String string = sortField.getCustomOrderName();
            this.fillComboBoxCustomSortOrder();
            if (sortField.getIsDescending().booleanValue()) {
                this.comboBoxSortDirection.setSelectedIndex(1);
            } else {
                this.comboBoxSortDirection.setSelectedIndex(0);
            }
            if (string == null || string.length() == 0) {
                this.comboBoxCustomSortOrder.setSelectedIndex(0);
            } else {
                this.comboBoxCustomSortOrder.setSelectedItem(string);
                if (this.comboBoxCustomSortOrder.getSelectedIndex() < 0) {
                    this.comboBoxCustomSortOrder.setSelectedIndex(0);
                }
            }
        }
        this.blockDataChangedEvents = false;
    }

    private void fillComboBoxCustomSortOrder() {
        if (this.sortField == null) {
            return;
        }
        this.comboBoxCustomSortOrder.removeAllItems();
        this.comboBoxCustomSortOrder.addItem("-- " + Messages.getString("EditSortCriterionPanel.Default") + " --");
        Integer n = this.sortField.getTag();
        if (n == null) {
            return;
        }
        for (CustomSortOrder customSortOrder : CustomSortOrderRegistry.getInstance().getAll()) {
            if (customSortOrder.getName() == null || customSortOrder.getName().length() <= 0) continue;
            if (customSortOrder.getReferenceTag() != null) {
                if (!customSortOrder.getReferenceTag().equals(n)) continue;
                this.comboBoxCustomSortOrder.addItem(customSortOrder.getName());
                continue;
            }
            this.comboBoxCustomSortOrder.addItem(customSortOrder.getName());
        }
    }

    public void configurationChanged(String string) {
        Object object = this.comboBoxCustomSortOrder.getSelectedItem();
        this.fillComboBoxCustomSortOrder();
        this.comboBoxCustomSortOrder.setSelectedItem(object);
        if (this.comboBoxCustomSortOrder.getSelectedIndex() < 0 && this.comboBoxCustomSortOrder.getItemCount() > 0) {
            this.comboBoxCustomSortOrder.setSelectedIndex(0);
        }
    }

    public JComponent getEditorComponent() {
        return this.panel;
    }

    public SortField getItem() {
        return this.sortField;
    }

    protected void fireDataChanged() {
        if (!this.blockDataChangedEvents) {
            super.fireDataChanged();
        }
    }
}

