/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.gui;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.splitsort.gui.SplitAndSortPanel;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresets;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresetsType;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlSaver;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.util.message.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AdvancedManualSplitAndSortDialog
extends StandardDialog {
    private static final ALogger log = ALogger.getLogger(AdvancedManualSplitAndSortDialog.class);
    private SplitAndSort returnValue = null;
    private SplitAndSortPanel splitAndSortPanel;
    private final ManualSplitAndSortPresetsType presetsType;
    private final ManualSplitAndSortPresets presets;
    private JComboBox<String> presetCmb;

    public AdvancedManualSplitAndSortDialog(Frame frame, ISplitAndSortRuntime iSplitAndSortRuntime, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
        super(frame, manualSplitAndSortPresetsType.getTitle());
        this.presetsType = manualSplitAndSortPresetsType;
        this.presets = new ManualSplitAndSortPresets(manualSplitAndSortPresetsType);
        SplitAndSort splitAndSort = null;
        JPanel jPanel = ComponentFactory.instance.createPanel(new BorderLayout());
        this.splitAndSortPanel = new SplitAndSortPanel(splitAndSort, iSplitAndSortRuntime, manualSplitAndSortPresetsType);
        jPanel.add((Component)this.splitAndSortPanel, "Center");
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new FlowLayout(1));
        jPanel2.add(ComponentFactory.instance.createLabel(String.valueOf(Messages.getString("AdvancedManualSplitAndSortDialog.Presets")) + ":"));
        this.presetCmb = ComponentFactory.instance.createMultiMonitorComboBox(this.presets.getNames());
        jPanel2.add(this.presetCmb);
        jPanel2.add(ComponentFactory.instance.createButton(new LoadPreset()));
        jPanel2.add(ComponentFactory.instance.createButton(new DeletePreset()));
        jPanel2.add(ComponentFactory.instance.createButton(new SavePreset()));
        jPanel.add((Component)jPanel2, "South");
        this.initSetting();
        this.addOKButton(new OKAction());
        this.addCancelButton(new CancelAction());
        this.setContent(jPanel);
        this.setSize(GUI.getScaledDiagnosticDimension((int)900, (int)900));
        this.initLocation();
    }

    private void initSetting() {
        this.presets.init();
        String[] stringArray = this.presets.getNames();
        this.presetCmb.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    public SplitAndSort getReturn() {
        return this.returnValue;
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedManualSplitAndSortDialog.this.returnValue = null;
            AdvancedManualSplitAndSortDialog.this.setVisible(false);
        }
    }

    private class DeletePreset
    extends AbstractAction {
        public DeletePreset() {
            super(Messages.getString("AdvancedManualSplitAndSortDialog.DeletePreset"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IConfigurationList iConfigurationList = AdvancedManualSplitAndSortDialog.this.presetsType.getConfigList();
            String string = (String)AdvancedManualSplitAndSortDialog.this.presetCmb.getSelectedItem();
            for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
                if (!((IConfigurationProvider)entry.getValue()).getString("name").equals(string)) continue;
                iConfigurationList.remove((String)entry.getKey());
                break;
            }
            AdvancedManualSplitAndSortDialog.this.presetsType.updateConfig();
            AdvancedManualSplitAndSortDialog.this.initSetting();
        }
    }

    private class LoadPreset
    extends AbstractAction {
        public LoadPreset() {
            super(Messages.getString("AdvancedManualSplitAndSortDialog.LoadPreset"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SplitAndSort splitAndSort = AdvancedManualSplitAndSortDialog.this.presets.loadPreset((String)AdvancedManualSplitAndSortDialog.this.presetCmb.getSelectedItem());
            if (splitAndSort != null) {
                AdvancedManualSplitAndSortDialog.this.splitAndSortPanel.init(splitAndSort, null);
            }
        }
    }

    private class OKAction
    extends AbstractAction {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedManualSplitAndSortDialog.this.returnValue = AdvancedManualSplitAndSortDialog.this.splitAndSortPanel.getDecomposition();
            if (AdvancedManualSplitAndSortDialog.this.returnValue == null) {
                Message.error(Messages.getString("ERROR"), (Object)Messages.getString("MANUAL_SORT_SPLIT_DIALOG_INSUFFICIENT_INFORMATION"));
                return;
            }
            AdvancedManualSplitAndSortDialog.this.setVisible(false);
        }
    }

    private class SavePreset
    extends AbstractAction {
        public SavePreset() {
            super(Messages.getString("AdvancedManualSplitAndSortDialog.SavePreset"));
        }

        private void saveSetting(IConfigurationProvider iConfigurationProvider, String string) {
            StringWriter stringWriter = new StringWriter(500);
            try {
                new XmlSaver((XmlSaveable)AdvancedManualSplitAndSortDialog.this.splitAndSortPanel.getDecomposition()).save((Writer)stringWriter);
                iConfigurationProvider.setText("value", stringWriter.toString());
                if (string != null) {
                    iConfigurationProvider.setString("name", string);
                }
            }
            catch (Exception exception) {
                log.error("Could not store presets", (Throwable)exception);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(AdvancedManualSplitAndSortDialog.this.presetCmb, String.valueOf(Messages.getString("AdvancedManualSplitAndSortDialog.EnterSavingPresetName")) + ":", Messages.getString("AdvancedManualSplitAndSortDialog.SavingPresetTitle"), 1);
            if (string == null) {
                return;
            }
            IConfigurationList iConfigurationList = AdvancedManualSplitAndSortDialog.this.presetsType.getConfigList();
            boolean bl = false;
            for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
                if (!iConfigurationProvider.getString("name").equals(string)) continue;
                bl = true;
                this.saveSetting(iConfigurationProvider, null);
                break;
            }
            if (!bl) {
                IConfigurationProvider iConfigurationProvider;
                iConfigurationProvider = iConfigurationList.appendItem();
                this.saveSetting(iConfigurationProvider, string);
            }
            AdvancedManualSplitAndSortDialog.this.presetsType.updateConfig();
            AdvancedManualSplitAndSortDialog.this.initSetting();
        }
    }
}

