/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.SeparatorPAction;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.splitsort.ManualSortSplitProcessor;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresets;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresetsType;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class ManualSplitAndSortActionProvider
implements PActionProvider {
    @Override
    public List<PAction> getActions() {
        return Collections.singletonList(new ManualSplitSortDisplaySets(new LastModifiedDisplaySetProvider(), ManualSplitAndSortPresetsType.IMAGE_SORT));
    }

    public static List<PAction> getSeriesPaletteActions(IDisplaySet iDisplaySet) {
        FixedDisplaySetProvider fixedDisplaySetProvider = new FixedDisplaySetProvider(iDisplaySet);
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        ManualSplitAndSortPresetsType[] manualSplitAndSortPresetsTypeArray = ManualSplitAndSortPresetsType.values();
        int n = manualSplitAndSortPresetsTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManualSplitAndSortPresetsType manualSplitAndSortPresetsType = manualSplitAndSortPresetsTypeArray[n2];
            arrayList.add(new ManualSplitSortDisplaySets(fixedDisplaySetProvider, manualSplitAndSortPresetsType));
            ++n2;
        }
        arrayList.add(new RevertDisplaySet(fixedDisplaySetProvider));
        return arrayList;
    }

    private static abstract class AbstractManualSplitSortAction
    extends AbstractPAction {
        final IDisplaySetProvider provider;

        AbstractManualSplitSortAction(IDisplaySetProvider iDisplaySetProvider) {
            this.provider = iDisplaySetProvider;
        }

        @Override
        public String getGroupName() {
            return HANGINGS_GROUP;
        }

        @Override
        public String getToolTipText() {
            return this.getCaption();
        }

        @Override
        public boolean isAvailable() {
            if (!Permissions.getInstance().isAllowed("ImageArea/AllowedToDoManualSplitAndSort")) {
                return false;
            }
            return !(DataSelectionManager.getInstance().getActiveHanging() instanceof Session);
        }
    }

    private static abstract class AbstractManualSplitSortDialogAction
    extends AbstractTypedManualSplitSortAction
    implements Runnable {
        AbstractManualSplitSortDialogAction(IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider, manualSplitAndSortPresetsType);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed(this.type.getActionID());
            EventQueue.invokeLater(this);
            return true;
        }

        @Override
        public void run() {
            IDisplaySet iDisplaySet = this.provider.getDisplaySet();
            if (iDisplaySet != null) {
                ManualSortSplitProcessor.getInstance().splitAndSortDialog(iDisplaySet, this.type);
            }
        }
    }

    private static abstract class AbstractTypedManualSplitSortAction
    extends AbstractManualSplitSortAction {
        final ManualSplitAndSortPresetsType type;

        AbstractTypedManualSplitSortAction(IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider);
            this.type = manualSplitAndSortPresetsType;
        }
    }

    private static class FixedDisplaySetProvider
    implements IDisplaySetProvider {
        private final IDisplaySet displaySet;

        FixedDisplaySetProvider(IDisplaySet iDisplaySet) {
            this.displaySet = iDisplaySet;
        }

        @Override
        public IDisplaySet getDisplaySet() {
            return this.displaySet;
        }
    }

    private static interface IDisplaySetProvider {
        public IDisplaySet getDisplaySet();
    }

    private static class LastModifiedDisplaySetProvider
    implements IDisplaySetProvider {
        private LastModifiedDisplaySetProvider() {
        }

        @Override
        public IDisplaySet getDisplaySet() {
            VisDisplay2 visDisplay2 = AbstractPDataAction.getCurrentDisplay();
            if (visDisplay2 == null || !visDisplay2.hasData()) {
                return null;
            }
            return visDisplay2.getData().getDisplaySet();
        }
    }

    private static class ManualSplitSortDialogAction
    extends AbstractManualSplitSortDialogAction {
        ManualSplitSortDialogAction(IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider, manualSplitAndSortPresetsType);
        }

        @Override
        public String getID() {
            return String.valueOf(this.type.getActionID()) + "_DIALOG";
        }

        @Override
        public String getCaption() {
            return Messages.getString("ManualSplitSortDialogAction.Caption");
        }
    }

    private static class ManualSplitSortDisplaySets
    extends AbstractManualSplitSortDialogAction {
        private final PAction[] subactions = this.createManualSplitAndSortPresetActions();

        ManualSplitSortDisplaySets(IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider, manualSplitAndSortPresetsType);
        }

        private PAction[] createManualSplitAndSortPresetActions() {
            ManualSplitAndSortPresets manualSplitAndSortPresets = new ManualSplitAndSortPresets(this.type);
            String[] stringArray = manualSplitAndSortPresets.getNames();
            if (stringArray.length == 0) {
                return null;
            }
            PAction[] pActionArray = new PAction[stringArray.length + 2];
            int n = 0;
            while (n < stringArray.length) {
                pActionArray[n] = new ManualSplitSortPresetAction(this.provider, this.type, stringArray[n]);
                ++n;
            }
            pActionArray[pActionArray.length - 2] = new SeparatorPAction();
            pActionArray[pActionArray.length - 1] = new ManualSplitSortDialogAction(this.provider, this.type);
            return pActionArray;
        }

        @Override
        public String getID() {
            return this.type.getActionID();
        }

        @Override
        public String getCaption() {
            return this.type.getCaption();
        }

        @Override
        public PAction.ActionType getActionType() {
            if (this.subactions == null) {
                return PAction.ActionType.None;
            }
            return PAction.ActionType.Submenu;
        }

        @Override
        public PAction[] getSubactions() {
            return this.subactions;
        }
    }

    private static class ManualSplitSortPresetAction
    extends AbstractTypedManualSplitSortAction
    implements Runnable {
        private final String presetName;

        ManualSplitSortPresetAction(IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType, String string) {
            super(iDisplaySetProvider, manualSplitAndSortPresetsType);
            this.presetName = string;
        }

        @Override
        public String getID() {
            return String.valueOf(this.type.getActionID()) + "_PRESET_" + this.presetName;
        }

        @Override
        public String getCaption() {
            return this.presetName;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed(String.valueOf(this.type.getActionID()) + "_PRESET");
            EventQueue.invokeLater(this);
            return true;
        }

        @Override
        public void run() {
            try {
                CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                IDisplaySet iDisplaySet = this.provider.getDisplaySet();
                if (iDisplaySet != null) {
                    this.type.applyManualSplitAndSort(iDisplaySet, new ManualSplitAndSortPresets(this.type).loadPreset(this.presetName));
                }
            }
            finally {
                CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
            }
        }
    }

    private static class RevertDisplaySet
    extends AbstractManualSplitSortAction
    implements ManualSortSplitProcessor.IFrameSorter {
        RevertDisplaySet(IDisplaySetProvider iDisplaySetProvider) {
            super(iDisplaySetProvider);
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.RevertDisplaySet");
        }

        @Override
        public String getID() {
            return "REVERT_DISPLAY_SET";
        }

        @Override
        public boolean perform(Component component) {
            IDisplaySet iDisplaySet = this.provider.getDisplaySet();
            if (iDisplaySet == null) {
                return false;
            }
            this.notifyActionPerformed();
            ManualSortSplitProcessor.getInstance().changeImageSort(iDisplaySet, this);
            return true;
        }

        @Override
        public void sort(IFrameObjectData[] iFrameObjectDataArray) {
            ArrayUtils.reverse((Object[])iFrameObjectDataArray);
        }
    }
}

