/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.frameofreference.IFrameOfReference;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransform;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.runtime.LayoutRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.SessionDisplay;
import com.agfa.pacs.impaxee.sessions.SessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.agfa.pacs.impaxee.sessions.SessionLyt;
import com.agfa.pacs.impaxee.sessions.SessionObject;
import com.agfa.pacs.impaxee.setlive.ISetLivePlugin;
import com.agfa.pacs.impaxee.setlive.SetLiveSecondaryCaptures;
import com.agfa.pacs.impaxee.setlive.SetLiveUtil;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.util.UIDUtils;

public class SessionSnapshotRuntime
extends AbstractSnapshotRuntime {
    private String snapshotUID = UIDUtils.createUID();
    private List<String> patNames = new ArrayList<String>();
    private String selectedPatName = "";
    private String selectedPatID = "";
    private SessionLyt layout;
    private List<SessionDisplay> disps = new ArrayList<SessionDisplay>();
    private final IHangingSession parent;
    private final SetLiveSecondaryCaptures setLiveData;

    public SessionSnapshotRuntime(String string, IHangingSession iHangingSession) {
        super(string);
        this.parent = iHangingSession;
        this.setLiveData = new SetLiveSecondaryCaptures();
    }

    public IHangingSession getParent() {
        return this.parent;
    }

    public void write(DataOutputStream dataOutputStream) throws Throwable {
        dataOutputStream.writeUTF(this.snapshotUID);
        dataOutputStream.writeUTF(this.getName());
        dataOutputStream.writeInt(this.patNames.size());
        for (String string : this.patNames) {
            dataOutputStream.writeUTF(string);
        }
        dataOutputStream.writeUTF(String.valueOf(this.selectedPatName) + "|" + this.selectedPatID);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SessionDisplay sessionDisplay : this.disps) {
            SessionDisplaySet sessionDisplaySet = sessionDisplay.getSessionDisplaySet();
            if (sessionDisplaySet == null) continue;
            arrayList.add(sessionDisplaySet.getSessionSeqUID());
        }
        dataOutputStream.writeInt(arrayList.size());
        for (String string : arrayList) {
            dataOutputStream.writeUTF(string);
        }
        dataOutputStream.writeInt(this.disps.size());
        for (SessionDisplay sessionDisplay : this.disps) {
            sessionDisplay.write(dataOutputStream);
        }
        this.layout.write(dataOutputStream);
    }

    public void read(DataInputStream dataInputStream, SessionKeyObject sessionKeyObject, List<SessionDisplaySet> list, int n) throws IOException {
        this.snapshotUID = dataInputStream.readUTF();
        String string = dataInputStream.readUTF();
        if (string.trim().length() == 0) {
            string = Integer.toString(n + 1);
        }
        this.setName(string);
        int n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            this.patNames.add(dataInputStream.readUTF());
            ++n3;
        }
        this.selectedPatName = dataInputStream.readUTF();
        n3 = dataInputStream.readInt();
        int n4 = 0;
        while (n4 < n3) {
            dataInputStream.readUTF();
            ++n4;
        }
        n4 = dataInputStream.readInt();
        this.disps.clear();
        int n5 = 0;
        while (n5 < n4) {
            this.disps.add(new SessionDisplay(dataInputStream, list, this));
            ++n5;
        }
        this.layout = new SessionLyt(dataInputStream, sessionKeyObject, n);
    }

    public List<SessionDisplay> displays() {
        return this.disps;
    }

    @Override
    public LayoutRuntime getLayout() {
        return this.layout.convert(this.disps);
    }

    public void capture() {
        DataSelectionManager dataSelectionManager = DataSelectionManager.getInstance();
        IPatientRepresentation iPatientRepresentation = dataSelectionManager.getCurrentPatient();
        this.selectedPatName = iPatientRepresentation.getPatientData().getDicomObject().getString(0x100010);
        this.selectedPatID = iPatientRepresentation.getPatientData().getDicomObject().getString(0x100020);
        List<IPatientData> list = this.captureDisplays();
        this.captureWorldToWorldTransforms(list);
        this.layout = new SessionLyt(JVision2.getMainFrame());
        this.patNames.clear();
        for (IPatientData iPatientData : list) {
            String string = String.valueOf(iPatientData.getDicomObject().getString(0x100010)) + "|" + iPatientData.getDicomObject().getString(0x100020);
            if (this.patNames.contains(string)) continue;
            this.patNames.add(string);
        }
    }

    private List<IPatientData> captureDisplays() {
        MainFrame2 mainFrame2 = JVision2.getMainFrame();
        ArrayList<IPatientData> arrayList = new ArrayList<IPatientData>();
        this.disps.clear();
        for (VisDisplay2 object : mainFrame2.getDisplays()) {
            if (object.hasData()) {
                IDisplaySet iDisplaySet = null;
                if (this.parent.isSetLiveEnabled() && object.getData().getDisplayPlugin() instanceof ISetLivePlugin) {
                    iDisplaySet = SetLiveUtil.createSecondaryCapture(object.getData(), (ISetLivePlugin)((Object)object.getData().getDisplayPlugin()));
                }
                if (iDisplaySet == null) {
                    iDisplaySet = object.getData().getDisplaySet();
                } else {
                    this.setLiveData.addDisplaySet(iDisplaySet);
                    if (((Session)this.parent).findDisplaySet(iDisplaySet) == null) {
                        this.parent.getSplitAndSortRuntime().addDisplaySet(iDisplaySet);
                    }
                }
                IPatientData iPatientData = object.getData().getPatientRepresentation().getPatientData();
                arrayList.add(iPatientData);
                SessionDisplaySet sessionDisplaySet = ((Session)this.parent).findDisplaySet(iDisplaySet);
                if (sessionDisplaySet == null) {
                    SessionDisplaySet sessionDisplaySet2 = new SessionDisplaySet(iDisplaySet, this.parent.getSplitAndSortRuntime());
                    this.disps.add(new SessionDisplay(object, sessionDisplaySet2, this));
                    ((Session)this.parent).getSessionDisplaySets().add(sessionDisplaySet2);
                    continue;
                }
                this.disps.add(new SessionDisplay(object, sessionDisplaySet, this));
                continue;
            }
            this.disps.add(new SessionDisplay(this));
        }
        if (this.isMissingPresentationStates()) {
            String string = Messages.getString("SessionSnapshotRuntime.PresentationStateFailure.Title");
            String string2 = Messages.getString("SessionSnapshotRuntime.PresentationStateFailure.Message");
            Message.warning(string, string2);
        }
        return arrayList;
    }

    private boolean isMissingPresentationStates() {
        for (SessionDisplay sessionDisplay : this.disps) {
            if (!sessionDisplay.isMissingPresentationStates()) continue;
            return true;
        }
        return false;
    }

    private void captureWorldToWorldTransforms(Iterable<IPatientData> iterable) {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, IObjectInfo> hashMap = new HashMap<String, IObjectInfo>(3);
        for (IPatientData object2 : iterable) {
            if (hashSet.contains(object2.getKey()) || !object2.existsWorldToWorldTransforms()) continue;
            for (IFrameOfReference iFrameOfReference : FrameOfReferenceManager.getFramesOfPatient(object2.getKey())) {
                for (String string : iFrameOfReference.getFrameOfReferenceUIDsWithWorldToWorldTransform()) {
                    IObjectInfo iObjectInfo;
                    String string2;
                    IWorldToWorldTransform iWorldToWorldTransform = iFrameOfReference.getWorldToWorldTransform(string);
                    if (iWorldToWorldTransform == null || iWorldToWorldTransform.getObjectInfo() == null || hashMap.containsKey(string2 = (iObjectInfo = iWorldToWorldTransform.getObjectInfo()).getKey())) continue;
                    hashMap.put(string2, iObjectInfo);
                }
            }
            hashSet.add(object2.getKey());
        }
        Session session = (Session)this.parent;
        for (IObjectInfo iObjectInfo : hashMap.values()) {
            session.addAdditionalObject(new SessionObject((ILoadableInfo)iObjectInfo));
        }
    }

    void collectUnsavedSetLiveData(Collection<IObjectData> collection) {
        this.setLiveData.collectUnsavedData(collection);
    }

    String[] getSpecialScreenLayouts() {
        return this.layout.getSpecialScreenLayouts();
    }

    public boolean equals(SessionSnapshotRuntime sessionSnapshotRuntime) {
        if (this == sessionSnapshotRuntime) {
            return true;
        }
        if (!this.selectedPatName.equals(sessionSnapshotRuntime.selectedPatName)) {
            return false;
        }
        if (this.patNames.size() != sessionSnapshotRuntime.patNames.size()) {
            return false;
        }
        if (this.disps.size() != sessionSnapshotRuntime.disps.size()) {
            return false;
        }
        int n = 0;
        while (n < this.patNames.size()) {
            if (!this.patNames.get(n).equals(sessionSnapshotRuntime.patNames.get(n))) {
                return false;
            }
            ++n;
        }
        if (!this.layout.equals(sessionSnapshotRuntime.layout)) {
            return false;
        }
        n = 0;
        while (n < this.disps.size()) {
            if (!this.disps.get(n).equals(sessionSnapshotRuntime.disps.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public SessionSnapshotRuntime cloneForSave() {
        SessionSnapshotRuntime sessionSnapshotRuntime = new SessionSnapshotRuntime(this.getName(), this.getParent());
        sessionSnapshotRuntime.snapshotUID = this.snapshotUID;
        sessionSnapshotRuntime.layout = this.layout;
        sessionSnapshotRuntime.selectedPatName = this.selectedPatName;
        sessionSnapshotRuntime.patNames.addAll(this.patNames);
        sessionSnapshotRuntime.disps.clear();
        for (SessionDisplay sessionDisplay : this.disps) {
            sessionSnapshotRuntime.disps.add(sessionDisplay.cloneForSave());
        }
        return sessionSnapshotRuntime;
    }

    public SessionSnapshotRuntime clone() {
        return this.cloneForSave();
    }
}

