/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.impaxee.keyimages.KeyImageObject;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IKeyObjectData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class SessionKeyObject
extends KeyImageObject {
    private byte[] sessionData;
    private String patientKeyIftemporaryMerged;
    private String[] studyOrdering;
    private List<String[]> specialScreenLayouts;

    public SessionKeyObject(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject, byte[] byArray, String string) {
        super(keyObjectSelectionDocumentInformationObject, CodeDictionary.KeyObjectSelectionDocumentTitle.JVisionSession);
        this.setContentDateTime(new Date());
        this.sessionData = byArray;
        this.patientKeyIftemporaryMerged = string;
    }

    @Override
    public Attributes toDataset(IKeyObjectData iKeyObjectData) {
        Attributes attributes = super.toDataset(iKeyObjectData);
        attributes.setBytes("TIANI", 2687058, VR.OB, this.sessionData);
        if (this.patientKeyIftemporaryMerged != null) {
            attributes.setString("TIANI", 2687059, VR.LO, this.patientKeyIftemporaryMerged);
        }
        attributes.setString("TIANI", 2687060, VR.UI, this.studyOrdering);
        Sequence sequence = attributes.ensureSequence("TIANI", 2687061, this.specialScreenLayouts.size());
        for (String[] stringArray : this.specialScreenLayouts) {
            Attributes attributes2 = new Attributes();
            attributes2.setString("TIANI", 2687062, VR.LO, stringArray);
            sequence.add(attributes2);
        }
        return attributes;
    }

    public byte[] getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(byte[] byArray) {
        this.sessionData = byArray;
    }

    public void setSessionData(Attributes attributes) {
        try {
            this.sessionData = attributes.getBytes("TIANI", 2687058);
        }
        catch (IOException iOException) {
            ALogger.getLogger(SessionKeyObject.class).error("Bulk error data", (Throwable)iOException);
        }
    }

    public void clearReferences() {
        this.referencedComposites = new ArrayList();
        this.referencedImages = new ArrayList();
        this.referencedWaveforms = new ArrayList();
        this.references = new ArrayList();
        this.kosdio.getKeyObjectDocument().currentRequestedProcedureEvidences().clear();
    }

    String[] getStudyOrdering() {
        if (this.studyOrdering == null) {
            return null;
        }
        return Arrays.copyOf(this.studyOrdering, this.studyOrdering.length);
    }

    public void setStudyOrdering(String[] stringArray) {
        this.studyOrdering = stringArray;
    }

    public String getSpecialScreenLayouts(int n, int n2) {
        String string;
        String[] stringArray;
        if (this.specialScreenLayouts != null && n2 < (stringArray = this.specialScreenLayouts.get(n)).length && (string = stringArray[n2]) != null && !string.isEmpty()) {
            return string;
        }
        return null;
    }

    public void setSpecialScreenLayouts(List<String[]> list) {
        this.specialScreenLayouts = list;
    }
}

