/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.presentationstate;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.presentationstate.TemporaryPresentationStateUnsavedItem;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.ISaveItemFactory;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.swing.Icon;
import org.dcm4che3.data.Attributes;

public class TemporaryPresentationStateUnsavedItemFactory
implements ISaveItemFactory {
    private static final Icon PS_ICON = IAIconFactory.DEFAULT_FACTORY.loadIcon("neutral_presstate_hr.svg");
    private IStudyData studyData;
    private Attributes dicomData;

    public TemporaryPresentationStateUnsavedItemFactory(IStudyData iStudyData, Attributes attributes) {
        this.studyData = iStudyData;
        this.dicomData = attributes;
    }

    @Override
    public ISaveItem newSaveItem(IPatientRepresentation iPatientRepresentation) {
        return new TemporaryPresentationStateUnsavedItem(this.studyData, this.dicomData);
    }

    @Override
    public String getVisibleName() {
        String string = ((Attributes)this.dicomData.getSequence(528661).get(0)).getString(0x20000E);
        ISeriesData iSeriesData = DataManager.getInstance().getSerie(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy", Locale.getDefault());
        return String.valueOf(Messages.getString("UnsavedItems.PresentationState.Name.Prefix")) + " (" + Messages.getString("UnsavedItems.StudyOf") + " " + simpleDateFormat.format(this.studyData.getDicomObject().getDate(524320)) + ", " + Messages.getString("UnsavedItems.Series") + " " + iSeriesData.getDicomObject().getInt(0x200011, 0) + ")";
    }

    @Override
    public Icon getIcon() {
        return PS_ICON;
    }
}

