/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.presentationstate;

import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.BitmapDisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayCurveActivationModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlane;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlaneModule;
import com.agfa.pacs.listtext.dicomobject.presentation.OverlayContainer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.logging.ALogger;
import java.util.HashMap;
import java.util.Map;

public class OverlayFrameCollector {
    private static final ALogger log = ALogger.getLogger(OverlayFrameCollector.class);
    private Map<Integer, OverlayGroup> frames = new HashMap<Integer, OverlayGroup>();

    public void addOverlayFrame(int n, OverlayFrame overlayFrame, String string, String string2, boolean bl) {
        int n2 = overlayFrame.getOverlay().getGroupTag();
        if (!this.frames.containsKey(n2)) {
            this.frames.put(n2, new OverlayGroup(bl));
        }
        this.frames.get(n2).putFrame(n, overlayFrame, string, string2, bl);
    }

    public void storeTo(SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject, String string) {
        if (this.frames.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, OverlayGroup> entry : this.frames.entrySet()) {
            OverlayPlaneModule overlayPlaneModule;
            int n = entry.getKey();
            OverlayGroup overlayGroup = entry.getValue();
            if (overlayGroup.providerUID != null && overlayGroup.providerUID.equals(string)) {
                overlayPlaneModule = (OverlayCurveActivationModule)softcopyPresentationStateInformationObject.getModuleCreate(OverlayCurveActivationModule.class);
                if (!overlayGroup.shutter) {
                    overlayPlaneModule.setOverlayActivationLayer(n, overlayGroup.layer);
                }
            } else {
                overlayPlaneModule = (OverlayPlaneModule)softcopyPresentationStateInformationObject.getModuleCreate(OverlayPlaneModule.class);
                OverlayPlane overlayPlane = overlayGroup.createOverlayPlane();
                overlayPlaneModule.overlayPlanes().add(overlayPlane);
            }
            if (!overlayGroup.shutter) continue;
            overlayPlaneModule = (BitmapDisplayShutterModule)softcopyPresentationStateInformationObject.getModuleCreate(BitmapDisplayShutterModule.class);
            overlayPlaneModule.setShutterOverlayGroup(entry.getKey());
        }
    }

    private static class OverlayGroup {
        public String providerUID;
        public String layer;
        public boolean shutter;
        public Map<Integer, OverlayFrame> frames;

        public OverlayGroup(boolean bl) {
            this.shutter = bl;
            this.frames = new HashMap<Integer, OverlayFrame>();
        }

        public void putFrame(int n, OverlayFrame overlayFrame, String string, String string2, boolean bl) {
            this.frames.put(n, overlayFrame);
            if (this.providerUID == null) {
                this.providerUID = string2;
            } else if (!this.providerUID.equals(string2)) {
                log.warn("OverlayGroup: Group and providerUID do not match");
                log.warn("OverlayGroup: Group: " + this.providerUID + " != " + string2);
            }
            if (this.layer == null) {
                this.layer = string;
            } else if (!this.layer.equals(string)) {
                log.warn("OverlayGroup: Group and layer do not match");
                log.warn("OverlayGroup: Group : " + this.layer + " != " + string);
            }
            if (this.shutter != bl) {
                log.warn("OverlayGroup: shutters do not match");
                log.warn("OverlayGroup: Group: " + this.shutter + " != " + bl);
            }
        }

        public OverlayPlane createOverlayPlane() {
            OverlayContainer overlayContainer = new OverlayContainer();
            for (Map.Entry<Integer, OverlayFrame> entry : this.frames.entrySet()) {
                overlayContainer.setOverlayFrame(entry.getValue(), entry.getKey().intValue());
            }
            return overlayContainer.toOverlayPlane();
        }
    }
}

