/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.mousemodeinfo;

import java.util.Collection;
import java.util.HashSet;

public enum MouseSubModes {
    DEFAULT(false),
    ZOOM_PAN(false, false),
    ZOOM_RECT(false),
    REGISTRATION(false),
    MEASURE_DISTANCE(false, true),
    MEASURE_ANGLE(false, true),
    MEASURE_COBB_ANGLE(false, true),
    MEASURE_NORMAL_DISTANCE(false, true),
    MEASURE_RATIO(false, true),
    MEASURE_BIDIMENSIONAL_LENGTH(false, true),
    MEASURE_HORIZONTAL_DISTANCE(false, true),
    MEASURE_DOUBLE_CENTERLINE(false, true),
    DRAW_CENTERLINE(false),
    DRAW_ARROW(false),
    DRAW_TEXT(false),
    DRAW_CIRCLE(false),
    DRAW_CIRCLE_3POINT(false),
    DRAW_ELLIPSE(false),
    DRAW_RECTANGLE(false),
    DRAW_POLYGON(false),
    DRAW_SPLINECURVE(false),
    LEFT(false),
    RIGHT(false),
    CALIBRATION_SPHERE(true),
    CALIBRATION_CATHETERFIRSTLINE(true),
    CALIBRATION_CATHETERSECONDLINE(true),
    CALIBRATION_MARKER(true),
    CALIBRATION_LINE(true),
    SEGMENTATION_STARTPOINT(true),
    SEGMENTATION_ENDPOINT(true),
    DRAW_DENT_SPLINE(true),
    SET_POINT(true),
    DRAW_EMPR_SPLINE(true),
    DRAW_REFORMAT_LINE(true),
    EDIT_EMPR_SPLINE(true),
    EMPR_SEGMENTATION_PICK_STRUCTURE(true, false, true),
    EMPR_SEGMENTATION_PICK_BRUSH(true, false, true),
    EMPR_SEGMENTATION_VOLUMETRY_GROW(true, false, true),
    EMPR_SEGMENTATION_VOLUMETRY_MODIFY(true, false, true),
    EMPR_SEGMENTATION_DRAW_BACKGROUND_POLYGON(false),
    EMPR_SEGMENTATION_DRAW_STRUCTURE_POLYGON(false),
    EMPR_SEGMENTATION_ADDITION_FREEHAND_POLYGON(false),
    EMPR_SEGMENTATION_SUBTRACTION_FREEHAND_POLYGON(false),
    EMPR_SEGMENTATION_CUT_INTERIOR_POLYGON(false),
    EMPR_SEGMENTATION_CUT_SURROUDING_POLYGON(false),
    ELLIPSE_1(true),
    ELLIPSE_2(true),
    CENTER_MIRRORLINE(true),
    DRAW_SPINE_LABEL(true),
    ADD_CONTROLPOINT(true),
    INSERT_CONTROLPOINT(true),
    DELETE_CONTROLPOINT(true);

    private static Collection<MouseSubModes> measurementModes;
    boolean pluginMouseMode;
    private boolean isMeasurement;
    private boolean isSegmentation;

    private MouseSubModes(boolean bl) {
        this(bl, false);
    }

    private MouseSubModes(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    private MouseSubModes(boolean bl, boolean bl2, boolean bl3) {
        this.pluginMouseMode = bl;
        this.isMeasurement = bl2;
        this.isSegmentation = bl3;
    }

    public String toString() {
        return this.name();
    }

    public boolean isPluginMouseMode() {
        return this.pluginMouseMode;
    }

    public boolean isMeasurement() {
        return this.isMeasurement;
    }

    public boolean isSegmentation() {
        return this.isSegmentation;
    }

    public static Collection<MouseSubModes> getMeasurementSubModes() {
        if (measurementModes == null) {
            HashSet<MouseSubModes> hashSet = new HashSet<MouseSubModes>();
            MouseSubModes[] mouseSubModesArray = MouseSubModes.values();
            int n = mouseSubModesArray.length;
            int n2 = 0;
            while (n2 < n) {
                MouseSubModes mouseSubModes = mouseSubModesArray[n2];
                if (mouseSubModes.isMeasurement()) {
                    hashSet.add(mouseSubModes);
                }
                ++n2;
            }
            measurementModes = hashSet;
        }
        return measurementModes;
    }
}

