/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.mousemodeinfo;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeInfoGlobal;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class MouseModeFillActionProvider
implements PActionProvider {
    private static final String ID_PREFIX = "FILL_MODE_";
    private static IMouseModeInfo mouseMode = MouseModeInfoGlobal.getInstance();
    private static List<PAction> cachedActions;

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        FillMode[] fillModeArray = FillMode.values();
        int n = fillModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FillMode fillMode = fillModeArray[n2];
            arrayList.add(new MouseModeFillAction(fillMode));
            ++n2;
        }
        cachedActions = new ArrayList<PAction>(arrayList);
        return arrayList;
    }

    private void modeChanged() {
        for (PAction pAction : cachedActions) {
            pAction.fireSelectionChanged();
        }
    }

    private String getIconImpl(FillMode fillMode) {
        return "markup_fill_" + fillMode.name() + ".svg";
    }

    public static String getIDForMode(FillMode fillMode) {
        return ID_PREFIX + fillMode.name();
    }

    public static enum FillMode {
        Normal,
        Filled,
        Shutter;


        public boolean isFilled() {
            return this == Filled;
        }

        public boolean isShuttered() {
            return this == Shutter;
        }
    }

    private class MouseModeFillAction
    extends SelectablePAction {
        private FillMode mode;

        public MouseModeFillAction(FillMode fillMode) {
            super(MouseModeFillActionProvider.this.getIconImpl(fillMode));
            this.mode = fillMode;
        }

        @Override
        public String getCaption() {
            return Messages.getString("MAIN_TOOLTIP_BTN_ROI_" + this.mode.name());
        }

        @Override
        public String getGroupName() {
            return MARKUPS_GROUP;
        }

        @Override
        public String getID() {
            return MouseModeFillActionProvider.getIDForMode(this.mode);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("MAIN_TOOLTIP_BTN_ROI_" + this.mode.name());
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            boolean bl = !this.isSelected();
            this.setFillStatus(bl, mouseMode);
            for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
                IMouseModeInfo iMouseModeInfo = visDisplay2.getData().getDisplayPlugin().getMouseModeInfo();
                if (mouseMode == iMouseModeInfo) continue;
                this.setFillStatus(bl, iMouseModeInfo);
            }
            MouseModeFillActionProvider.this.modeChanged();
            return true;
        }

        private void setFillStatus(boolean bl, IMouseModeInfo iMouseModeInfo) {
            if (!bl) {
                iMouseModeInfo.setROIFilled(false);
                iMouseModeInfo.setROIShuttered(false);
            } else {
                iMouseModeInfo.setROIFilled(this.mode.isFilled());
                iMouseModeInfo.setROIShuttered(this.mode.isShuttered());
            }
        }

        @Override
        public boolean isSelected() {
            return mouseMode.isROIFilled() == this.mode.isFilled() && mouseMode.isROIShuttered() == this.mode.isShuttered();
        }
    }
}

