/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.menu;

import com.agfa.pacs.base.data.action.DataActionFactory;
import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.fetcher.IDataHandlerProvider;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.listtext.lta.util.referencedobject.XDSDataInfoNode;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractExportDataAction
extends AbstractPDataAction {
    private static final ALogger log = ALogger.getLogger(AbstractExportDataAction.class);
    private static final IDataHandlerProvider dataHandler = DataHandlerProviderFactory.getInstance().getDataHandlerProvider();
    private final String actionCode;

    protected AbstractExportDataAction(String string) {
        this.actionCode = string;
    }

    protected abstract String getActionTitle();

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new ExportAction(pDataScope, pDataProvider);
    }

    private boolean isEnabled2() {
        if (Product.isCDViewer()) {
            return false;
        }
        IDataAction iDataAction = DataActionFactory.getInstance().getActionForCode(this.actionCode);
        if (iDataAction == null) {
            return false;
        }
        return iDataAction.isAllowed();
    }

    private List<VisData> filterXDSObjects(List<VisData> list) {
        ArrayList<VisData> arrayList = new ArrayList<VisData>(list.size());
        for (VisData visData : list) {
            IDataInfoSource iDataInfoSource = visData.getParent().getDisplaySet().getOneObject().getQueryObject().getSource();
            if (iDataInfoSource instanceof XDSDataInfoNode) continue;
            arrayList.add(visData);
        }
        return arrayList;
    }

    private class ExportAction
    extends AbstractPDataAction.AbstractInnerPAction {
        public ExportAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            if (this.provider != null) {
                return AbstractExportDataAction.this.getActionTitle();
            }
            return this.scope.getName();
        }

        @Override
        public String getName() {
            if (this.provider != null) {
                return AbstractExportDataAction.this.getActionTitle();
            }
            return String.valueOf(AbstractExportDataAction.this.getActionTitle()) + " - " + this.scope.getName();
        }

        @Override
        public boolean isAvailable() {
            return AbstractExportDataAction.this.isEnabled2();
        }

        @Override
        public String getGroupName() {
            return EXPORT_PRINT_GROUP;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            IPerform iPerform = DataManager.getInstance().getDataPerform(AbstractExportDataAction.this.actionCode);
            if (iPerform == null) {
                log.error("Could not find export extension");
                return false;
            }
            List<VisData> list = this.provider != null ? this.provider.getVisDatas() : AbstractExportDataAction.getVisDatas(this.scope);
            List list2 = AbstractExportDataAction.this.filterXDSObjects(list);
            if (list2.size() != list.size()) {
                ComponentFactory.instance.showErrorDialog(Messages.getString("AbstractExportDataAction.XDSRemovedTitle"), Messages.getString("AbstractExportDataAction.XDSRemovedMessage"), component);
                if (list2.size() == 0) {
                    return false;
                }
            }
            List<IDataObject> list3 = dataHandler.createRenderableObjects(list2);
            iPerform.perform(new IPerform.DefaultPerformContext(JVision2.getMainFrame(), null), list3);
            return true;
        }
    }
}

